"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const datahub_generated_1 = require("./datahub.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return datahub_generated_1.RosTopic; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DATAHUB::Topic`, which is used to create a topic.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTopic`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-datahub-topic
 */
class Topic extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTopic = new datahub_generated_1.RosTopic(this, id, {
            comment: props.comment,
            recordType: props.recordType,
            projectName: props.projectName,
            lifecycle: props.lifecycle === undefined || props.lifecycle === null ? 3 : props.lifecycle,
            recordSchema: props.recordSchema,
            topicName: props.topicName,
            shardCount: props.shardCount === undefined || props.shardCount === null ? 1 : props.shardCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrProjectName = rosTopic.attrProjectName;
        this.attrTopicName = rosTopic.attrTopicName;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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