# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jet',
 'jet.dashboard',
 'jet.dashboard.migrations',
 'jet.dashboard.modules',
 'jet.dashboard.modules.google_analytics',
 'jet.dashboard.modules.yandex_metrika',
 'jet.dashboard.templatetags',
 'jet.management',
 'jet.management.commands',
 'jet.migrations',
 'jet.templatetags']

package_data = \
{'': ['*'],
 'jet': ['locale/ar/LC_MESSAGES/django.po',
         'locale/ar/LC_MESSAGES/django.po',
         'locale/ar/LC_MESSAGES/djangojs.po',
         'locale/ar/LC_MESSAGES/djangojs.po',
         'locale/cs/LC_MESSAGES/django.po',
         'locale/cs/LC_MESSAGES/django.po',
         'locale/cs/LC_MESSAGES/djangojs.po',
         'locale/cs/LC_MESSAGES/djangojs.po',
         'locale/de/LC_MESSAGES/django.po',
         'locale/de/LC_MESSAGES/django.po',
         'locale/de/LC_MESSAGES/djangojs.po',
         'locale/de/LC_MESSAGES/djangojs.po',
         'locale/en/LC_MESSAGES/django.po',
         'locale/en/LC_MESSAGES/django.po',
         'locale/en/LC_MESSAGES/djangojs.po',
         'locale/en/LC_MESSAGES/djangojs.po',
         'locale/es/LC_MESSAGES/django.po',
         'locale/es/LC_MESSAGES/django.po',
         'locale/es/LC_MESSAGES/djangojs.po',
         'locale/es/LC_MESSAGES/djangojs.po',
         'locale/fa/LC_MESSAGES/django.po',
         'locale/fa/LC_MESSAGES/django.po',
         'locale/fa/LC_MESSAGES/djangojs.po',
         'locale/fa/LC_MESSAGES/djangojs.po',
         'locale/fr/LC_MESSAGES/django.po',
         'locale/fr/LC_MESSAGES/django.po',
         'locale/fr/LC_MESSAGES/djangojs.po',
         'locale/fr/LC_MESSAGES/djangojs.po',
         'locale/pl/LC_MESSAGES/django.po',
         'locale/pl/LC_MESSAGES/django.po',
         'locale/pl/LC_MESSAGES/djangojs.po',
         'locale/pl/LC_MESSAGES/djangojs.po',
         'locale/pt_BR/LC_MESSAGES/django.po',
         'locale/pt_BR/LC_MESSAGES/django.po',
         'locale/pt_BR/LC_MESSAGES/djangojs.po',
         'locale/pt_BR/LC_MESSAGES/djangojs.po',
         'locale/ru/LC_MESSAGES/django.po',
         'locale/ru/LC_MESSAGES/django.po',
         'locale/ru/LC_MESSAGES/djangojs.po',
         'locale/ru/LC_MESSAGES/djangojs.po',
         'locale/zh_CN/LC_MESSAGES/django.po',
         'static/admin/css/*',
         'static/admin/js/*',
         'static/admin/js/admin/*',
         'static/jet/css/icons/fonts/*',
         'static/jet/css/icons/style.css',
         'static/jet/css/jquery-ui/images/*',
         'static/range_filter/css/*',
         'templates/admin/*',
         'templates/admin/edit_inline/*',
         'templates/admin/includes/*',
         'templates/jet/*',
         'templates/jet/sidebar/*',
         'templates/rangefilter/*'],
 'jet.dashboard': ['locale/ar/LC_MESSAGES/django.po',
                   'locale/ar/LC_MESSAGES/django.po',
                   'locale/ar/LC_MESSAGES/djangojs.po',
                   'locale/ar/LC_MESSAGES/djangojs.po',
                   'locale/cs/LC_MESSAGES/django.po',
                   'locale/cs/LC_MESSAGES/django.po',
                   'locale/cs/LC_MESSAGES/djangojs.po',
                   'locale/cs/LC_MESSAGES/djangojs.po',
                   'locale/de/LC_MESSAGES/django.po',
                   'locale/de/LC_MESSAGES/django.po',
                   'locale/de/LC_MESSAGES/djangojs.po',
                   'locale/de/LC_MESSAGES/djangojs.po',
                   'locale/en/LC_MESSAGES/django.po',
                   'locale/en/LC_MESSAGES/django.po',
                   'locale/en/LC_MESSAGES/djangojs.po',
                   'locale/en/LC_MESSAGES/djangojs.po',
                   'locale/es/LC_MESSAGES/django.po',
                   'locale/es/LC_MESSAGES/django.po',
                   'locale/es/LC_MESSAGES/djangojs.po',
                   'locale/es/LC_MESSAGES/djangojs.po',
                   'locale/fa/LC_MESSAGES/django.po',
                   'locale/fa/LC_MESSAGES/django.po',
                   'locale/fa/LC_MESSAGES/djangojs.po',
                   'locale/fa/LC_MESSAGES/djangojs.po',
                   'locale/fr/LC_MESSAGES/django.po',
                   'locale/fr/LC_MESSAGES/django.po',
                   'locale/fr/LC_MESSAGES/djangojs.po',
                   'locale/fr/LC_MESSAGES/djangojs.po',
                   'locale/pl/LC_MESSAGES/django.po',
                   'locale/pt-br/LC_MESSAGES/django.po',
                   'locale/pt-br/LC_MESSAGES/django.po',
                   'locale/pt-br/LC_MESSAGES/djangojs.po',
                   'locale/pt-br/LC_MESSAGES/djangojs.po',
                   'locale/ru/LC_MESSAGES/django.po',
                   'locale/ru/LC_MESSAGES/django.po',
                   'locale/ru/LC_MESSAGES/djangojs.po',
                   'locale/ru/LC_MESSAGES/djangojs.po',
                   'locale/zh_cn/LC_MESSAGES/django.po',
                   'static/jet.dashboard/modules/*',
                   'static/jet.dashboard/vendor/chart.js/*',
                   'templates/admin/*',
                   'templates/jet.dashboard/*',
                   'templates/jet.dashboard/modules/*']}

install_requires = \
['django-autocomplete-light>=3.5.1,<4.0.0', 'django>=3,<4']

extras_require = \
{'google_analytics': ['google-api-python-client==1.4.1']}

setup_kwargs = {
    'name': 'djet2',
    'version': '1.0.9a4',
    'description': 'Modern template for Django admin interface with improved functionality',
    'long_description': "# Django JET\n\n![image](https://raw.githubusercontent.com/geex-arts/jet/static/logo.png)\n\n\n**what**|**where**\n-----|-----\nmaster tests|[![image][master-tests-badge]][master-tests]\ndev tests|[![image][dev-tests-badge]][dev-tests]\nlive demo|http://demo.jet.geex-arts.com/admin/\ndocumentation|http://jet.readthedocs.org/\nPyPi|https://pypi.org/project/djet2\n\n[master-tests]: https://github.com/vanyakosmos/djet2/actions?query=workflow%3Atest+branch%3Amaster\n[master-tests-badge]: https://github.com/vanyakosmos/djet2/workflows/test/badge.svg?branch=master\n[dev-tests]: https://github.com/vanyakosmos/djet2/actions?query=workflow%3Atest+branch%3Adev\n[dev-tests-badge]: https://github.com/vanyakosmos/djet2/workflows/test/badge.svg?branch=dev\n\n\n## Why Django JET?\n\n- New fresh look\n- Responsive mobile interface\n- Useful admin home page\n- Minimal template overriding\n- Easy integration\n- Themes support\n- Autocompletion\n- Handy controls\n\n## Screenshots\n\n![image](https://raw.githubusercontent.com/geex-arts/django-jet/static/screen1.png)\n\n![image](https://raw.githubusercontent.com/geex-arts/django-jet/static/screen2.png)\n\n![image](https://raw.githubusercontent.com/geex-arts/django-jet/static/screen3.png)\n\n## Installation\n\n- Download and install latest version of Django JET:\n\n```bash\npip install djet2\n```\n\n- Add 'jet' application to the INSTALLED\\_APPS setting of your Django project \nsettings.py file (note it should be before 'django.contrib.admin'):\n\n```python\nINSTALLED_APPS = (\n    ...,\n    'jet',\n    'django.contrib.admin',\n)\n```\n\n- Make sure `django.template.context_processors.request` context processor \nis enabled in settings.py (Django 1.8+ way):\n\n```python\nTEMPLATES = [\n    {\n        'BACKEND': 'django.template.backends.django.DjangoTemplates',\n        'DIRS': [],\n        'APP_DIRS': True,\n        'OPTIONS': {\n            'context_processors': [\n                ...,\n                'django.template.context_processors.request',\n                ...,\n            ],\n        },\n    },\n]\n```\n\n- Add URL-pattern to the urlpatterns of your Django project urls.py file \n(they are needed for related–lookups and autocompletes):\n\n```python\nurlpatterns = patterns(\n    '',\n    path('jet/', include('jet.urls', 'jet')),  # Django JET URLS\n    path('admin/', include(admin.site.urls)),\n    ...\n)\n```\n\n- Create database tables:\n\n```bash\npython manage.py migrate jet\n```\n\n- Collect static if you are in production environment:\n\n```bash\npython manage.py collectstatic\n```\n\n- Clear your browser cache:\n    - firefox/chrome: <kbd>Cmd</kbd>+<kbd>Shift</kbd>+<kbd>R</kbd> (<kbd>Ctrl</kbd>+<kbd>Shift</kbd>+<kbd>R</kbd>) for hard reload\n\n## Dashboard installation\n\nDashboard is located into a separate application. So after a typical JET \ninstallation it won't be active. To enable dashboard application follow these steps:\n\n- Add 'jet.dashboard' application to the INSTALLED\\_APPS setting of your Django \nproject settings.py file (note it should be before 'jet'):\n\n```python\nINSTALLED_APPS = (\n    ...,\n    'jet.dashboard',\n    'jet',\n    'django.contrib.admin',\n    ...,\n)\n```\n\n- Add URL-pattern to the urlpatterns of your Django project urls.py file \n(they are needed for related–lookups and autocompletes):\n\n```python\nurlpatterns = patterns(\n    '',\n    path('jet/', include('jet.urls', 'jet')),  # Django JET URLS\n    path('jet/dashboard/', include('jet.dashboard.urls', 'jet-dashboard')),  # Django JET dashboard URLS\n    path('admin/', include(admin.site.urls)),\n    ...,\n)\n```\n\n- **For Google Analytics widgets only** install python package:\n\n```bash\npip install djet2[google_analytics]\n# or \npip install google-api-python-client==1.4.1\n```\n\n- Create database tables:\n\n```bash\npython manage.py migrate dashboard\n```\n\n- Collect static if you are in production environment:\n\n```bash\npython manage.py collectstatic\n```\n",
    'author': 'Denis Kildishev',
    'author_email': 'support@jet.geex-arts.com',
    'maintainer': 'Bachynin Ivan',
    'maintainer_email': 'bachynin.i@gmail.com',
    'url': 'https://github.com/vanyakosmos/djet2',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
