"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTestingExistingVpcSubnets = exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        // create a default keycloak workload with minimal required props
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            autoraServerless: true,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
class IntegTestingExistingVpcSubnets {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'keycloak-demo', { env });
        new index_1.KeyCloak(stack, 'KeyCloak', {
            certificateArn: stack.node.tryGetContext('ACM_CERT_ARN') || 'MOCK_ARN',
            vpc: ec2.Vpc.fromLookup(stack, 'Vpc', { vpcId: 'vpc-0417e46d' }),
            publicSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'pub-1a', 'subnet-5bbe7b32'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1b', 'subnet-0428367c'),
                    ec2.Subnet.fromSubnetId(stack, 'pub-1c', 'subnet-1586a75f'),
                ],
            },
            privateSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'priv-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'priv-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
            databaseSubnets: {
                subnets: [
                    ec2.Subnet.fromSubnetId(stack, 'db-1a', 'subnet-0e9460dbcfc4cf6ee'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1b', 'subnet-0562f666bdf5c29af'),
                    ec2.Subnet.fromSubnetId(stack, 'db-1c', 'subnet-00ab15c0022872f06'),
                ],
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTestingExistingVpcSubnets = IntegTestingExistingVpcSubnets;
new IntegTesting();
// new IntegTestingExistingVpcSubnets();
//# sourceMappingURL=data:application/json;base64,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