# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_arc_data_management_client_enums import *


class BasicLoginInformation(msrest.serialization.Model):
    """Username and password for basic login authentication.

    :param username: Login username.
    :type username: str
    :param password: Login password.
    :type password: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        super(BasicLoginInformation, self).__init__(**kwargs)
        self.username = username
        self.password = password


class CommonSku(msrest.serialization.Model):
    """The resource model definition representing SKU for ARM resources.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU.  It is typically a letter+number code.
    :type name: str
    :param dev: Whether dev/test is enabled. When the dev field is set to true, the resource is
     used for dev/test purpose.
    :type dev: bool
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'dev': {'key': 'dev', 'type': 'bool'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        dev: Optional[bool] = True,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(CommonSku, self).__init__(**kwargs)
        self.name = name
        self.dev = dev
        self.size = size
        self.family = family
        self.capacity = capacity


class DataControllerProperties(msrest.serialization.Model):
    """The data controller properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param infrastructure: The infrastructure the data controller is running on. Possible values
     include: "azure", "gcp", "aws", "alibaba", "onpremises", "other". Default value: "other".
    :type infrastructure: str or ~azure_arc_data_management_client.models.Infrastructure
    :param on_premise_property: Properties from the Kubernetes data controller.
    :type on_premise_property: ~azure_arc_data_management_client.models.OnPremiseProperty
    :param k8_s_raw: The raw kubernetes information.
    :type k8_s_raw: any
    :param upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data
     type.
    :type upload_watermark: ~azure_arc_data_management_client.models.UploadWatermark
    :param last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date
     time.
    :type last_uploaded_date: ~datetime.datetime
    :param basic_login_information: Username and password for basic login authentication.
    :type basic_login_information: ~azure_arc_data_management_client.models.BasicLoginInformation
    :param log_analytics_workspace_config: Log analytics workspace id and primary key.
    :type log_analytics_workspace_config:
     ~azure_arc_data_management_client.models.LogAnalyticsWorkspaceConfig
    :param upload_service_principal: Service principal for uploading billing, metrics and logs.
    :type upload_service_principal: ~azure_arc_data_management_client.models.UploadServicePrincipal
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :param cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
     cluster the custom location belongs to.
    :type cluster_id: str
    :param extension_id: If a CustomLocation is provided, this contains the ARM id of the extension
     the custom location belongs to.
    :type extension_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'infrastructure': {'key': 'infrastructure', 'type': 'str'},
        'on_premise_property': {'key': 'onPremiseProperty', 'type': 'OnPremiseProperty'},
        'k8_s_raw': {'key': 'k8sRaw', 'type': 'object'},
        'upload_watermark': {'key': 'uploadWatermark', 'type': 'UploadWatermark'},
        'last_uploaded_date': {'key': 'lastUploadedDate', 'type': 'iso-8601'},
        'basic_login_information': {'key': 'basicLoginInformation', 'type': 'BasicLoginInformation'},
        'log_analytics_workspace_config': {'key': 'logAnalyticsWorkspaceConfig', 'type': 'LogAnalyticsWorkspaceConfig'},
        'upload_service_principal': {'key': 'uploadServicePrincipal', 'type': 'UploadServicePrincipal'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        infrastructure: Optional[Union[str, "Infrastructure"]] = "other",
        on_premise_property: Optional["OnPremiseProperty"] = None,
        k8_s_raw: Optional[Any] = None,
        upload_watermark: Optional["UploadWatermark"] = None,
        last_uploaded_date: Optional[datetime.datetime] = None,
        basic_login_information: Optional["BasicLoginInformation"] = None,
        log_analytics_workspace_config: Optional["LogAnalyticsWorkspaceConfig"] = None,
        upload_service_principal: Optional["UploadServicePrincipal"] = None,
        cluster_id: Optional[str] = None,
        extension_id: Optional[str] = None,
        **kwargs
    ):
        super(DataControllerProperties, self).__init__(**kwargs)
        self.infrastructure = infrastructure
        self.on_premise_property = on_premise_property
        self.k8_s_raw = k8_s_raw
        self.upload_watermark = upload_watermark
        self.last_uploaded_date = last_uploaded_date
        self.basic_login_information = basic_login_information
        self.log_analytics_workspace_config = log_analytics_workspace_config
        self.upload_service_principal = upload_service_principal
        self.provisioning_state = None
        self.cluster_id = cluster_id
        self.extension_id = extension_id


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure_arc_data_management_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.system_data = None


class DataControllerResource(TrackedResource):
    """Data controller resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure_arc_data_management_client.models.SystemData
    :param extended_location: The extendedLocation of the resource.
    :type extended_location: ~azure_arc_data_management_client.models.ExtendedLocation
    :param properties: Required. The data controller's properties.
    :type properties: ~azure_arc_data_management_client.models.DataControllerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'properties': {'key': 'properties', 'type': 'DataControllerProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "DataControllerProperties",
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        **kwargs
    ):
        super(DataControllerResource, self).__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.properties = properties


class DataControllerUpdate(msrest.serialization.Model):
    """Used for updating a data controller resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DataControllerUpdate, self).__init__(**kwargs)
        self.tags = tags


class ErrorResponse(msrest.serialization.Model):
    """An error response from the Azure Data on Azure Arc service.

    :param error: null.
    :type error: ~azure_arc_data_management_client.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponseBody"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseBody(msrest.serialization.Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure_arc_data_management_client.models.ErrorResponseBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponseBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ErrorResponseBody"]] = None,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ExtendedLocation(msrest.serialization.Model):
    """The complex type of the extended location.

    :param name: The name of the extended location.
    :type name: str
    :param type: The type of the extended location. Possible values include: "CustomLocation".
    :type type: str or ~azure_arc_data_management_client.models.ExtendedLocationTypes
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class K8SResourceRequirements(msrest.serialization.Model):
    """The kubernetes resource limits and requests used to restrict or reserve resource usage.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param requests: Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu'
     request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default
     'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and
     maximum 'memory' is '128Gi'.
    :type requests: dict[str, str]
    :param limits: Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request
     must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory'
     is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum
     'memory' is '128Gi'.
    :type limits: dict[str, str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'requests': {'key': 'requests', 'type': '{str}'},
        'limits': {'key': 'limits', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        requests: Optional[Dict[str, str]] = None,
        limits: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(K8SResourceRequirements, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.requests = requests
        self.limits = limits


class K8SScheduling(msrest.serialization.Model):
    """The kubernetes scheduling information.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param default: The kubernetes scheduling options. It describes restrictions used to help
     Kubernetes select appropriate nodes to host the database service.
    :type default: ~azure_arc_data_management_client.models.K8SSchedulingOptions
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'default': {'key': 'default', 'type': 'K8SSchedulingOptions'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        default: Optional["K8SSchedulingOptions"] = None,
        **kwargs
    ):
        super(K8SScheduling, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.default = default


class K8SSchedulingOptions(msrest.serialization.Model):
    """The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param resources: The kubernetes resource limits and requests used to restrict or reserve
     resource usage.
    :type resources: ~azure_arc_data_management_client.models.K8SResourceRequirements
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'resources': {'key': 'resources', 'type': 'K8SResourceRequirements'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        resources: Optional["K8SResourceRequirements"] = None,
        **kwargs
    ):
        super(K8SSchedulingOptions, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.resources = resources


class LogAnalyticsWorkspaceConfig(msrest.serialization.Model):
    """Log analytics workspace id and primary key.

    :param workspace_id: Azure Log Analytics workspace ID.
    :type workspace_id: str
    :param primary_key: Primary key of the workspace.
    :type primary_key: str
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        workspace_id: Optional[str] = None,
        primary_key: Optional[str] = None,
        **kwargs
    ):
        super(LogAnalyticsWorkspaceConfig, self).__init__(**kwargs)
        self.workspace_id = workspace_id
        self.primary_key = primary_key


class ODataError(msrest.serialization.Model):
    """Information about an error.

    :param code: A language-independent error name.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The target of the error (for example, the name of the property in error).
    :type target: str
    :param details: The error details.
    :type details: list[~azure_arc_data_management_client.models.ODataError]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ODataError]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["ODataError"]] = None,
        **kwargs
    ):
        super(ODataError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class OnPremiseProperty(msrest.serialization.Model):
    """Properties from the Kubernetes data controller.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A globally unique ID identifying the associated Kubernetes cluster.
    :type id: str
    :param public_signing_key: Required. Certificate that contains the Kubernetes cluster public
     key used to verify signing.
    :type public_signing_key: str
    :param signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the
     certificate being uploaded.
    :type signing_certificate_thumbprint: str
    """

    _validation = {
        'id': {'required': True},
        'public_signing_key': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'public_signing_key': {'key': 'publicSigningKey', 'type': 'str'},
        'signing_certificate_thumbprint': {'key': 'signingCertificateThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        public_signing_key: str,
        signing_certificate_thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(OnPremiseProperty, self).__init__(**kwargs)
        self.id = id
        self.public_signing_key = public_signing_key
        self.signing_certificate_thumbprint = signing_certificate_thumbprint


class Operation(msrest.serialization.Model):
    """Azure Data Services on Azure Arc operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the operation being performed on this particular object.
    :type name: str
    :param display: Required. The localized display information for this particular operation /
     action.
    :type display: ~azure_arc_data_management_client.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values include: "user",
     "system".
    :vartype origin: str or ~azure_arc_data_management_client.models.OperationOrigin
    :param is_data_action: Required. Indicates whether the operation is a data action.
    :type is_data_action: bool
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, any]
    """

    _validation = {
        'name': {'required': True},
        'display': {'required': True},
        'origin': {'readonly': True},
        'is_data_action': {'required': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: str,
        display: "OperationDisplay",
        is_data_action: bool,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = None
        self.is_data_action = is_data_action
        self.properties = None


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    All required parameters must be populated in order to send to Azure.

    :param provider: Required. The localized friendly form of the resource provider name.
    :type provider: str
    :param resource: Required. The localized friendly form of the resource type related to this
     action/operation.
    :type resource: str
    :param operation: Required. The localized friendly name for the operation.
    :type operation: str
    :param description: Required. The localized friendly description for the operation.
    :type description: str
    """

    _validation = {
        'provider': {'required': True},
        'resource': {'required': True},
        'operation': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: str,
        resource: str,
        operation: str,
        description: str,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Azure Data Services on Azure Arc operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure_arc_data_management_client.models.Operation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PageOfDataControllerResource(msrest.serialization.Model):
    """PageOfDataControllerResource.

    :param value:
    :type value: list[~azure_arc_data_management_client.models.DataControllerResource]
    :param next_link: Link to retrieve next page of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataControllerResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataControllerResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageOfDataControllerResource, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Plan(msrest.serialization.Model):
    """Plan for the resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A user defined name of the 3rd Party Artifact that is being procured.
    :type name: str
    :param publisher: Required. The publisher of the 3rd Party Artifact that is being bought. E.g.
     NewRelic.
    :type publisher: str
    :param product: Required. The 3rd Party artifact that is being procured. E.g. NewRelic. Product
     maps to the OfferID specified for the artifact at the time of Data Market onboarding.
    :type product: str
    :param promotion_code: A publisher provided promotion code as provisioned in Data Market for
     the said product/artifact.
    :type promotion_code: str
    :param version: The version of the desired product/artifact.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class ResourceSku(msrest.serialization.Model):
    """ResourceSku.

    :param capacity:
    :type capacity: int
    :param family:
    :type family: str
    :param name:
    :type name: str
    :param size:
    :type size: str
    :param tier:
    :type tier: str
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        family: Optional[str] = None,
        name: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.capacity = capacity
        self.family = family
        self.name = name
        self.size = size
        self.tier = tier


class SqlManagedInstance(TrackedResource):
    """A SqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure_arc_data_management_client.models.SystemData
    :param properties: Required. null.
    :type properties: ~azure_arc_data_management_client.models.SqlManagedInstanceProperties
    :param extended_location: The extendedLocation of the resource.
    :type extended_location: ~azure_arc_data_management_client.models.ExtendedLocation
    :param sku: Resource sku.
    :type sku: ~azure_arc_data_management_client.models.SqlManagedInstanceSku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'SqlManagedInstanceProperties'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'sku': {'key': 'sku', 'type': 'SqlManagedInstanceSku'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "SqlManagedInstanceProperties",
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        sku: Optional["SqlManagedInstanceSku"] = None,
        **kwargs
    ):
        super(SqlManagedInstance, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location
        self.sku = sku


class SqlManagedInstanceK8SRaw(msrest.serialization.Model):
    """The raw kubernetes information.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param spec: The kubernetes spec information.
    :type spec: ~azure_arc_data_management_client.models.SqlManagedInstanceK8SSpec
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'spec': {'key': 'spec', 'type': 'SqlManagedInstanceK8SSpec'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        spec: Optional["SqlManagedInstanceK8SSpec"] = None,
        **kwargs
    ):
        super(SqlManagedInstanceK8SRaw, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.spec = spec


class SqlManagedInstanceK8SSpec(msrest.serialization.Model):
    """The kubernetes spec information.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, any]
    :param scheduling: The kubernetes scheduling information.
    :type scheduling: ~azure_arc_data_management_client.models.K8SScheduling
    :param replicas: This option specifies the number of SQL Managed Instance replicas that will be
     deployed in your Kubernetes cluster for high availability purposes. If sku.tier is
     BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is
     GeneralPurpose, replicas must be '1'.
    :type replicas: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'scheduling': {'key': 'scheduling', 'type': 'K8SScheduling'},
        'replicas': {'key': 'replicas', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        scheduling: Optional["K8SScheduling"] = None,
        replicas: Optional[int] = None,
        **kwargs
    ):
        super(SqlManagedInstanceK8SSpec, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.scheduling = scheduling
        self.replicas = replicas


class SqlManagedInstanceListResult(msrest.serialization.Model):
    """A list of SqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure_arc_data_management_client.models.SqlManagedInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlManagedInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlManagedInstanceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlManagedInstanceProperties(msrest.serialization.Model):
    """Properties of sqlManagedInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param data_controller_id: null.
    :type data_controller_id: str
    :param admin: The instance admin user.
    :type admin: str
    :param start_time: The instance start time.
    :type start_time: str
    :param end_time: The instance end time.
    :type end_time: str
    :param k8_s_raw: The raw kubernetes information.
    :type k8_s_raw: ~azure_arc_data_management_client.models.SqlManagedInstanceK8SRaw
    :param basic_login_information: Username and password for basic authentication.
    :type basic_login_information: ~azure_arc_data_management_client.models.BasicLoginInformation
    :param last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date
     time.
    :type last_uploaded_date: ~datetime.datetime
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :param license_type: The license type to apply for this managed instance. Possible values
     include: "BasePrice", "LicenseIncluded". Default value: "BasePrice".
    :type license_type: str or
     ~azure_arc_data_management_client.models.ArcSqlManagedInstanceLicenseType
    :param cluster_id: If a CustomLocation is provided, this contains the ARM id of the connected
     cluster the custom location belongs to.
    :type cluster_id: str
    :param extension_id: If a CustomLocation is provided, this contains the ARM id of the extension
     the custom location belongs to.
    :type extension_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'data_controller_id': {'key': 'dataControllerId', 'type': 'str'},
        'admin': {'key': 'admin', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'k8_s_raw': {'key': 'k8sRaw', 'type': 'SqlManagedInstanceK8SRaw'},
        'basic_login_information': {'key': 'basicLoginInformation', 'type': 'BasicLoginInformation'},
        'last_uploaded_date': {'key': 'lastUploadedDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'extension_id': {'key': 'extensionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_controller_id: Optional[str] = None,
        admin: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        k8_s_raw: Optional["SqlManagedInstanceK8SRaw"] = None,
        basic_login_information: Optional["BasicLoginInformation"] = None,
        last_uploaded_date: Optional[datetime.datetime] = None,
        license_type: Optional[Union[str, "ArcSqlManagedInstanceLicenseType"]] = "BasePrice",
        cluster_id: Optional[str] = None,
        extension_id: Optional[str] = None,
        **kwargs
    ):
        super(SqlManagedInstanceProperties, self).__init__(**kwargs)
        self.data_controller_id = data_controller_id
        self.admin = admin
        self.start_time = start_time
        self.end_time = end_time
        self.k8_s_raw = k8_s_raw
        self.basic_login_information = basic_login_information
        self.last_uploaded_date = last_uploaded_date
        self.provisioning_state = None
        self.license_type = license_type
        self.cluster_id = cluster_id
        self.extension_id = extension_id


class SqlManagedInstanceSku(msrest.serialization.Model):
    """The resource model definition representing SKU for Azure Managed Instance - Azure Arc.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU. Has constant value: "vCore".
    :vartype name: str
    :param tier: The pricing tier for the instance. Possible values include: "GeneralPurpose",
     "BusinessCritical". Default value: "GeneralPurpose".
    :type tier: str or ~azure_arc_data_management_client.models.SqlManagedInstanceSkuTier
    :param dev: Whether dev/test is enabled. When the dev field is set to true, the resource is
     used for dev/test purpose.
    :type dev: bool
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family:
    :type family: str
    :param capacity:
    :type capacity: int
    """

    _validation = {
        'name': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'dev': {'key': 'dev', 'type': 'bool'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    name = "vCore"

    def __init__(
        self,
        *,
        tier: Optional[Union[str, "SqlManagedInstanceSkuTier"]] = "GeneralPurpose",
        dev: Optional[bool] = True,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(SqlManagedInstanceSku, self).__init__(**kwargs)
        self.tier = tier
        self.dev = dev
        self.size = size
        self.family = family
        self.capacity = capacity


class SqlManagedInstanceUpdate(msrest.serialization.Model):
    """An update to a SQL Managed Instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(SqlManagedInstanceUpdate, self).__init__(**kwargs)
        self.tags = tags


class SqlServerInstance(TrackedResource):
    """A SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure_arc_data_management_client.models.SystemData
    :param properties: null.
    :type properties: ~azure_arc_data_management_client.models.SqlServerInstanceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'SqlServerInstanceProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["SqlServerInstanceProperties"] = None,
        **kwargs
    ):
        super(SqlServerInstance, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class SqlServerInstanceListResult(msrest.serialization.Model):
    """A list of SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure_arc_data_management_client.models.SqlServerInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlServerInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlServerInstanceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlServerInstanceProperties(msrest.serialization.Model):
    """Properties of SqlServerInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param version: SQL Server version. Possible values include: "SQL Server 2019", "SQL Server
     2017", "SQL Server 2016".
    :type version: str or ~azure_arc_data_management_client.models.SqlVersion
    :param edition: SQL Server edition. Possible values include: "Evaluation", "Enterprise",
     "Standard", "Web", "Developer", "Express".
    :type edition: str or ~azure_arc_data_management_client.models.EditionType
    :param container_resource_id: Required. ARM Resource id of the container resource (Azure Arc
     for Servers).
    :type container_resource_id: str
    :ivar create_time: The time when the resource was created.
    :vartype create_time: str
    :param v_core: The number of logical processors used by the SQL Server instance.
    :type v_core: str
    :param status: Required. The cloud connectivity status. Possible values include: "Connected",
     "Disconnected", "Unknown".
    :type status: str or ~azure_arc_data_management_client.models.ConnectionStatus
    :param patch_level: SQL Server update level.
    :type patch_level: str
    :param collation: SQL Server collation.
    :type collation: str
    :param current_version: SQL Server current version.
    :type current_version: str
    :param instance_name: SQL Server instance name.
    :type instance_name: str
    :param tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
    :type tcp_dynamic_ports: str
    :param tcp_static_ports: Static TCP ports used by SQL Server.
    :type tcp_static_ports: str
    :param product_id: SQL Server product ID.
    :type product_id: str
    :param license_type: SQL Server license type. Possible values include: "Paid", "Free", "HADR",
     "Undefined".
    :type license_type: str or ~azure_arc_data_management_client.models.ArcSqlServerLicenseType
    :param azure_defender_status_last_updated: Timestamp of last Azure Defender status update.
    :type azure_defender_status_last_updated: ~datetime.datetime
    :param azure_defender_status: Status of Azure Defender. Possible values include: "Protected",
     "Unprotected", "Unknown".
    :type azure_defender_status: str or ~azure_arc_data_management_client.models.DefenderStatus
    :ivar provisioning_state:
    :vartype provisioning_state: str
    """

    _validation = {
        'container_resource_id': {'required': True},
        'create_time': {'readonly': True},
        'status': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'container_resource_id': {'key': 'containerResourceId', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'patch_level': {'key': 'patchLevel', 'type': 'str'},
        'collation': {'key': 'collation', 'type': 'str'},
        'current_version': {'key': 'currentVersion', 'type': 'str'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'tcp_dynamic_ports': {'key': 'tcpDynamicPorts', 'type': 'str'},
        'tcp_static_ports': {'key': 'tcpStaticPorts', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'azure_defender_status_last_updated': {'key': 'azureDefenderStatusLastUpdated', 'type': 'iso-8601'},
        'azure_defender_status': {'key': 'azureDefenderStatus', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_resource_id: str,
        status: Union[str, "ConnectionStatus"],
        version: Optional[Union[str, "SqlVersion"]] = None,
        edition: Optional[Union[str, "EditionType"]] = None,
        v_core: Optional[str] = None,
        patch_level: Optional[str] = None,
        collation: Optional[str] = None,
        current_version: Optional[str] = None,
        instance_name: Optional[str] = None,
        tcp_dynamic_ports: Optional[str] = None,
        tcp_static_ports: Optional[str] = None,
        product_id: Optional[str] = None,
        license_type: Optional[Union[str, "ArcSqlServerLicenseType"]] = None,
        azure_defender_status_last_updated: Optional[datetime.datetime] = None,
        azure_defender_status: Optional[Union[str, "DefenderStatus"]] = None,
        **kwargs
    ):
        super(SqlServerInstanceProperties, self).__init__(**kwargs)
        self.version = version
        self.edition = edition
        self.container_resource_id = container_resource_id
        self.create_time = None
        self.v_core = v_core
        self.status = status
        self.patch_level = patch_level
        self.collation = collation
        self.current_version = current_version
        self.instance_name = instance_name
        self.tcp_dynamic_ports = tcp_dynamic_ports
        self.tcp_static_ports = tcp_static_ports
        self.product_id = product_id
        self.license_type = license_type
        self.azure_defender_status_last_updated = azure_defender_status_last_updated
        self.azure_defender_status = azure_defender_status
        self.provisioning_state = None


class SqlServerInstanceUpdate(msrest.serialization.Model):
    """An update to a SQL Server Instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(SqlServerInstanceUpdate, self).__init__(**kwargs)
        self.tags = tags


class SystemData(msrest.serialization.Model):
    """Read only system data.

    :param created_by: An identifier for the identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure_arc_data_management_client.models.IdentityType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: An identifier for the identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure_arc_data_management_client.models.IdentityType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UploadServicePrincipal(msrest.serialization.Model):
    """Service principal for uploading billing, metrics and logs.

    :param client_id: Client ID of the service principal for uploading data.
    :type client_id: str
    :param tenant_id: Tenant ID of the service principal.
    :type tenant_id: str
    :param authority: Authority for the service principal. Example:
     https://login.microsoftonline.com/.
    :type authority: str
    :param client_secret: Secret of the service principal.
    :type client_secret: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'authority': {'key': 'authority', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        authority: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        super(UploadServicePrincipal, self).__init__(**kwargs)
        self.client_id = client_id
        self.tenant_id = tenant_id
        self.authority = authority
        self.client_secret = client_secret


class UploadWatermark(msrest.serialization.Model):
    """Properties on upload watermark.  Mostly timestamp for each upload data type.

    :param metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current
     date time.
    :type metrics: ~datetime.datetime
    :param logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date
     time.
    :type logs: ~datetime.datetime
    :param usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date
     time.
    :type usages: ~datetime.datetime
    """

    _attribute_map = {
        'metrics': {'key': 'metrics', 'type': 'iso-8601'},
        'logs': {'key': 'logs', 'type': 'iso-8601'},
        'usages': {'key': 'usages', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        metrics: Optional[datetime.datetime] = None,
        logs: Optional[datetime.datetime] = None,
        usages: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(UploadWatermark, self).__init__(**kwargs)
        self.metrics = metrics
        self.logs = logs
        self.usages = usages
