# coding: utf-8

"""
    external/v1/external_session_service.proto

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    NOTE
    ----
    standard swagger-codegen-cli for this python client has been modified
    by custom templates. The purpose of these templates is to include
    typing information in the API and Model code. Please refer to the
    main grid repository for more info
"""


from __future__ import absolute_import

import re  # noqa: F401
from typing import TYPE_CHECKING, Any

# python 2 and python 3 compatibility library
import six

from grid.openapi.api_client import ApiClient

if TYPE_CHECKING:
    from datetime import datetime
    from grid.openapi.models import *


class DatastoreServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def datastore_service_complete_datastore_presigned_urls_upload(self, cluster_id: 'str', datastore_id: 'str', body: 'Body3', **kwargs) -> 'V1CompleteDatastorePresignedUrlsUploadResponse':  # noqa: E501
        """CompleteDatastorePresignedUrlsUpload tells grid that all chunks of a file have been uploaded.  # noqa: E501

        This must be called once all parts of each presigned url requested for the datastore are processed on the client side. Failure to call this will make the uploaded file content be discarded from the datastore.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_complete_datastore_presigned_urls_upload(cluster_id, datastore_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore is being created on. (required)
        :param str datastore_id: the id of the datastore. (required)
        :param Body3 body: (required)
        :return: V1CompleteDatastorePresignedUrlsUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_complete_datastore_presigned_urls_upload_with_http_info(cluster_id, datastore_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_complete_datastore_presigned_urls_upload_with_http_info(cluster_id, datastore_id, body, **kwargs)  # noqa: E501
            return data

    def datastore_service_complete_datastore_presigned_urls_upload_with_http_info(self, cluster_id: 'str', datastore_id: 'str', body: 'Body3', **kwargs) -> 'V1CompleteDatastorePresignedUrlsUploadResponse':  # noqa: E501
        """CompleteDatastorePresignedUrlsUpload tells grid that all chunks of a file have been uploaded.  # noqa: E501

        This must be called once all parts of each presigned url requested for the datastore are processed on the client side. Failure to call this will make the uploaded file content be discarded from the datastore.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_complete_datastore_presigned_urls_upload_with_http_info(cluster_id, datastore_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore is being created on. (required)
        :param str datastore_id: the id of the datastore. (required)
        :param Body3 body: (required)
        :return: V1CompleteDatastorePresignedUrlsUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'datastore_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_complete_datastore_presigned_urls_upload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_complete_datastore_presigned_urls_upload`")  # noqa: E501
        # verify the required parameter 'datastore_id' is set
        if self.api_client.client_side_validation and ('datastore_id' not in params or
                                                       params['datastore_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `datastore_id` when calling `datastore_service_complete_datastore_presigned_urls_upload`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `datastore_service_complete_datastore_presigned_urls_upload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'datastore_id' in params:
            path_params['datastoreId'] = params['datastore_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{datastoreId}/presigned-urls/completed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CompleteDatastorePresignedUrlsUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_create_datastore(self, spec_cluster_id: 'str', body: 'V1CreateDatastoreRequest', **kwargs) -> 'V1CreateDatastoreResponse':  # noqa: E501
        """datastore_service_create_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_create_datastore(spec_cluster_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str spec_cluster_id: (required)
        :param V1CreateDatastoreRequest body: (required)
        :return: V1CreateDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_create_datastore_with_http_info(spec_cluster_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_create_datastore_with_http_info(spec_cluster_id, body, **kwargs)  # noqa: E501
            return data

    def datastore_service_create_datastore_with_http_info(self, spec_cluster_id: 'str', body: 'V1CreateDatastoreRequest', **kwargs) -> 'V1CreateDatastoreResponse':  # noqa: E501
        """datastore_service_create_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_create_datastore_with_http_info(spec_cluster_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str spec_cluster_id: (required)
        :param V1CreateDatastoreRequest body: (required)
        :return: V1CreateDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_cluster_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_create_datastore" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_cluster_id' is set
        if self.api_client.client_side_validation and ('spec_cluster_id' not in params or
                                                       params['spec_cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `spec_cluster_id` when calling `datastore_service_create_datastore`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `datastore_service_create_datastore`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'spec_cluster_id' in params:
            path_params['spec.clusterId'] = params['spec_cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{spec.clusterId}/datastores', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreateDatastoreResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_create_datastore_presigned_urls(self, cluster_id: 'str', datastore_id: 'str', body: 'Body2', **kwargs) -> 'V1CreateDatastorePresignedUrlsResponse':  # noqa: E501
        """CreateDatastorePresignedUrls returns a set of presigned urls which can be used to upload files directly to the platforms backing storage server.  # noqa: E501

        After all parts of an object have been uploaded from the client, the client must make a call to the CompleteDatastorePresignedUrlsUpload endpoint in order to mark the files as available in the datastore. Failure to finalize an object will silently cause that object to go \"missing\" when the datastore is attached to a compute service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_create_datastore_presigned_urls(cluster_id, datastore_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore lives on. (required)
        :param str datastore_id: the id of the datastore we are uploading to. (required)
        :param Body2 body: (required)
        :return: V1CreateDatastorePresignedUrlsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_create_datastore_presigned_urls_with_http_info(cluster_id, datastore_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_create_datastore_presigned_urls_with_http_info(cluster_id, datastore_id, body, **kwargs)  # noqa: E501
            return data

    def datastore_service_create_datastore_presigned_urls_with_http_info(self, cluster_id: 'str', datastore_id: 'str', body: 'Body2', **kwargs) -> 'V1CreateDatastorePresignedUrlsResponse':  # noqa: E501
        """CreateDatastorePresignedUrls returns a set of presigned urls which can be used to upload files directly to the platforms backing storage server.  # noqa: E501

        After all parts of an object have been uploaded from the client, the client must make a call to the CompleteDatastorePresignedUrlsUpload endpoint in order to mark the files as available in the datastore. Failure to finalize an object will silently cause that object to go \"missing\" when the datastore is attached to a compute service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_create_datastore_presigned_urls_with_http_info(cluster_id, datastore_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore lives on. (required)
        :param str datastore_id: the id of the datastore we are uploading to. (required)
        :param Body2 body: (required)
        :return: V1CreateDatastorePresignedUrlsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'datastore_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_create_datastore_presigned_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_create_datastore_presigned_urls`")  # noqa: E501
        # verify the required parameter 'datastore_id' is set
        if self.api_client.client_side_validation and ('datastore_id' not in params or
                                                       params['datastore_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `datastore_id` when calling `datastore_service_create_datastore_presigned_urls`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `datastore_service_create_datastore_presigned_urls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'datastore_id' in params:
            path_params['datastoreId'] = params['datastore_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{datastoreId}/presigned-urls', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreateDatastorePresignedUrlsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_delete_datastore(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1DeleteDatastoreResponse':  # noqa: E501
        """datastore_service_delete_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_delete_datastore(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1DeleteDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_delete_datastore_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_delete_datastore_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
            return data

    def datastore_service_delete_datastore_with_http_info(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1DeleteDatastoreResponse':  # noqa: E501
        """datastore_service_delete_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_delete_datastore_with_http_info(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1DeleteDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_delete_datastore" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_delete_datastore`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `datastore_service_delete_datastore`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DeleteDatastoreResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_get_datastore(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1GetDatastoreResponse':  # noqa: E501
        """datastore_service_get_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_get_datastore(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1GetDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_get_datastore_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_get_datastore_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
            return data

    def datastore_service_get_datastore_with_http_info(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1GetDatastoreResponse':  # noqa: E501
        """datastore_service_get_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_get_datastore_with_http_info(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1GetDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_get_datastore" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_get_datastore`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `datastore_service_get_datastore`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetDatastoreResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_list_datastore_events(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1ListDatastoreEventsResponse':  # noqa: E501
        """datastore_service_list_datastore_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_list_datastore_events(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1ListDatastoreEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_list_datastore_events_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_list_datastore_events_with_http_info(cluster_id, id, **kwargs)  # noqa: E501
            return data

    def datastore_service_list_datastore_events_with_http_info(self, cluster_id: 'str', id: 'str', **kwargs) -> 'V1ListDatastoreEventsResponse':  # noqa: E501
        """datastore_service_list_datastore_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_list_datastore_events_with_http_info(cluster_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str id: (required)
        :return: V1ListDatastoreEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_list_datastore_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_list_datastore_events`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `datastore_service_list_datastore_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1ListDatastoreEventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_list_datastores(self, cluster_id: 'str', **kwargs) -> 'V1ListDatastoresResponse':  # noqa: E501
        """datastore_service_list_datastores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_list_datastores(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str page_token:
        :param str limit:
        :param list[str] user_ids:
        :param bool available:
        :return: V1ListDatastoresResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_list_datastores_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_list_datastores_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def datastore_service_list_datastores_with_http_info(self, cluster_id: 'str', **kwargs) -> 'V1ListDatastoresResponse':  # noqa: E501
        """datastore_service_list_datastores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_list_datastores_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: (required)
        :param str page_token:
        :param str limit:
        :param list[str] user_ids:
        :param bool available:
        :return: V1ListDatastoresResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'page_token', 'limit', 'user_ids', 'available']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_list_datastores" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_list_datastores`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'user_ids' in params:
            query_params.append(('userIds', params['user_ids']))  # noqa: E501
            collection_formats['userIds'] = 'multi'  # noqa: E501
        if 'available' in params:
            query_params.append(('available', params['available']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1ListDatastoresResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_mark_datastore_upload_complete(self, cluster_id: 'str', datastore_id: 'str', **kwargs) -> 'V1MarkDatastoreUploadCompleteResponse':  # noqa: E501
        """MarkDatastoreUploadComplete informs grid that all data files have been uploaded.  # noqa: E501

        For the sake of consistency, this method **MUST** be called regardless of the data source type used when creating the datastore, even if the datastore is being created from a remote source such as an S3 bucket or HTTP URL download. **N.B.** Posting to this endpoint disables the ability to generate new presigned URLs for uploading files ot this datastore.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_mark_datastore_upload_complete(cluster_id, datastore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore lives on. (required)
        :param str datastore_id: the id of the datastore. (required)
        :return: V1MarkDatastoreUploadCompleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_mark_datastore_upload_complete_with_http_info(cluster_id, datastore_id, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_mark_datastore_upload_complete_with_http_info(cluster_id, datastore_id, **kwargs)  # noqa: E501
            return data

    def datastore_service_mark_datastore_upload_complete_with_http_info(self, cluster_id: 'str', datastore_id: 'str', **kwargs) -> 'V1MarkDatastoreUploadCompleteResponse':  # noqa: E501
        """MarkDatastoreUploadComplete informs grid that all data files have been uploaded.  # noqa: E501

        For the sake of consistency, this method **MUST** be called regardless of the data source type used when creating the datastore, even if the datastore is being created from a remote source such as an S3 bucket or HTTP URL download. **N.B.** Posting to this endpoint disables the ability to generate new presigned URLs for uploading files ot this datastore.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_mark_datastore_upload_complete_with_http_info(cluster_id, datastore_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: the cluster the datastore lives on. (required)
        :param str datastore_id: the id of the datastore. (required)
        :return: V1MarkDatastoreUploadCompleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'datastore_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_mark_datastore_upload_complete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `datastore_service_mark_datastore_upload_complete`")  # noqa: E501
        # verify the required parameter 'datastore_id' is set
        if self.api_client.client_side_validation and ('datastore_id' not in params or
                                                       params['datastore_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `datastore_id` when calling `datastore_service_mark_datastore_upload_complete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['clusterId'] = params['cluster_id']  # noqa: E501
        if 'datastore_id' in params:
            path_params['datastoreId'] = params['datastore_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{clusterId}/datastores/{datastoreId}/completed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1MarkDatastoreUploadCompleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def datastore_service_update_datastore(self, spec_cluster_id: 'str', id: 'str', body: 'Body6', **kwargs) -> 'V1UpdateDatastoreResponse':  # noqa: E501
        """datastore_service_update_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_update_datastore(spec_cluster_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str spec_cluster_id: (required)
        :param str id: (required)
        :param Body6 body: (required)
        :return: V1UpdateDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.datastore_service_update_datastore_with_http_info(spec_cluster_id, id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.datastore_service_update_datastore_with_http_info(spec_cluster_id, id, body, **kwargs)  # noqa: E501
            return data

    def datastore_service_update_datastore_with_http_info(self, spec_cluster_id: 'str', id: 'str', body: 'Body6', **kwargs) -> 'V1UpdateDatastoreResponse':  # noqa: E501
        """datastore_service_update_datastore  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.datastore_service_update_datastore_with_http_info(spec_cluster_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str spec_cluster_id: (required)
        :param str id: (required)
        :param Body6 body: (required)
        :return: V1UpdateDatastoreResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_cluster_id', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datastore_service_update_datastore" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_cluster_id' is set
        if self.api_client.client_side_validation and ('spec_cluster_id' not in params or
                                                       params['spec_cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `spec_cluster_id` when calling `datastore_service_update_datastore`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `datastore_service_update_datastore`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `datastore_service_update_datastore`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'spec_cluster_id' in params:
            path_params['spec.clusterId'] = params['spec_cluster_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/core/{spec.clusterId}/datastores/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1UpdateDatastoreResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
