# generated by datamodel-codegen:
#   filename:  _region_filter_config_dynamic.py
#   timestamp: 2021-08-07T02:07:17+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Field


class FloatFilter(BaseModel):
    ge: float = Field(
        ...,
        description="Only include region if attribute >= this value.",
        title="Greater-than or Equal-to",
    )
    le: float = Field(
        ...,
        description="Only include region if attribute <= this value.",
        title="Less-than or Equal-to",
    )
    exclude_none: Optional[bool] = Field(
        False,
        description="Whether to exclude region if attribute is not set.",
        title="Exclude None",
    )


class RegionFilterConfig(BaseModel):
    score: Optional[FloatFilter] = Field(
        None, description="Sets filters for the score region attribute.", title="Score"
    )
    best_peak: Optional[FloatFilter] = Field(
        None,
        description="Sets filters for the best_peak region attribute.",
        title="Best Peak",
    )
    blur_length: Optional[FloatFilter] = Field(
        None,
        description="Sets filters for the blur_length region attribute.",
        title="Blur Length",
    )
    snr: Optional[FloatFilter] = Field(
        None, description="Sets filters for the snr region attribute.", title="Snr"
    )
    wb_freq_up: Optional[FloatFilter] = Field(
        None,
        description="Sets filters for the wb_freq_up region attribute.",
        title="Wb Freq Up",
    )
    wb_freq_down: Optional[FloatFilter] = Field(
        None,
        description="Sets filters for the wb_freq_down region\n\nattribute.",
        title="Wb Freq Down",
    )
    et_up: Optional[FloatFilter] = Field(
        None, description="Sets filters for the et_up region attribute.", title="Et Up"
    )
    et_dn: Optional[FloatFilter] = Field(
        None, description="Sets filters for the et_dn region attribute.", title="Et Dn"
    )

    class Config:
        schema_extra = {
            "description": "Contains options for filtering regions (annotations) from images, based on the values of region attributes. "
        }
