import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Role to switch to at login
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#assume_role Role#assume_role}
    */
    readonly assumeRole?: string;
    /**
    * Determine whether a role bypasses every row-level security (RLS) policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#bypass_row_level_security Role#bypass_row_level_security}
    */
    readonly bypassRowLevelSecurity?: boolean | cdktf.IResolvable;
    /**
    * How many concurrent connections can be made with this role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#connection_limit Role#connection_limit}
    */
    readonly connectionLimit?: number;
    /**
    * Define a role's ability to create databases
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#create_database Role#create_database}
    */
    readonly createDatabase?: boolean | cdktf.IResolvable;
    /**
    * Determine whether this role will be permitted to create new roles
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#create_role Role#create_role}
    */
    readonly createRole?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#encrypted Role#encrypted}
    */
    readonly encrypted?: string;
    /**
    * Control whether the password is stored encrypted in the system catalogs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#encrypted_password Role#encrypted_password}
    */
    readonly encryptedPassword?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#idle_in_transaction_session_timeout Role#idle_in_transaction_session_timeout}
    */
    readonly idleInTransactionSessionTimeout?: number;
    /**
    * Determine whether a role "inherits" the privileges of roles it is a member of
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#inherit Role#inherit}
    */
    readonly inherit?: boolean | cdktf.IResolvable;
    /**
    * Determine whether a role is allowed to log in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#login Role#login}
    */
    readonly login?: boolean | cdktf.IResolvable;
    /**
    * The name of the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#name Role#name}
    */
    readonly name: string;
    /**
    * Sets the role's password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#password Role#password}
    */
    readonly password?: string;
    /**
    * Determine whether a role is allowed to initiate streaming replication or put the system in and out of backup mode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#replication Role#replication}
    */
    readonly replication?: boolean | cdktf.IResolvable;
    /**
    * Role(s) to grant to this new role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#roles Role#roles}
    */
    readonly roles?: string[];
    /**
    * Sets the role's search path
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#search_path Role#search_path}
    */
    readonly searchPath?: string[];
    /**
    * Skip actually running the DROP ROLE command when removing a ROLE from PostgreSQL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#skip_drop_role Role#skip_drop_role}
    */
    readonly skipDropRole?: boolean | cdktf.IResolvable;
    /**
    * Skip actually running the REASSIGN OWNED command when removing a role from PostgreSQL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#skip_reassign_owned Role#skip_reassign_owned}
    */
    readonly skipReassignOwned?: boolean | cdktf.IResolvable;
    /**
    * Abort any statement that takes more than the specified number of milliseconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#statement_timeout Role#statement_timeout}
    */
    readonly statementTimeout?: number;
    /**
    * Determine whether the new role is a "superuser"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#superuser Role#superuser}
    */
    readonly superuser?: boolean | cdktf.IResolvable;
    /**
    * Sets a date and time after which the role's password is no longer valid
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role#valid_until Role#valid_until}
    */
    readonly validUntil?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/role postgresql_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/role postgresql_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _assumeRole?;
    get assumeRole(): string;
    set assumeRole(value: string);
    resetAssumeRole(): void;
    get assumeRoleInput(): string | undefined;
    private _bypassRowLevelSecurity?;
    get bypassRowLevelSecurity(): boolean | cdktf.IResolvable;
    set bypassRowLevelSecurity(value: boolean | cdktf.IResolvable);
    resetBypassRowLevelSecurity(): void;
    get bypassRowLevelSecurityInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionLimit?;
    get connectionLimit(): number;
    set connectionLimit(value: number);
    resetConnectionLimit(): void;
    get connectionLimitInput(): number | undefined;
    private _createDatabase?;
    get createDatabase(): boolean | cdktf.IResolvable;
    set createDatabase(value: boolean | cdktf.IResolvable);
    resetCreateDatabase(): void;
    get createDatabaseInput(): boolean | cdktf.IResolvable | undefined;
    private _createRole?;
    get createRole(): boolean | cdktf.IResolvable;
    set createRole(value: boolean | cdktf.IResolvable);
    resetCreateRole(): void;
    get createRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    get encrypted(): string;
    set encrypted(value: string);
    resetEncrypted(): void;
    get encryptedInput(): string | undefined;
    private _encryptedPassword?;
    get encryptedPassword(): boolean | cdktf.IResolvable;
    set encryptedPassword(value: boolean | cdktf.IResolvable);
    resetEncryptedPassword(): void;
    get encryptedPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idleInTransactionSessionTimeout?;
    get idleInTransactionSessionTimeout(): number;
    set idleInTransactionSessionTimeout(value: number);
    resetIdleInTransactionSessionTimeout(): void;
    get idleInTransactionSessionTimeoutInput(): number | undefined;
    private _inherit?;
    get inherit(): boolean | cdktf.IResolvable;
    set inherit(value: boolean | cdktf.IResolvable);
    resetInherit(): void;
    get inheritInput(): boolean | cdktf.IResolvable | undefined;
    private _login?;
    get login(): boolean | cdktf.IResolvable;
    set login(value: boolean | cdktf.IResolvable);
    resetLogin(): void;
    get loginInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _replication?;
    get replication(): boolean | cdktf.IResolvable;
    set replication(value: boolean | cdktf.IResolvable);
    resetReplication(): void;
    get replicationInput(): boolean | cdktf.IResolvable | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _searchPath?;
    get searchPath(): string[];
    set searchPath(value: string[]);
    resetSearchPath(): void;
    get searchPathInput(): string[] | undefined;
    private _skipDropRole?;
    get skipDropRole(): boolean | cdktf.IResolvable;
    set skipDropRole(value: boolean | cdktf.IResolvable);
    resetSkipDropRole(): void;
    get skipDropRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _skipReassignOwned?;
    get skipReassignOwned(): boolean | cdktf.IResolvable;
    set skipReassignOwned(value: boolean | cdktf.IResolvable);
    resetSkipReassignOwned(): void;
    get skipReassignOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _statementTimeout?;
    get statementTimeout(): number;
    set statementTimeout(value: number);
    resetStatementTimeout(): void;
    get statementTimeoutInput(): number | undefined;
    private _superuser?;
    get superuser(): boolean | cdktf.IResolvable;
    set superuser(value: boolean | cdktf.IResolvable);
    resetSuperuser(): void;
    get superuserInput(): boolean | cdktf.IResolvable | undefined;
    private _validUntil?;
    get validUntil(): string;
    set validUntil(value: string);
    resetValidUntil(): void;
    get validUntilInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
