# Generated by Django 4.1 on 2022-10-25 20:44
import json
from django.db import migrations, models, transaction


def text_to_json(apps, schema_editor):
    Book = apps.get_model("book", "Book")
    books = Book.objects.all().iterator()
    with transaction.atomic():
        for book in books:
            book.settings = json.loads(book.settings_text)
            book.metadata = json.loads(book.metadata_text)
            book.save()


def json_to_text(apps, schema_editor):
    Book = apps.get_model("book", "Book")
    books = Book.objects.all().iterator()
    with transaction.atomic():
        for book in books:
            book.settings_text = json.dumps(book.settings)
            book.metadata_text = json.dumps(book.metadata)
            book.save()


class Migration(migrations.Migration):

    dependencies = [
        ("book", "0012_remove_user_accessrights"),
    ]

    operations = [
        migrations.RenameField(
            model_name="book",
            old_name="metadata",
            new_name="metadata_text",
        ),
        migrations.RenameField(
            model_name="book",
            old_name="settings",
            new_name="settings_text",
        ),
        migrations.AddField(
            model_name="book",
            name="metadata",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.AddField(
            model_name="book",
            name="settings",
            field=models.JSONField(blank=True, default=dict),
        ),
        migrations.RunPython(text_to_json, json_to_text),
        migrations.RemoveField(
            model_name="book",
            name="settings_text",
        ),
        migrations.RemoveField(
            model_name="book",
            name="metadata_text",
        ),
    ]
