/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.assist;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import ru.autosome.ChIPApp;
import ru.autosome.assist.IPrinter;

public class Conductor {
    private static final String VERSION = "V7 10012017";
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private final long TIME = System.currentTimeMillis();
    private Status status = Status.INITIALIZED;
    private IPrinter outputPrinter = new IPrinter(){

        @Override
        public void println(String message) {
            System.out.println(message);
        }
    };
    private IPrinter messagePrinter = new IPrinter(){

        @Override
        public void println(String message) {
            System.err.println(message);
        }
    };
    private Exception error = null;
    public static Conductor defaultConductor = new Conductor();
    private boolean silence = false;
    private Integer totalTicks = null;
    private Integer currentTicks = null;
    private Integer done = 0;

    public void setOutputPrinter(IPrinter outputPrinter) {
        this.outputPrinter = outputPrinter;
    }

    public void setMessagePrinter(IPrinter messagePrinter) {
        this.messagePrinter = messagePrinter;
    }

    public Exception getError() {
        return this.error;
    }

    public void setThreadFactory(ThreadFactory tf) {
        this.threadFactory = tf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Status status = this.status;
        synchronized (status) {
            this.status = Status.INTERRUPTED;
        }
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(Object key, Object value) {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.INTERRUPTED) {
                throw new RuntimeException("execution interrupted");
            }
            if (!this.silence) {
                this.outputPrinter.println(key.toString() + "|" + value.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(String message) {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.INTERRUPTED) {
                throw new RuntimeException("execution interrupted");
            }
            this.messagePrinter.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object launch(ChIPApp app) {
        Object result;
        this.output("PROG", app.getClass().getCanonicalName() + " " + VERSION);
        try {
            this.status = Status.RUNNING;
            result = app.launch();
            this.status = Status.WAITING;
        }
        catch (Exception e) {
            String message;
            String string = message = e.toString() == null ? "no information" : e.toString();
            if (this.status == Status.INTERRUPTED) {
                Status status = this.status;
                synchronized (status) {
                    this.messagePrinter.println("interrupted (" + app.getClass().getCanonicalName() + "): " + message);
                    if (!this.silence) {
                        this.outputPrinter.println("INTR|" + app.getClass().getCanonicalName());
                    }
                }
                return null;
            }
            this.status = Status.ERROR;
            this.messagePrinter.println("error: (" + app.getClass().getCanonicalName() + "): " + message);
            e.printStackTrace();
            if (!this.silence) {
                this.outputPrinter.println("ERRR|" + message);
            }
            this.error = e;
            return null;
        }
        this.output("TIME", (double)(System.currentTimeMillis() - this.TIME) / 1000.0);
        this.output("DUMP", app.getClass().getCanonicalName() + " " + VERSION);
        this.output("/\\/\\", " -------------------------- ");
        this.output("_^^_", " P0wered by cute chipmunks! ");
        return result;
    }

    public void silence() {
        this.silence = true;
    }

    public void verbose() {
        this.silence = false;
    }

    public Integer getDone() {
        return this.done;
    }

    public void setTotalTicks(Integer totalTicks) {
        if (this.totalTicks == null) {
            this.totalTicks = totalTicks;
            this.currentTicks = 0;
        }
    }

    public synchronized void tick(String message) {
        this.currentTicks = this.currentTicks + 1;
        this.done = Math.max(this.done, (int)((double)this.currentTicks.intValue() * 100.0 / (double)this.totalTicks.intValue()) - 1);
        int remaining = 100 - this.done;
        double currentTimeSec = (double)(System.currentTimeMillis() - this.TIME) / 1000.0;
        double speed = (double)this.done.intValue() / currentTimeSec;
        double remainingTimeSec = (double)remaining * speed;
        if (this.done > 0) {
            this.message("overall progress: " + this.done + "% complete (" + message + ")");
        }
    }

    public void updateTicks(int ticks) {
        if (this.currentTicks != ticks) {
            this.currentTicks = ticks;
            this.done = Math.max(this.done, (int)((double)this.currentTicks.intValue() * 100.0 / (double)this.totalTicks.intValue()) - 1);
            this.message("overall progress: " + this.done + "% complete");
        }
    }

    public static String prettyString(double[] ds) {
        StringBuilder sb = new StringBuilder(Double.toString(ds[0]));
        for (int i = 1; i < ds.length; ++i) {
            sb.append(" ").append(ds[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.INTERRUPTED) {
                throw new RuntimeException("execution interrupted");
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status newStatus) {
        Status status = this.status;
        synchronized (status) {
            if (newStatus != this.status && this.status == Status.INTERRUPTED) {
                throw new RuntimeException("execution interrupted");
            }
            this.status = newStatus;
        }
    }

    public static enum Status {
        INITIALIZED,
        RUNNING,
        WAITING,
        INTERRUPTED,
        SUCCESS,
        FAIL,
        ERROR;

    }
}

