/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di.engine;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import ru.autosome.di.ChIPAct;
import ru.autosome.di.engine.SoptiStep;
import ru.autosome.di.ytilib.Sequence;
import ru.autosome.di.ytilib.WPCM;

public class DoptiStep {
    private ChIPAct chipstep;
    private int stepLimit;
    private int iterationLimit;
    private Sequence[] sequenceSet;
    private double[] realBackground;
    private double[] defaultBackground;
    protected Random randomizer = new SecureRandom();
    double sampleWeight;
    protected WPCM pm;
    private double[] shape = null;

    public DoptiStep(Sequence[] seqset, double sampleWeight, WPCM seed, ChIPAct chipstep, int stepLimit, int iterationLimit, double[] background, double[] shape) {
        this.sampleWeight = sampleWeight;
        this.sequenceSet = seqset;
        this.realBackground = Sequence.background(this.sequenceSet);
        this.defaultBackground = background;
        this.pm = seed;
        this.chipstep = chipstep;
        this.stepLimit = stepLimit;
        this.iterationLimit = iterationLimit;
        this.shape = shape;
    }

    public WPCM launch() {
        double currentBestICD = -1.7976931348623157E308;
        WPCM currentBest = null;
        for (int i = 0; i < this.stepLimit; ++i) {
            double best;
            SoptiStep step = this.optistep2(this.iterationLimit);
            WPCM dores = step.pm;
            double kdidic = dores.kdidic(this.defaultBackground);
            if (kdidic > currentBestICD) {
                currentBest = new WPCM(dores);
                currentBestICD = kdidic;
            }
            if (!((best = this.chipstep.getBestInfocod()) > 0.0) || !(kdidic + WPCM.KDIDIC_MAX < best)) continue;
            this.pm = this.chipstep.getBest();
        }
        return currentBest;
    }

    protected Sequence[] subSample(double weight) {
        Sequence r;
        ArrayList<Sequence> sample = new ArrayList<Sequence>();
        for (double cw = 0.0; cw < weight; cw += r.weight) {
            r = this.sequenceSet[this.randomizer.nextInt(this.sequenceSet.length)];
            sample.add(r);
        }
        return sample.toArray(new Sequence[sample.size()]);
    }

    protected Sequence[] makeSample(int size) {
        Sequence[] largeSub = new Sequence[size];
        for (int r = 0; r < size; ++r) {
            largeSub[r] = this.sequenceSet[this.randomizer.nextInt(this.sequenceSet.length)];
        }
        return largeSub;
    }

    public SoptiStep optistep2(int iterationLimit) {
        WPCM step1 = DoptiStep.optistep(this.subSample(this.sampleWeight), this.sampleWeight, this.pm, this.realBackground, iterationLimit, this.shape);
        SoptiStep step2 = DoptiStep.optistep(this.sequenceSet, step1, this.defaultBackground, 2000, this.shape);
        this.pm = new WPCM(step2.pm);
        return step2;
    }

    public static WPCM optistep(Sequence[] sample, double weight, WPCM base, double[] background, int iterationLimit, double[] shape) {
        SoptiStep cp = new SoptiStep(sample, weight, background, iterationLimit, shape);
        cp.optimize(base);
        return cp.pm;
    }

    public static SoptiStep optistep(Sequence[] sample, WPCM base, double[] background, int iterationLimit, double[] shape) {
        if (sample.length == 0) {
            return null;
        }
        SoptiStep cp = new SoptiStep(sample, sample.length, background, iterationLimit, shape);
        cp.optimize(base);
        return cp;
    }
}

