/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape;

import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.motifModels.PWM;

public class PWMAligned {
    public final PWM first_pwm;
    public final PWM second_pwm;
    public final Position relative_position;
    private int first_length;
    private int second_length;

    public PWMAligned(PWM first_pwm_unaligned, PWM second_pwm_unaligned, Position relative_position) {
        this.first_length = first_pwm_unaligned.length();
        this.second_length = second_pwm_unaligned.length();
        this.relative_position = relative_position;
        PWM first_tmp = first_pwm_unaligned;
        PWM second_tmp = second_pwm_unaligned;
        if (this.isReverseComplement()) {
            second_tmp = second_tmp.reverseComplement();
        }
        if (this.shift() > 0) {
            second_tmp = second_tmp.leftAugment(this.shift());
        } else {
            first_tmp = first_tmp.leftAugment(-this.shift());
        }
        this.first_pwm = first_tmp.rightAugment(this.length() - first_tmp.length());
        this.second_pwm = second_tmp.rightAugment(this.length() - second_tmp.length());
    }

    public int shift() {
        return this.relative_position.position;
    }

    public String orientation() {
        return this.relative_position.strand();
    }

    public int length() {
        if (this.shift() > 0) {
            return Math.max(this.first_length, this.second_length + this.shift());
        }
        return Math.max(this.first_length - this.shift(), this.second_length);
    }

    public boolean isDirect() {
        return this.relative_position.directStrand;
    }

    public boolean isReverseComplement() {
        return !this.relative_position.directStrand;
    }

    private boolean isFirstOverlapsPosition(int position) {
        if (position < 0 || position >= this.length()) {
            return false;
        }
        if (this.shift() > 0) {
            return position < this.first_length;
        }
        return position >= -this.shift() && position < -this.shift() + this.first_length;
    }

    private boolean isSecondOverlapsPosition(int position) {
        if (position < 0 || position >= this.length()) {
            return false;
        }
        if (this.shift() > 0) {
            return position >= this.shift() && position < this.shift() + this.second_length;
        }
        return position < this.second_length;
    }

    public int overlapSize() {
        int sum = 0;
        for (int pos = 0; pos < this.length(); ++pos) {
            if (!this.isFirstOverlapsPosition(pos) || !this.isSecondOverlapsPosition(pos)) continue;
            ++sum;
        }
        return sum;
    }

    public String first_pwm_alignment() {
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < this.length(); ++pos) {
            if (this.isFirstOverlapsPosition(pos)) {
                builder.append('>');
                continue;
            }
            builder.append('.');
        }
        return builder.toString();
    }

    public String second_pwm_alignment() {
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < this.length(); ++pos) {
            if (this.isSecondOverlapsPosition(pos)) {
                if (this.isDirect()) {
                    builder.append('>');
                    continue;
                }
                builder.append('<');
                continue;
            }
            builder.append('.');
        }
        return builder.toString();
    }

    public String toString() {
        return this.first_pwm_alignment() + "\n" + this.second_pwm_alignment();
    }
}

