/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.PWMAligned;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.AlignedPWMIntersection;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.motifModels.PWM;

public class ComparePWM {
    public final PWM firstPWM;
    public final PWM secondPWM;
    public final BackgroundModel firstBackground;
    public final BackgroundModel secondBackground;
    public final CanFindPvalue firstPvalueCalculator;
    public final CanFindPvalue secondPvalueCalculator;
    public final Double discretization;
    public Integer maxPairHashSize;

    public ComparePWM(PWM firstPWM, PWM secondPWM, BackgroundModel firstBackground, BackgroundModel secondBackground, CanFindPvalue firstPvalueCalculator, CanFindPvalue secondPvalueCalculator, Double discretization, Integer maxPairHashSize) {
        this.firstPWM = firstPWM;
        this.secondPWM = secondPWM;
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.firstPvalueCalculator = firstPvalueCalculator;
        this.secondPvalueCalculator = secondPvalueCalculator;
        this.discretization = discretization;
        this.maxPairHashSize = maxPairHashSize;
    }

    private ComparePWMCountsGiven calculatorWithCountsGiven() {
        return new ComparePWMCountsGiven(this.firstPWM, this.secondPWM, this.firstBackground, this.secondBackground, this.discretization, this.maxPairHashSize);
    }

    public SimilarityInfo jaccard(double threshold_first, double threshold_second) throws HashOverflowException {
        double firstCount = this.firstPvalueCalculator.pvalueByThreshold(threshold_first).numberOfRecognizedWords(this.firstBackground, this.firstPWM.length());
        double secondCount = this.secondPvalueCalculator.pvalueByThreshold(threshold_second).numberOfRecognizedWords(this.secondBackground, this.secondPWM.length());
        return this.calculatorWithCountsGiven().jaccard(threshold_first, threshold_second, firstCount, secondCount);
    }

    public SimilarityInfo jaccardAtPosition(double threshold_first, double threshold_second, Position position) throws HashOverflowException {
        double firstCount = this.firstPvalueCalculator.pvalueByThreshold(threshold_first).numberOfRecognizedWords(this.firstBackground, this.firstPWM.length());
        double secondCount = this.secondPvalueCalculator.pvalueByThreshold(threshold_second).numberOfRecognizedWords(this.secondBackground, this.secondPWM.length());
        return this.calculatorWithCountsGiven().jaccardAtPosition(threshold_first, threshold_second, firstCount, secondCount, position);
    }

    public static class ComparePWMCountsGiven {
        public final PWM firstPWM;
        public final PWM secondPWM;
        public final BackgroundModel firstBackground;
        public final BackgroundModel secondBackground;
        public final Double discretization;
        public Integer maxPairHashSize;

        public ComparePWMCountsGiven(PWM firstPWM, PWM secondPWM, BackgroundModel firstBackground, BackgroundModel secondBackground, Double discretization, Integer maxPairHashSize) {
            this.firstPWM = firstPWM.discrete(discretization);
            this.secondPWM = secondPWM.discrete(discretization);
            this.firstBackground = firstBackground;
            this.secondBackground = secondBackground;
            this.discretization = discretization;
            this.maxPairHashSize = maxPairHashSize;
        }

        private double upscaleThreshold(double threshold) {
            if (this.discretization == null) {
                return threshold;
            }
            return threshold * this.discretization;
        }

        private List<Position> relative_alignments() {
            ArrayList<Position> result = new ArrayList<Position>();
            for (int shift = -this.secondPWM.length(); shift <= this.firstPWM.length(); ++shift) {
                result.add(new Position(shift, true));
                result.add(new Position(shift, false));
            }
            return result;
        }

        double firstCountRenormMultiplier(PWMAligned alignment) {
            return Math.pow(this.firstBackground.volume(), alignment.length() - this.firstPWM.length());
        }

        double secondCountRenormMultiplier(PWMAligned alignment) {
            return Math.pow(this.secondBackground.volume(), alignment.length() - this.secondPWM.length());
        }

        public SimilarityInfo jaccard(double thresholdFirst, double thresholdSecond, double firstCount, double secondCount) throws HashOverflowException {
            PWMAligned bestAlignment = null;
            double bestSimilarity = -1.0;
            double bestIntersection = 0.0;
            for (Position position : this.relative_alignments()) {
                double secondCountRenormed;
                PWMAligned alignment = new PWMAligned(this.firstPWM, this.secondPWM, position);
                AlignedPWMIntersection calculator = new AlignedPWMIntersection(alignment, this.firstBackground, this.secondBackground);
                double intersection = calculator.count_in_intersection(this.upscaleThreshold(thresholdFirst), this.upscaleThreshold(thresholdSecond));
                double firstCountRenormed = firstCount * this.firstCountRenormMultiplier(alignment);
                double similarity = AlignedPWMIntersection.SimilarityInfo.jaccardByCounts(firstCountRenormed, secondCountRenormed = secondCount * this.secondCountRenormMultiplier(alignment), intersection);
                if (!(similarity > bestSimilarity)) continue;
                bestAlignment = alignment;
                bestSimilarity = similarity;
                bestIntersection = intersection;
            }
            double firstCountRenormedBest = firstCount * this.firstCountRenormMultiplier(bestAlignment);
            double secondCountRenormedBest = secondCount * this.secondCountRenormMultiplier(bestAlignment);
            return new SimilarityInfo(bestAlignment, bestIntersection, firstCountRenormedBest, secondCountRenormedBest);
        }

        public SimilarityInfo jaccardAtPosition(double thresholdFirst, double thresholdSecond, double firstCount, double secondCount, Position position) throws HashOverflowException {
            PWMAligned alignment = new PWMAligned(this.firstPWM, this.secondPWM, position);
            AlignedPWMIntersection calculator = new AlignedPWMIntersection(alignment, this.firstBackground, this.secondBackground);
            double intersection = calculator.count_in_intersection(this.upscaleThreshold(thresholdFirst), this.upscaleThreshold(thresholdSecond));
            double firstCountRenormed = firstCount * this.firstCountRenormMultiplier(alignment);
            double secondCountRenormed = secondCount * this.secondCountRenormMultiplier(alignment);
            return new SimilarityInfo(alignment, intersection, firstCountRenormed, secondCountRenormed);
        }
    }

    public static class SimilarityInfo
    extends AlignedPWMIntersection.SimilarityInfo {
        public final PWMAligned alignment;

        public SimilarityInfo(PWMAligned alignment, double recognizedByBoth, double recognizedByFirst, double recognizedBySecond) {
            super(recognizedByBoth, recognizedByFirst, recognizedBySecond);
            this.alignment = alignment;
        }

        public SimilarityInfo(PWMAligned alignment, AlignedPWMIntersection.SimilarityInfo similarityInfo) {
            super(similarityInfo.recognizedByBoth, similarityInfo.recognizedByFirst, similarityInfo.recognizedBySecond);
            this.alignment = alignment;
        }

        public Double realPvalueFirst(BackgroundModel background) {
            return this.realPvalueFirst(background, this.alignment.length());
        }

        public Double realPvalueSecond(BackgroundModel background) {
            return this.realPvalueSecond(background, this.alignment.length());
        }

        public int shift() {
            return this.alignment.shift();
        }

        public String orientation() {
            return this.alignment.orientation();
        }

        public int overlap() {
            return this.alignment.overlapSize();
        }
    }
}

