/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.SequenceWithSNP;
import ru.autosome.perfectosape.calculations.EstimateAffinityMinPvalue;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class SNPScan {
    final ScoringModel pwm;
    final SequenceWithSNP sequenceWithSNP;
    final CanFindPvalue pvalueCalculator;

    public SNPScan(ScoringModel pwm, SequenceWithSNP sequenceWithSNP, CanFindPvalue pvalueCalculator) {
        this.pwm = pwm;
        this.sequenceWithSNP = sequenceWithSNP;
        this.pvalueCalculator = pvalueCalculator;
        if (sequenceWithSNP.num_cases() != 2) {
            throw new IllegalArgumentException("Unable to process more than two variants of nucleotide for SNP " + sequenceWithSNP);
        }
    }

    ArrayList<Position> positionsToCheck() {
        return this.sequenceWithSNP.positions_subsequence_overlaps_snp(this.pwm.length());
    }

    public RegionAffinityVariantInfo affinityVariantInfo(int allele_number) throws HashOverflowException {
        Sequence sequence = this.sequenceWithSNP.sequence_variants()[allele_number];
        Character allele = Character.valueOf(this.sequenceWithSNP.mid[allele_number]);
        EstimateAffinityMinPvalue affinity_calculator = new EstimateAffinityMinPvalue(this.pwm, sequence, this.pvalueCalculator, this.positionsToCheck());
        Position pos = affinity_calculator.bestPosition();
        double pvalue = affinity_calculator.affinity();
        Sequence word = sequence.substring(pos, this.pwm.length());
        Position pos_centered = new Position(pos.position - this.sequenceWithSNP.left.length(), pos.directStrand);
        return new RegionAffinityVariantInfo(pos_centered, allele, pvalue, word);
    }

    public RegionAffinityInfos affinityInfos() throws HashOverflowException {
        return new RegionAffinityInfos(this.affinityVariantInfo(0), this.affinityVariantInfo(1));
    }

    public static class RegionAffinityInfos {
        final RegionAffinityVariantInfo info_1;
        final RegionAffinityVariantInfo info_2;

        public RegionAffinityVariantInfo getInfo_1() {
            return this.info_1;
        }

        public RegionAffinityVariantInfo getInfo_2() {
            return this.info_2;
        }

        RegionAffinityInfos(RegionAffinityVariantInfo info_1, RegionAffinityVariantInfo info_2) {
            this.info_1 = info_1;
            this.info_2 = info_2;
        }

        public double foldChange() {
            return this.info_1.pvalue / this.info_2.pvalue;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.info_1.position.toString()).append("\t").append(this.info_1.word).append("\t");
            result.append(this.info_2.position.toString()).append("\t").append(this.info_2.word).append("\t");
            result.append(this.info_1.allele).append("/").append(this.info_2.allele).append("\t");
            result.append(this.info_1.pvalue).append("\t").append(this.info_2.pvalue).append("\t");
            result.append(this.foldChange());
            return result.toString();
        }
    }

    public static class RegionAffinityVariantInfo {
        final Position position;
        final Sequence word;
        final Character allele;
        final double pvalue;

        public Position getPosition() {
            return this.position;
        }

        public Sequence getWord() {
            return this.word;
        }

        public Character getAllele() {
            return this.allele;
        }

        public double getPvalue() {
            return this.pvalue;
        }

        RegionAffinityVariantInfo(Position position, Character allele, double pvalue, Sequence word) {
            this.position = position;
            this.allele = allele;
            this.pvalue = pvalue;
            this.word = word;
        }
    }
}

