/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.importers.MotifImporter;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.PCM;
import ru.autosome.perfectosape.motifModels.PPM;
import ru.autosome.perfectosape.motifModels.PWM;

public class PWMImporter
extends MotifImporter<PWM> {
    BackgroundModel background;
    DataModel dataModel;
    Double effectiveCount;

    public PWMImporter(BackgroundModel background, DataModel dataModel, Double effectiveCount) {
        this.background = background;
        this.dataModel = dataModel;
        this.effectiveCount = effectiveCount;
    }

    @Override
    public PWM transformToPWM(double[][] matrix, String name) {
        PWM pwm;
        switch (this.dataModel) {
            case PCM: {
                pwm = new PCM(matrix, name).to_pwm(this.background);
                break;
            }
            case PPM: {
                pwm = new PPM(matrix, name).to_pwm(this.background, this.effectiveCount);
                break;
            }
            case PWM: {
                pwm = new PWM(matrix, name);
                break;
            }
            default: {
                throw new Error("This code never reached");
            }
        }
        return pwm;
    }
}

