/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import ru.autosome.assist.ASequence;
import ru.autosome.ytilib.WPCM;

public class Sequence
extends ASequence {
    public static final byte IUPACOUNT = 15;
    public static final byte N = 14;
    protected static final char[] BYTE2CHAR = new char[]{'A', 'C', 'G', 'T', 'R', 'Y', 'K', 'M', 'S', 'W', 'B', 'D', 'H', 'V', 'N'};
    protected static final byte[] REVCOMP = new byte[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 13, 12, 11, 10, 14};
    public static final double[] uniformBackground = new double[]{0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25};

    public Sequence(Sequence sour) {
        this.weight = sour.weight;
        this.direct = sour.direct;
        this.revcomp = sour.revcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(String sour) {
        this.weight = 1.0;
        sour = sour.toUpperCase();
        this.direct = new byte[sour.length()];
        for (int i = 0; i < sour.length(); ++i) {
            this.direct[i] = this.char2byte(sour.charAt(i));
            if (this.direct[i] < 15) continue;
            throw new RuntimeException("found unknown symbol '" + sour.charAt(i) + "'; cannot convert sequence");
        }
        this.revcomp = this.revcomp();
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(String sour, double weight) {
        this(sour);
        this.weight = weight;
    }

    public Sequence(Sequence seqc, double weight) {
        this.weight = weight;
        this.direct = seqc.direct;
        this.revcomp = seqc.revcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp.length];
    }

    public Sequence(byte[] cdirect, byte[] crevcomp, double weight) {
        this.weight = weight;
        this.direct = cdirect;
        this.revcomp = crevcomp;
        this.hdirect = new double[this.direct.length];
        this.hrevcomp = new double[this.revcomp == null ? 0 : this.revcomp.length];
    }

    @Override
    public byte[] revcomp() {
        byte[] strand2 = new byte[this.direct.length];
        for (int i = 0; i < this.direct.length; ++i) {
            strand2[strand2.length - i - 1] = REVCOMP[this.direct[i]];
        }
        return strand2;
    }

    protected byte char2byte(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
            case 'R': {
                return 4;
            }
            case 'Y': {
                return 5;
            }
            case 'K': {
                return 6;
            }
            case 'M': {
                return 7;
            }
            case 'S': {
                return 8;
            }
            case 'W': {
                return 9;
            }
            case 'B': {
                return 10;
            }
            case 'D': {
                return 11;
            }
            case 'H': {
                return 12;
            }
            case 'V': {
                return 13;
            }
            case 'N': {
                return 14;
            }
        }
        throw new RuntimeException("found unknown symbol '" + c + "'; cannot convert sequence");
    }

    public static byte[] str2seq(String s) {
        return new Sequence((String)s).direct;
    }

    public static String seq2str(byte[] seq) {
        StringBuilder str = new StringBuilder();
        for (byte b : seq) {
            str.append(BYTE2CHAR[b]);
        }
        return str.toString();
    }

    @Override
    public String word2str(byte[] seq, int offset, int length) {
        StringBuilder str = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            str.append(BYTE2CHAR[seq[i]]);
        }
        return str.toString();
    }

    @Override
    public Sequence copy() {
        byte[] cdirect = new byte[this.direct.length];
        byte[] crevcomp = new byte[this.revcomp.length];
        System.arraycopy(this.direct, 0, cdirect, 0, this.direct.length);
        System.arraycopy(this.revcomp, 0, crevcomp, 0, this.revcomp.length);
        return new Sequence(cdirect, crevcomp, this.weight);
    }

    public static double[] background(Sequence[] sequences) {
        double[] probs = new double[15];
        int total_length = 0;
        for (Sequence sequence : sequences) {
            total_length += sequence.direct.length;
            for (int i = 0; i < sequence.direct.length; ++i) {
                if (sequence.revcomp != null) {
                    byte by = sequence.direct[i];
                    probs[by] = probs[by] + 0.5;
                    byte by2 = sequence.revcomp[i];
                    probs[by2] = probs[by2] + 0.5;
                    continue;
                }
                byte by = sequence.direct[i];
                probs[by] = probs[by] + 1.0;
            }
        }
        probs[0] = probs[0] + probs[14] / 4.0;
        probs[1] = probs[1] + probs[14] / 4.0;
        probs[2] = probs[2] + probs[14] / 4.0;
        probs[3] = probs[3] + probs[14] / 4.0;
        probs[0] = probs[0] + probs[13] / 3.0;
        probs[1] = probs[1] + probs[13] / 3.0;
        probs[2] = probs[2] + probs[13] / 3.0;
        probs[0] = probs[0] + probs[12] / 3.0;
        probs[1] = probs[1] + probs[12] / 3.0;
        probs[3] = probs[3] + probs[12] / 3.0;
        probs[0] = probs[0] + probs[11] / 3.0;
        probs[2] = probs[2] + probs[11] / 3.0;
        probs[3] = probs[3] + probs[11] / 3.0;
        probs[1] = probs[1] + probs[10] / 3.0;
        probs[2] = probs[2] + probs[10] / 3.0;
        probs[3] = probs[3] + probs[10] / 3.0;
        probs[0] = probs[0] + probs[9] / 2.0;
        probs[3] = probs[3] + probs[9] / 2.0;
        probs[1] = probs[1] + probs[8] / 2.0;
        probs[2] = probs[2] + probs[8] / 2.0;
        probs[0] = probs[0] + probs[7] / 2.0;
        probs[1] = probs[1] + probs[7] / 2.0;
        probs[2] = probs[2] + probs[6] / 2.0;
        probs[3] = probs[3] + probs[6] / 2.0;
        probs[1] = probs[1] + probs[5] / 2.0;
        probs[3] = probs[3] + probs[5] / 2.0;
        probs[0] = probs[0] + probs[4] / 2.0;
        probs[2] = probs[2] + probs[4] / 2.0;
        int i = 0;
        while (i < 4) {
            int n = i++;
            probs[n] = probs[n] / (double)total_length;
        }
        WPCM.iupacomprobs(probs);
        return probs;
    }

    public static double[] background(double gcp) {
        double[] background = new double[15];
        background[1] = background[2] = gcp / 2.0;
        background[0] = background[3] = (1.0 - gcp) / 2.0;
        background[14] = (background[0] + background[1] + background[2] + background[3]) / 4.0;
        background[13] = (background[0] + background[1] + background[2]) / 3.0;
        background[12] = (background[0] + background[1] + background[3]) / 3.0;
        background[11] = (background[0] + background[2] + background[3]) / 3.0;
        background[10] = (background[1] + background[2] + background[3]) / 3.0;
        background[9] = (background[0] + background[3]) / 2.0;
        background[8] = (background[1] + background[2]) / 2.0;
        background[7] = (background[0] + background[1]) / 2.0;
        background[6] = (background[2] + background[3]) / 2.0;
        background[5] = (background[1] + background[3]) / 2.0;
        background[4] = (background[0] + background[2]) / 2.0;
        return background;
    }
}

