"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const cdk = require("@aws-cdk/core");
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({ produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                } }),
            options: props.options,
        });
    }
    bind(method) {
        this.scope = method;
        return;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFxQztBQUNyQyxnREFBcUc7QUFFckcsa0NBQTBDO0FBNkQxQzs7Ozs7R0FLRztBQUNILE1BQWEsY0FBZSxTQUFRLHlCQUFXO0lBRzdDLFlBQVksS0FBMEI7UUFDcEMsTUFBTSxPQUFPLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUMsU0FBUyxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUN4RixNQUFNLElBQUksR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyw2QkFBZSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsNkJBQWUsQ0FBQyxHQUFHLENBQUM7UUFDM0UsTUFBTSxFQUFFLE9BQU8sRUFBRSxRQUFRLEVBQUUsR0FBRyxzQkFBZSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUNoRyxLQUFLLENBQUM7WUFDSixJQUFJO1lBQ0oscUJBQXFCLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixJQUFJLE1BQU07WUFDNUQsR0FBRyxFQUFFLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRTtvQkFDeEMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUU7d0JBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO3FCQUFFO29CQUMzRSxPQUFPLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxTQUFTLENBQUM7d0JBQ3hDLE9BQU8sRUFBRSxZQUFZO3dCQUNyQixPQUFPLEVBQUUsT0FBTzt3QkFDaEIsUUFBUSxFQUFFLE9BQU87d0JBQ2pCLEdBQUcsRUFBRSxHQUFHO3dCQUNSLFlBQVksRUFBRSxRQUFRO3FCQUN2QixDQUFDLENBQUM7Z0JBQ0wsQ0FBQyxFQUFDLENBQUM7WUFDSCxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87U0FDdkIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLElBQUksQ0FBQyxNQUFjO1FBQ3hCLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDO1FBQ3BCLE9BQU87SUFDVCxDQUFDO0NBQ0Y7QUE1QkQsd0NBNEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgSW50ZWdyYXRpb24sIEludGVncmF0aW9uQ29uZmlnLCBJbnRlZ3JhdGlvbk9wdGlvbnMsIEludGVncmF0aW9uVHlwZSB9IGZyb20gJy4uL2ludGVncmF0aW9uJztcbmltcG9ydCB7IE1ldGhvZCB9IGZyb20gJy4uL21ldGhvZCc7XG5pbXBvcnQgeyBwYXJzZUF3c0FwaUNhbGwgfSBmcm9tICcuLi91dGlsJztcblxuZXhwb3J0IGludGVyZmFjZSBBd3NJbnRlZ3JhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFVzZSBBV1NfUFJPWFkgaW50ZWdyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBwcm94eT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBpbnRlZ3JhdGVkIEFXUyBzZXJ2aWNlIChlLmcuIGBzM2ApXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgZGVzaWduYXRlZCBzdWJkb21haW4gc3VwcG9ydGVkIGJ5IGNlcnRhaW4gQVdTIHNlcnZpY2UgZm9yIGZhc3RcbiAgICogaG9zdC1uYW1lIGxvb2t1cC5cbiAgICovXG4gIHJlYWRvbmx5IHN1YmRvbWFpbj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHBhdGggdG8gdXNlIGZvciBwYXRoLWJhc2UgQVBJcy5cbiAgICpcbiAgICogRm9yIGV4YW1wbGUsIGZvciBTMyBHRVQsIHlvdSBjYW4gc2V0IHBhdGggdG8gYGJ1Y2tldC9rZXlgLlxuICAgKiBGb3IgbGFtYmRhLCB5b3UgY2FuIHNldCBwYXRoIHRvIGAyMDE1LTAzLTMxL2Z1bmN0aW9ucy8ke2Z1bmN0aW9uLWFybn0vaW52b2NhdGlvbnNgXG4gICAqXG4gICAqIE11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIHRoZSBgYWN0aW9uYCBvcHRpb25zLlxuICAgKi9cbiAgcmVhZG9ubHkgcGF0aD86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFXUyBhY3Rpb24gdG8gcGVyZm9ybSBpbiB0aGUgaW50ZWdyYXRpb24uXG4gICAqXG4gICAqIFVzZSBgYWN0aW9uUGFyYW1zYCB0byBzcGVjaWZ5IGtleS12YWx1ZSBwYXJhbXMgZm9yIHRoZSBhY3Rpb24uXG4gICAqXG4gICAqIE11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIGBwYXRoYC5cbiAgICovXG4gIHJlYWRvbmx5IGFjdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogUGFyYW1ldGVycyBmb3IgdGhlIGFjdGlvbi5cbiAgICpcbiAgICogYGFjdGlvbmAgbXVzdCBiZSBzZXQsIGFuZCBgcGF0aGAgbXVzdCBiZSB1bmRlZmluZWQuXG4gICAqIFRoZSBhY3Rpb24gcGFyYW1zIHdpbGwgYmUgVVJMIGVuY29kZWQuXG4gICAqL1xuICByZWFkb25seSBhY3Rpb25QYXJhbWV0ZXJzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogVGhlIGludGVncmF0aW9uJ3MgSFRUUCBtZXRob2QgdHlwZS5cbiAgICpcbiAgICogQGRlZmF1bHQgUE9TVFxuICAgKi9cbiAgcmVhZG9ubHkgaW50ZWdyYXRpb25IdHRwTWV0aG9kPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiBvcHRpb25zLCBzdWNoIGFzIGNvbnRlbnQgaGFuZGxpbmcsIHJlcXVlc3QvcmVzcG9uc2UgbWFwcGluZywgZXRjLlxuICAgKi9cbiAgcmVhZG9ubHkgb3B0aW9ucz86IEludGVncmF0aW9uT3B0aW9uc1xufVxuXG4vKipcbiAqIFRoaXMgdHlwZSBvZiBpbnRlZ3JhdGlvbiBsZXRzIGFuIEFQSSBleHBvc2UgQVdTIHNlcnZpY2UgYWN0aW9ucy4gSXQgaXNcbiAqIGludGVuZGVkIGZvciBjYWxsaW5nIGFsbCBBV1Mgc2VydmljZSBhY3Rpb25zLCBidXQgaXMgbm90IHJlY29tbWVuZGVkIGZvclxuICogY2FsbGluZyBhIExhbWJkYSBmdW5jdGlvbiwgYmVjYXVzZSB0aGUgTGFtYmRhIGN1c3RvbSBpbnRlZ3JhdGlvbiBpcyBhIGxlZ2FjeVxuICogdGVjaG5vbG9neS5cbiAqL1xuZXhwb3J0IGNsYXNzIEF3c0ludGVncmF0aW9uIGV4dGVuZHMgSW50ZWdyYXRpb24ge1xuICBwcml2YXRlIHNjb3BlPzogY2RrLklDb25zdHJ1Y3Q7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IEF3c0ludGVncmF0aW9uUHJvcHMpIHtcbiAgICBjb25zdCBiYWNrZW5kID0gcHJvcHMuc3ViZG9tYWluID8gYCR7cHJvcHMuc3ViZG9tYWlufS4ke3Byb3BzLnNlcnZpY2V9YCA6IHByb3BzLnNlcnZpY2U7XG4gICAgY29uc3QgdHlwZSA9IHByb3BzLnByb3h5ID8gSW50ZWdyYXRpb25UeXBlLkFXU19QUk9YWSA6IEludGVncmF0aW9uVHlwZS5BV1M7XG4gICAgY29uc3QgeyBhcGlUeXBlLCBhcGlWYWx1ZSB9ID0gcGFyc2VBd3NBcGlDYWxsKHByb3BzLnBhdGgsIHByb3BzLmFjdGlvbiwgcHJvcHMuYWN0aW9uUGFyYW1ldGVycyk7XG4gICAgc3VwZXIoe1xuICAgICAgdHlwZSxcbiAgICAgIGludGVncmF0aW9uSHR0cE1ldGhvZDogcHJvcHMuaW50ZWdyYXRpb25IdHRwTWV0aG9kIHx8ICdQT1NUJyxcbiAgICAgIHVyaTogY2RrLkxhenkuc3RyaW5nVmFsdWUoeyBwcm9kdWNlOiAoKSA9PiB7XG4gICAgICAgIGlmICghdGhpcy5zY29wZSkgeyB0aHJvdyBuZXcgRXJyb3IoJ0F3c0ludGVncmF0aW9uIG11c3QgYmUgdXNlZCBpbiBBUEknKTsgfVxuICAgICAgICByZXR1cm4gY2RrLlN0YWNrLm9mKHRoaXMuc2NvcGUpLmZvcm1hdEFybih7XG4gICAgICAgICAgc2VydmljZTogJ2FwaWdhdGV3YXknLFxuICAgICAgICAgIGFjY291bnQ6IGJhY2tlbmQsXG4gICAgICAgICAgcmVzb3VyY2U6IGFwaVR5cGUsXG4gICAgICAgICAgc2VwOiAnLycsXG4gICAgICAgICAgcmVzb3VyY2VOYW1lOiBhcGlWYWx1ZSxcbiAgICAgICAgfSk7XG4gICAgICB9fSksXG4gICAgICBvcHRpb25zOiBwcm9wcy5vcHRpb25zLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGJpbmQobWV0aG9kOiBNZXRob2QpOiBJbnRlZ3JhdGlvbkNvbmZpZyB8IHVuZGVmaW5lZCB7XG4gICAgdGhpcy5zY29wZSA9IG1ldGhvZDtcbiAgICByZXR1cm47XG4gIH1cbn1cbiJdfQ==