"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const apigateway = require("../lib");
/*
 * Stack verification steps:
 * * `curl -i <CFN output PetsURL>` should return HTTP code 200
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integtest-restapi-fromdefinition-inline');
const api = new apigateway.SpecRestApi(stack, 'my-api', {
    apiDefinition: apigateway.ApiDefinition.fromInline({
        openapi: '3.0.2',
        info: {
            version: '1.0.0',
            title: 'Test API for CDK',
        },
        paths: {
            '/pets': {
                get: {
                    'summary': 'Test Method',
                    'operationId': 'testMethod',
                    'responses': {
                        200: {
                            description: 'A paged array of pets',
                            content: {
                                'application/json': {
                                    schema: {
                                        $ref: '#/components/schemas/Empty',
                                    },
                                },
                            },
                        },
                    },
                    'x-amazon-apigateway-integration': {
                        responses: {
                            default: {
                                statusCode: '200',
                            },
                        },
                        requestTemplates: {
                            'application/json': '{"statusCode": 200}',
                        },
                        passthroughBehavior: 'when_no_match',
                        type: 'mock',
                    },
                },
            },
        },
        components: {
            schemas: {
                Empty: {
                    title: 'Empty Schema',
                    type: 'object',
                },
            },
        },
    }),
});
new cdk.CfnOutput(stack, 'PetsURL', {
    value: api.urlForPath('/pets'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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