"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryDefinition = exports.QueryString = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const _1 = require(".");
/**
 * Define a QueryString
 */
class QueryString {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_QueryStringProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, QueryString);
            }
            throw error;
        }
        this.fields = props.fields;
        this.parse = props.parse;
        this.filter = props.filter;
        this.stats = props.stats;
        this.sort = props.sort;
        this.limit = props.limit;
        this.display = props.display;
    }
    /**
    * String representation of this QueryString.
    */
    toString() {
        return noUndef({
            fields: this.fields !== undefined ? this.fields.join(', ') : this.fields,
            parse: this.parse,
            filter: this.filter,
            stats: this.stats,
            sort: this.sort,
            limit: this.limit,
            display: this.display,
        }).join(' | ');
    }
}
exports.QueryString = QueryString;
_a = JSII_RTTI_SYMBOL_1;
QueryString[_a] = { fqn: "@aws-cdk/aws-logs.QueryString", version: "1.179.0" };
function noUndef(x) {
    const ret = [];
    for (const [key, value] of Object.entries(x)) {
        if (value !== undefined) {
            ret.push(`${key} ${value}`);
        }
    }
    return ret;
}
/**
 * Define a query definition for CloudWatch Logs Insights
 */
class QueryDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.queryDefinitionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_QueryDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, QueryDefinition);
            }
            throw error;
        }
        const queryDefinition = new _1.CfnQueryDefinition(this, 'Resource', {
            name: props.queryDefinitionName,
            queryString: props.queryString.toString(),
            logGroupNames: typeof props.logGroups === 'undefined' ? [] : props.logGroups.flatMap(logGroup => logGroup.logGroupName),
        });
        this.queryDefinitionId = queryDefinition.attrQueryDefinitionId;
    }
}
exports.QueryDefinition = QueryDefinition;
_b = JSII_RTTI_SYMBOL_1;
QueryDefinition[_b] = { fqn: "@aws-cdk/aws-logs.QueryDefinition", version: "1.179.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVlcnktZGVmaW5pdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInF1ZXJ5LWRlZmluaXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsd0NBQXlDO0FBRXpDLHdCQUF1QztBQW9FdkM7O0dBRUc7QUFDSCxNQUFhLFdBQVc7SUFTdEIsWUFBWSxRQUEwQixFQUFFOzs7Ozs7K0NBVDdCLFdBQVc7Ozs7UUFVcEIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7UUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO0tBQzlCO0lBRUQ7O01BRUU7SUFDSyxRQUFRO1FBQ2IsT0FBTyxPQUFPLENBQUM7WUFDYixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTTtZQUN4RSxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDakIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDakIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ3RCLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDaEI7O0FBaENILGtDQWlDQzs7O0FBRUQsU0FBUyxPQUFPLENBQUMsQ0FBaUI7SUFDaEMsTUFBTSxHQUFHLEdBQWEsRUFBRSxDQUFDO0lBQ3pCLEtBQUssTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFO1FBQzVDLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDLENBQUM7U0FDN0I7S0FDRjtJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQztBQXdCRDs7R0FFRztBQUNILE1BQWEsZUFBZ0IsU0FBUSxlQUFRO0lBUTNDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixZQUFZLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtTQUN4QyxDQUFDLENBQUM7Ozs7OzsrQ0FYTSxlQUFlOzs7O1FBYXhCLE1BQU0sZUFBZSxHQUFHLElBQUkscUJBQWtCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMvRCxJQUFJLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUMvQixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUU7WUFDekMsYUFBYSxFQUFFLE9BQU8sS0FBSyxDQUFDLFNBQVMsS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDO1NBQ3hILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxpQkFBaUIsR0FBRyxlQUFlLENBQUMscUJBQXFCLENBQUM7S0FDaEU7O0FBcEJILDBDQXFCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblF1ZXJ5RGVmaW5pdGlvbiB9IGZyb20gJy4nO1xuaW1wb3J0IHsgSUxvZ0dyb3VwIH0gZnJvbSAnLi9sb2ctZ3JvdXAnO1xuXG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBRdWVyeVN0cmluZ1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFF1ZXJ5U3RyaW5nUHJvcHMge1xuICAvKipcbiAgKiBSZXRyaWV2ZXMgdGhlIHNwZWNpZmllZCBmaWVsZHMgZnJvbSBsb2cgZXZlbnRzIGZvciBkaXNwbGF5LlxuICAqXG4gICogQGRlZmF1bHQgLSBubyBmaWVsZHMgaW4gUXVlcnlTdHJpbmdcbiAgKi9cbiAgcmVhZG9ubHkgZmllbGRzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICogRXh0cmFjdHMgZGF0YSBmcm9tIGEgbG9nIGZpZWxkIGFuZCBjcmVhdGVzIG9uZSBvciBtb3JlIGVwaGVtZXJhbCBmaWVsZHMgdGhhdCB5b3UgY2FuIHByb2Nlc3MgZnVydGhlciBpbiB0aGUgcXVlcnkuXG4gICpcbiAgKiBAZGVmYXVsdCAtIG5vIHBhcnNlIGluIFF1ZXJ5U3RyaW5nXG4gICovXG4gIHJlYWRvbmx5IHBhcnNlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAqIEZpbHRlcnMgdGhlIHJlc3VsdHMgb2YgYSBxdWVyeSB0aGF0J3MgYmFzZWQgb24gb25lIG9yIG1vcmUgY29uZGl0aW9ucy5cbiAgKlxuICAqIEBkZWZhdWx0IC0gbm8gZmlsdGVyIGluIFF1ZXJ5U3RyaW5nXG4gICovXG4gIHJlYWRvbmx5IGZpbHRlcj86IHN0cmluZztcblxuICAvKipcbiAgKiBVc2VzIGxvZyBmaWVsZCB2YWx1ZXMgdG8gY2FsY3VsYXRlIGFnZ3JlZ2F0ZSBzdGF0aXN0aWNzLlxuICAqXG4gICogQGRlZmF1bHQgLSBubyBzdGF0cyBpbiBRdWVyeVN0cmluZ1xuICAqL1xuICByZWFkb25seSBzdGF0cz86IHN0cmluZztcblxuICAvKipcbiAgKiBTb3J0cyB0aGUgcmV0cmlldmVkIGxvZyBldmVudHMuXG4gICpcbiAgKiBAZGVmYXVsdCAtIG5vIHNvcnQgaW4gUXVlcnlTdHJpbmdcbiAgKi9cbiAgcmVhZG9ubHkgc29ydD86IHN0cmluZztcblxuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIG51bWJlciBvZiBsb2cgZXZlbnRzIHJldHVybmVkIGJ5IHRoZSBxdWVyeS5cbiAgKlxuICAqIEBkZWZhdWx0IC0gbm8gbGltaXQgaW4gUXVlcnlTdHJpbmdcbiAgKi9cbiAgcmVhZG9ubHkgbGltaXQ/OiBOdW1iZXI7XG5cbiAgLyoqXG4gICogU3BlY2lmaWVzIHdoaWNoIGZpZWxkcyB0byBkaXNwbGF5IGluIHRoZSBxdWVyeSByZXN1bHRzLlxuICAqXG4gICogQGRlZmF1bHQgLSBubyBkaXNwbGF5IGluIFF1ZXJ5U3RyaW5nXG4gICovXG4gIHJlYWRvbmx5IGRpc3BsYXk/OiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBRdWVyeVN0cmluZ01hcCB7XG4gIHJlYWRvbmx5IGZpZWxkcz86IHN0cmluZyxcbiAgcmVhZG9ubHkgcGFyc2U/OiBzdHJpbmcsXG4gIHJlYWRvbmx5IGZpbHRlcj86IHN0cmluZyxcbiAgcmVhZG9ubHkgc3RhdHM/OiBzdHJpbmcsXG4gIHJlYWRvbmx5IHNvcnQ/OiBzdHJpbmcsXG4gIHJlYWRvbmx5IGxpbWl0PzogTnVtYmVyLFxuICByZWFkb25seSBkaXNwbGF5Pzogc3RyaW5nLFxufVxuXG4vKipcbiAqIERlZmluZSBhIFF1ZXJ5U3RyaW5nXG4gKi9cbmV4cG9ydCBjbGFzcyBRdWVyeVN0cmluZyB7XG4gIHByaXZhdGUgcmVhZG9ubHkgZmllbGRzPzogc3RyaW5nW107XG4gIHByaXZhdGUgcmVhZG9ubHkgcGFyc2U/OiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgZmlsdGVyPzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IHN0YXRzPzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IHNvcnQ/OiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkgbGltaXQ/OiBOdW1iZXI7XG4gIHByaXZhdGUgcmVhZG9ubHkgZGlzcGxheT86IHN0cmluZztcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogUXVlcnlTdHJpbmdQcm9wcyA9IHt9KSB7XG4gICAgdGhpcy5maWVsZHMgPSBwcm9wcy5maWVsZHM7XG4gICAgdGhpcy5wYXJzZSA9IHByb3BzLnBhcnNlO1xuICAgIHRoaXMuZmlsdGVyID0gcHJvcHMuZmlsdGVyO1xuICAgIHRoaXMuc3RhdHMgPSBwcm9wcy5zdGF0cztcbiAgICB0aGlzLnNvcnQgPSBwcm9wcy5zb3J0O1xuICAgIHRoaXMubGltaXQgPSBwcm9wcy5saW1pdDtcbiAgICB0aGlzLmRpc3BsYXkgPSBwcm9wcy5kaXNwbGF5O1xuICB9XG5cbiAgLyoqXG4gICogU3RyaW5nIHJlcHJlc2VudGF0aW9uIG9mIHRoaXMgUXVlcnlTdHJpbmcuXG4gICovXG4gIHB1YmxpYyB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiBub1VuZGVmKHtcbiAgICAgIGZpZWxkczogdGhpcy5maWVsZHMgIT09IHVuZGVmaW5lZCA/IHRoaXMuZmllbGRzLmpvaW4oJywgJykgOiB0aGlzLmZpZWxkcyxcbiAgICAgIHBhcnNlOiB0aGlzLnBhcnNlLFxuICAgICAgZmlsdGVyOiB0aGlzLmZpbHRlcixcbiAgICAgIHN0YXRzOiB0aGlzLnN0YXRzLFxuICAgICAgc29ydDogdGhpcy5zb3J0LFxuICAgICAgbGltaXQ6IHRoaXMubGltaXQsXG4gICAgICBkaXNwbGF5OiB0aGlzLmRpc3BsYXksXG4gICAgfSkuam9pbignIHwgJyk7XG4gIH1cbn1cblxuZnVuY3Rpb24gbm9VbmRlZih4OiBRdWVyeVN0cmluZ01hcCk6IHN0cmluZ1tdIHtcbiAgY29uc3QgcmV0OiBzdHJpbmdbXSA9IFtdO1xuICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyh4KSkge1xuICAgIGlmICh2YWx1ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXQucHVzaChgJHtrZXl9ICR7dmFsdWV9YCk7XG4gICAgfVxuICB9XG4gIHJldHVybiByZXQ7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBRdWVyeURlZmluaXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBRdWVyeURlZmluaXRpb25Qcm9wcyB7XG4gIC8qKlxuICAqIE5hbWUgb2YgdGhlIHF1ZXJ5IGRlZmluaXRpb24uXG4gICovXG4gIHJlYWRvbmx5IHF1ZXJ5RGVmaW5pdGlvbk5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHF1ZXJ5IHN0cmluZyB0byB1c2UgZm9yIHRoaXMgcXVlcnkgZGVmaW5pdGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IHF1ZXJ5U3RyaW5nOiBRdWVyeVN0cmluZztcblxuICAvKipcbiAgKiBTcGVjaWZ5IGNlcnRhaW4gbG9nIGdyb3VwcyBmb3IgdGhlIHF1ZXJ5IGRlZmluaXRpb24uXG4gICpcbiAgKiBAZGVmYXVsdCAtIG5vIHNwZWNpZmllZCBsb2cgZ3JvdXBzXG4gICovXG4gIHJlYWRvbmx5IGxvZ0dyb3Vwcz86IElMb2dHcm91cFtdO1xufVxuXG4vKipcbiAqIERlZmluZSBhIHF1ZXJ5IGRlZmluaXRpb24gZm9yIENsb3VkV2F0Y2ggTG9ncyBJbnNpZ2h0c1xuICovXG5leHBvcnQgY2xhc3MgUXVlcnlEZWZpbml0aW9uIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAvKipcbiAgICogVGhlIElEIG9mIHRoZSBxdWVyeSBkZWZpbml0aW9uLlxuICAgKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcXVlcnlEZWZpbml0aW9uSWQ6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUXVlcnlEZWZpbml0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMucXVlcnlEZWZpbml0aW9uTmFtZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHF1ZXJ5RGVmaW5pdGlvbiA9IG5ldyBDZm5RdWVyeURlZmluaXRpb24odGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgbmFtZTogcHJvcHMucXVlcnlEZWZpbml0aW9uTmFtZSxcbiAgICAgIHF1ZXJ5U3RyaW5nOiBwcm9wcy5xdWVyeVN0cmluZy50b1N0cmluZygpLFxuICAgICAgbG9nR3JvdXBOYW1lczogdHlwZW9mIHByb3BzLmxvZ0dyb3VwcyA9PT0gJ3VuZGVmaW5lZCcgPyBbXSA6IHByb3BzLmxvZ0dyb3Vwcy5mbGF0TWFwKGxvZ0dyb3VwID0+IGxvZ0dyb3VwLmxvZ0dyb3VwTmFtZSksXG4gICAgfSk7XG5cbiAgICB0aGlzLnF1ZXJ5RGVmaW5pdGlvbklkID0gcXVlcnlEZWZpbml0aW9uLmF0dHJRdWVyeURlZmluaXRpb25JZDtcbiAgfVxufVxuIl19