#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("../constructs");
const app = new cdk.App();
const stack = new aws_cdk_lib_1.Stack(app, 'ControlBroker');
const api = new constructs_1.Api(stack, 'ControlbrokerApi', {});
const cfnInputHandlerApiBinding = new constructs_1.HttpApiBinding('CloudFormation');
const cfnInputHandler = new constructs_1.CloudFormationInputHandler(stack, 'CfnInputHandler', { binding: cfnInputHandlerApiBinding });
const evalEngineBinding = new constructs_1.HttpApiBinding('EvalEngine');
const evalEngine = new constructs_1.OpaEvalEngine(stack, 'EvalEngine', { binding: evalEngineBinding });
new constructs_1.ControlBroker(stack, 'TestControlBroker', {
    api,
    inputBucket: new aws_s3_1.Bucket(stack, 'InputBucket'),
    resultsBucket: new aws_s3_1.Bucket(stack, 'OutputBucket'),
    evalEngine,
    inputHandlers: [cfnInputHandler],
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29yZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hcHBzL2NvcmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsbUNBQW1DO0FBQ25DLDZDQUFvQztBQUNwQywrQ0FBNEM7QUFDNUMsOENBQThHO0FBRTlHLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksbUJBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFFOUMsTUFBTSxHQUFHLEdBQUcsSUFBSSxnQkFBRyxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUNuRCxNQUFNLHlCQUF5QixHQUFHLElBQUksMkJBQWMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0FBQ3ZFLE1BQU0sZUFBZSxHQUFHLElBQUksdUNBQTBCLENBQUMsS0FBSyxFQUFFLGlCQUFpQixFQUFFLEVBQUUsT0FBTyxFQUFFLHlCQUF5QixFQUFFLENBQUMsQ0FBQztBQUN6SCxNQUFNLGlCQUFpQixHQUFHLElBQUksMkJBQWMsQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUMzRCxNQUFNLFVBQVUsR0FBRyxJQUFJLDBCQUFhLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRSxFQUFFLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxDQUFDLENBQUM7QUFDMUYsSUFBSSwwQkFBYSxDQUFDLEtBQUssRUFBRSxtQkFBbUIsRUFBRTtJQUM1QyxHQUFHO0lBQ0gsV0FBVyxFQUFFLElBQUksZUFBTSxDQUFDLEtBQUssRUFBRSxhQUFhLENBQUM7SUFDN0MsYUFBYSxFQUFFLElBQUksZUFBTSxDQUFDLEtBQUssRUFBRSxjQUFjLENBQUM7SUFDaEQsVUFBVTtJQUNWLGFBQWEsRUFBRSxDQUFDLGVBQWUsQ0FBQztDQUNqQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIjIS91c3IvYmluL2VudiBub2RlXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEJ1Y2tldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBBcGksIENsb3VkRm9ybWF0aW9uSW5wdXRIYW5kbGVyLCBIdHRwQXBpQmluZGluZywgQ29udHJvbEJyb2tlciwgT3BhRXZhbEVuZ2luZSB9IGZyb20gJy4uL2NvbnN0cnVjdHMnO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnQ29udHJvbEJyb2tlcicpO1xuXG5jb25zdCBhcGkgPSBuZXcgQXBpKHN0YWNrLCAnQ29udHJvbGJyb2tlckFwaScsIHt9KTtcbmNvbnN0IGNmbklucHV0SGFuZGxlckFwaUJpbmRpbmcgPSBuZXcgSHR0cEFwaUJpbmRpbmcoJ0Nsb3VkRm9ybWF0aW9uJyk7XG5jb25zdCBjZm5JbnB1dEhhbmRsZXIgPSBuZXcgQ2xvdWRGb3JtYXRpb25JbnB1dEhhbmRsZXIoc3RhY2ssICdDZm5JbnB1dEhhbmRsZXInLCB7IGJpbmRpbmc6IGNmbklucHV0SGFuZGxlckFwaUJpbmRpbmcgfSk7XG5jb25zdCBldmFsRW5naW5lQmluZGluZyA9IG5ldyBIdHRwQXBpQmluZGluZygnRXZhbEVuZ2luZScpO1xuY29uc3QgZXZhbEVuZ2luZSA9IG5ldyBPcGFFdmFsRW5naW5lKHN0YWNrLCAnRXZhbEVuZ2luZScsIHsgYmluZGluZzogZXZhbEVuZ2luZUJpbmRpbmcgfSk7XG5uZXcgQ29udHJvbEJyb2tlcihzdGFjaywgJ1Rlc3RDb250cm9sQnJva2VyJywge1xuICBhcGksXG4gIGlucHV0QnVja2V0OiBuZXcgQnVja2V0KHN0YWNrLCAnSW5wdXRCdWNrZXQnKSxcbiAgcmVzdWx0c0J1Y2tldDogbmV3IEJ1Y2tldChzdGFjaywgJ091dHB1dEJ1Y2tldCcpLFxuICBldmFsRW5naW5lLFxuICBpbnB1dEhhbmRsZXJzOiBbY2ZuSW5wdXRIYW5kbGVyXSxcbn0pO1xuIl19