"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseApiBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Base class for an API Binding, which attaches an integration to an API and
 * authorizes principals to invoke the integration via the API attachment.
 *
 * Defined abstractly since there are different types of APIs to attach integrations with
 * and different principals to allow.
 */
class BaseApiBinding {
    /**
     * @param urlSafeName A name suitable for use in an integration's URL. Can contain slashes.
     */
    constructor(urlSafeName) {
        this.urlSafeName = urlSafeName;
        this.headers = {};
    }
    /**
     *
     * @param headers Headers to send to the integration.
     */
    addHeaders(headers) {
        this.headers = {
            ...this.headers,
            ...headers,
        };
    }
}
exports.BaseApiBinding = BaseApiBinding;
_a = JSII_RTTI_SYMBOL_1;
BaseApiBinding[_a] = { fqn: "control-broker.BaseApiBinding", version: "0.12.1" };
//# sourceMappingURL=data:application/json;base64,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