import { HttpRoute, HttpRouteIntegration } from '@aws-cdk/aws-apigatewayv2-alpha';
import { BaseApiBinding } from '.';
import { Api } from '../api';
import { IIntegrationTarget } from '../interfaces/integration-target-interface';
import { AwsApiType } from './constants';
export interface HttpApiBindingAddToApiOptions {
}
export declare class HttpApiBinding extends BaseApiBinding<HttpRouteIntegration> {
    readonly apiType: AwsApiType;
    protected api?: Api;
    protected routes: HttpRoute[];
    protected authorizedPrincipalArns: string[];
    route?: HttpRoute;
    path?: string;
    method?: string;
    constructor(urlSafeName: string);
    bindTargetToApi(api: Api, target: IIntegrationTarget): string;
    /**
     * Note: JSII complains if we make the return type HTTPRouteIntegration,
     * ostensibly because of its restrictions on Generics.
     */
    protected makeIntegrationForIntegrationTarget(target: IIntegrationTarget): any;
    authorizePrincipalArn(principalArn: string): void;
    get url(): string | undefined;
}
