"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_apigatewayv2_authorizers_alpha_1 = require("@aws-cdk/aws-apigatewayv2-authorizers-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const _1 = require(".");
const constants_1 = require("./constants");
const type_guards_1 = require("./type-guards");
class HttpApiBinding extends _1.BaseApiBinding {
    constructor(urlSafeName) {
        super(urlSafeName);
        this.apiType = constants_1.AwsApiType.HTTP;
        this.routes = [];
        this.authorizedPrincipalArns = [];
    }
    bindTargetToApi(api, target) {
        this.api = api;
        this.path = path_1.join('/', this.urlSafeName);
        this.route = api.awsApiGatewayHTTPApi.addRoutes({
            authorizer: new aws_apigatewayv2_authorizers_alpha_1.HttpIamAuthorizer(),
            methods: [aws_events_1.HttpMethod.POST],
            integration: this.makeIntegrationForIntegrationTarget(target),
            path: this.path,
        })[0];
        this.method = aws_events_1.HttpMethod.POST;
        if (api.awsApiGatewayHTTPApi.url === undefined) {
            throw new Error('No default stage defined for the HTTP API');
        }
        return path_1.join(api.awsApiGatewayHTTPApi.url, this.path);
    }
    /**
     * Note: JSII complains if we make the return type HTTPRouteIntegration,
     * ostensibly because of its restrictions on Generics.
     */
    makeIntegrationForIntegrationTarget(target) {
        if (type_guards_1.isLambdaIntegrationTarget(target)) {
            return new aws_apigatewayv2_integrations_alpha_1.HttpLambdaIntegration(`${this.urlSafeName}LambdaIntegration`, target.handler);
        }
        else {
            throw new Error('Only Lambda integrations are supported right now');
        }
    }
    authorizePrincipalArn(principalArn) {
        this.authorizedPrincipalArns.push(principalArn);
        this.routes.forEach((r) => {
            r.grantInvoke(new aws_iam_1.ArnPrincipal(principalArn));
        });
    }
    get url() {
        if (this.api?.awsApiGatewayHTTPApi.url === undefined) {
            throw new Error('Cannot get URL if the base API has no default stage');
        }
        return path_1.join(this.api?.awsApiGatewayHTTPApi.url, this.urlSafeName);
    }
}
exports.HttpApiBinding = HttpApiBinding;
_a = JSII_RTTI_SYMBOL_1;
HttpApiBinding[_a] = { fqn: "control-broker.HttpApiBinding", version: "0.12.1" };
//# sourceMappingURL=data:application/json;base64,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