import { HttpApi } from '@aws-cdk/aws-apigatewayv2-alpha';
import { RestApi } from 'aws-cdk-lib/aws-apigateway';
import { LogGroup, RetentionDays } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { BaseEvalEngine } from '.';
import { BaseApiBinding } from './api-bindings';
import { BaseInputHandler } from './input-handlers';
export interface ApiProps {
    readonly apiAccessLogGroup?: LogGroup;
}
export interface InputHandlerBindingConfiguration {
    readonly inputHandler: BaseInputHandler;
    readonly binding: BaseApiBinding<any>;
}
export interface InputHandlerBindingConfigurations {
    [inputHandlerName: string]: InputHandlerBindingConfiguration;
}
export interface EvalEngineBindingConfiguration {
    readonly evalEngine: BaseEvalEngine | undefined;
    readonly binding: BaseApiBinding<any> | undefined;
}
export declare class Api extends Construct {
    readonly id: string;
    readonly accessLogRetention: RetentionDays;
    readonly apiAccessLogGroup: LogGroup;
    protected inputHandlers: BaseInputHandler[];
    /**
     * @internal
     */
    protected _evalEngine?: BaseEvalEngine;
    /**
     * @internal
     */
    protected _awsApiGatewayHttpApi?: HttpApi;
    /**
     * @internal
     */
    protected _awsApiGatewayRestApi?: RestApi;
    constructor(scope: Construct, id: string, props: ApiProps);
    /**
     * Lazily create the HTTP API when it is first accessed.
     */
    get awsApiGatewayHTTPApi(): HttpApi;
    /**
     * Lazily create the Rest API when it is first accessed.
     */
    get awsApiGatewayRestApi(): RestApi;
    protected configureAwsApiGatewayHTTPApiLogging(): void;
    set evalEngine(evalEngine: BaseEvalEngine | undefined);
    get evalEngine(): BaseEvalEngine | undefined;
    addInputHandler(inputHandler: BaseInputHandler): void;
    getUrlForInputHandler(inputHandler: BaseInputHandler): string | undefined;
}
