"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
class Api extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.accessLogRetention = aws_logs_1.RetentionDays.ONE_DAY;
        this.inputHandlers = [];
        /**
         * @internal
         */
        this._evalEngine = undefined;
        if (props.apiAccessLogGroup) {
            this.apiAccessLogGroup = props.apiAccessLogGroup;
        }
        else {
            this.apiAccessLogGroup = new aws_logs_1.LogGroup(this, `${id}AccessLogGroup`, { retention: this.accessLogRetention });
            this.apiAccessLogGroup.grantWrite(new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'));
        }
        this.configureAwsApiGatewayHTTPApiLogging();
    }
    /**
     * Lazily create the HTTP API when it is first accessed.
     */
    get awsApiGatewayHTTPApi() {
        if (this._awsApiGatewayHttpApi === undefined) {
            this._awsApiGatewayHttpApi = new aws_apigatewayv2_alpha_1.HttpApi(this, `${this.id}HttpApi`, { createDefaultStage: true });
        }
        return this._awsApiGatewayHttpApi;
    }
    /**
     * Lazily create the Rest API when it is first accessed.
     */
    get awsApiGatewayRestApi() {
        if (this._awsApiGatewayRestApi === undefined) {
            this._awsApiGatewayRestApi = new aws_apigateway_1.RestApi(this, `${this.id}RestApi`);
        }
        return this._awsApiGatewayRestApi;
    }
    configureAwsApiGatewayHTTPApiLogging() {
        const cfnDefaultStage = this.awsApiGatewayHTTPApi.defaultStage.node.defaultChild;
        cfnDefaultStage.addPropertyOverride('AccessLogSettings', {
            DestinationArn: this.apiAccessLogGroup.logGroupArn,
            Format: JSON.stringify({
                requestId: '$context.requestId',
                ip: '$context.identity.sourceIp',
                requestTime: '$context.requestTime',
                httpMethod: '$context.httpMethod',
                routeKey: '$context.routeKey',
                status: '$context.status',
                protocol: '$context.protocol',
                responseLength: '$context.responseLength',
                integrationErrorMessage: '$context.integrationErrorMessage',
            }),
        });
    }
    set evalEngine(evalEngine) {
        this._evalEngine = evalEngine;
    }
    get evalEngine() {
        return this._evalEngine;
    }
    addInputHandler(inputHandler) {
        if (this.evalEngine === undefined) {
            throw new Error('You must add an eval engine before trying to add input handlers');
        }
        inputHandler.bindToApi(this);
        this.evalEngine.authorizePrincipalArn(inputHandler.evalEngineCallerPrincipalArn);
        this.inputHandlers.push(inputHandler);
        if (inputHandler.url === undefined) {
            throw new Error("Input handler's URL was undefined even after binding to the API");
        }
        new aws_cdk_lib_1.CfnOutput(this, `${inputHandler.urlSafeName}HandlerURL`, { value: inputHandler.url });
    }
    getUrlForInputHandler(inputHandler) {
        const currentInputHandler = this.inputHandlers.find((ih) => ih === inputHandler);
        return currentInputHandler?.url;
    }
}
exports.Api = Api;
_a = JSII_RTTI_SYMBOL_1;
Api[_a] = { fqn: "control-broker.Api", version: "0.12.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbnN0cnVjdHMvYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNEVBQTBEO0FBQzFELDZDQUF3QztBQUN4QywrREFBcUQ7QUFFckQsaURBQXVEO0FBQ3ZELG1EQUErRDtBQUMvRCwyQ0FBdUM7QUF1QnZDLE1BQWEsR0FBSSxTQUFRLHNCQUFTO0lBa0JoQyxZQUFZLEtBQWdCLEVBQWtCLEVBQVUsRUFBRSxLQUFlO1FBQ3ZFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFEMkIsT0FBRSxHQUFGLEVBQUUsQ0FBUTtRQWpCeEMsdUJBQWtCLEdBQWtCLHdCQUFhLENBQUMsT0FBTyxDQUFDO1FBR2hFLGtCQUFhLEdBQXVCLEVBQUUsQ0FBQztRQUNqRDs7V0FFRztRQUNPLGdCQUFXLEdBQW9CLFNBQVMsQ0FBQztRQVlqRCxJQUFJLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtZQUMzQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1NBQ2xEO2FBQU07WUFDTCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxtQkFBUSxDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsZ0JBQWdCLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUMsQ0FBQztZQUMzRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsVUFBVSxDQUFDLElBQUksMEJBQWdCLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDO1NBQ3JGO1FBQ0QsSUFBSSxDQUFDLG9DQUFvQyxFQUFFLENBQUM7SUFDOUMsQ0FBQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxvQkFBb0I7UUFDN0IsSUFBSSxJQUFJLENBQUMscUJBQXFCLEtBQUssU0FBUyxFQUFFO1lBQzVDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLGdDQUFPLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDLEVBQUUsU0FBUyxFQUFFLEVBQUUsa0JBQWtCLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUNuRztRQUNELE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcsb0JBQW9CO1FBQzdCLElBQUksSUFBSSxDQUFDLHFCQUFxQixLQUFLLFNBQVMsRUFBRTtZQUM1QyxJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSx3QkFBTyxDQUFDLElBQUksRUFBRSxHQUFHLElBQUksQ0FBQyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1NBQ3JFO1FBQ0QsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUVTLG9DQUFvQztRQUM1QyxNQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsWUFBYSxDQUFDLElBQUksQ0FBQyxZQUF3QixDQUFDO1FBQzlGLGVBQWUsQ0FBQyxtQkFBbUIsQ0FBQyxtQkFBbUIsRUFBRTtZQUN2RCxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFdBQVc7WUFDbEQsTUFBTSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUM7Z0JBQ3JCLFNBQVMsRUFBRSxvQkFBb0I7Z0JBQy9CLEVBQUUsRUFBRSw0QkFBNEI7Z0JBQ2hDLFdBQVcsRUFBRSxzQkFBc0I7Z0JBQ25DLFVBQVUsRUFBRSxxQkFBcUI7Z0JBQ2pDLFFBQVEsRUFBRSxtQkFBbUI7Z0JBQzdCLE1BQU0sRUFBRSxpQkFBaUI7Z0JBQ3pCLFFBQVEsRUFBRSxtQkFBbUI7Z0JBQzdCLGNBQWMsRUFBRSx5QkFBeUI7Z0JBQ3pDLHVCQUF1QixFQUFFLGtDQUFrQzthQUM1RCxDQUFDO1NBQ0gsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELElBQVcsVUFBVSxDQUFDLFVBQXNDO1FBQzFELElBQUksQ0FBQyxXQUFXLEdBQUcsVUFBVSxDQUFDO0lBQ2hDLENBQUM7SUFFRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFFTSxlQUFlLENBQUMsWUFBOEI7UUFDbkQsSUFBSSxJQUFJLENBQUMsVUFBVSxLQUFLLFNBQVMsRUFBRTtZQUNqQyxNQUFNLElBQUksS0FBSyxDQUFDLGlFQUFpRSxDQUFDLENBQUM7U0FDcEY7UUFDRCxZQUFZLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUMsWUFBWSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDakYsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDdEMsSUFBSSxZQUFZLENBQUMsR0FBRyxLQUFLLFNBQVMsRUFBRTtZQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLGlFQUFpRSxDQUFDLENBQUM7U0FDcEY7UUFDRCxJQUFJLHVCQUFTLENBQUMsSUFBSSxFQUFFLEdBQUcsWUFBWSxDQUFDLFdBQVcsWUFBWSxFQUFFLEVBQUUsS0FBSyxFQUFFLFlBQVksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDO0lBQzVGLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxZQUE4QjtRQUN6RCxNQUFNLG1CQUFtQixHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEtBQUssWUFBWSxDQUFDLENBQUM7UUFDakYsT0FBTyxtQkFBbUIsRUFBRSxHQUFHLENBQUM7SUFDbEMsQ0FBQzs7QUEzRkgsa0JBNEZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSHR0cEFwaSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1hcGlnYXRld2F5djItYWxwaGEnO1xuaW1wb3J0IHsgQ2ZuT3V0cHV0IH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUmVzdEFwaSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IENmblN0YWdlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWFwaWdhdGV3YXl2Mic7XG5pbXBvcnQgeyBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBMb2dHcm91cCwgUmV0ZW50aW9uRGF5cyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1sb2dzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQmFzZUV2YWxFbmdpbmUgfSBmcm9tICcuJztcbmltcG9ydCB7IEJhc2VBcGlCaW5kaW5nIH0gZnJvbSAnLi9hcGktYmluZGluZ3MnO1xuaW1wb3J0IHsgQmFzZUlucHV0SGFuZGxlciB9IGZyb20gJy4vaW5wdXQtaGFuZGxlcnMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEFwaVByb3BzIHtcbiAgcmVhZG9ubHkgYXBpQWNjZXNzTG9nR3JvdXA/OiBMb2dHcm91cDtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJbnB1dEhhbmRsZXJCaW5kaW5nQ29uZmlndXJhdGlvbiB7XG4gIHJlYWRvbmx5IGlucHV0SGFuZGxlcjogQmFzZUlucHV0SGFuZGxlcjtcbiAgcmVhZG9ubHkgYmluZGluZzogQmFzZUFwaUJpbmRpbmc8YW55Pjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJbnB1dEhhbmRsZXJCaW5kaW5nQ29uZmlndXJhdGlvbnMge1xuICBbaW5wdXRIYW5kbGVyTmFtZTogc3RyaW5nXTogSW5wdXRIYW5kbGVyQmluZGluZ0NvbmZpZ3VyYXRpb247XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRXZhbEVuZ2luZUJpbmRpbmdDb25maWd1cmF0aW9uIHtcbiAgcmVhZG9ubHkgZXZhbEVuZ2luZTogQmFzZUV2YWxFbmdpbmUgfCB1bmRlZmluZWQ7XG4gIHJlYWRvbmx5IGJpbmRpbmc6IEJhc2VBcGlCaW5kaW5nPGFueT4gfCB1bmRlZmluZWQ7XG59XG5cbmV4cG9ydCBjbGFzcyBBcGkgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgYWNjZXNzTG9nUmV0ZW50aW9uOiBSZXRlbnRpb25EYXlzID0gUmV0ZW50aW9uRGF5cy5PTkVfREFZO1xuICBwdWJsaWMgcmVhZG9ubHkgYXBpQWNjZXNzTG9nR3JvdXA6IExvZ0dyb3VwO1xuXG4gIHByb3RlY3RlZCBpbnB1dEhhbmRsZXJzOiBCYXNlSW5wdXRIYW5kbGVyW10gPSBbXTtcbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHJvdGVjdGVkIF9ldmFsRW5naW5lPzogQmFzZUV2YWxFbmdpbmUgPSB1bmRlZmluZWQ7XG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHByb3RlY3RlZCBfYXdzQXBpR2F0ZXdheUh0dHBBcGk/OiBIdHRwQXBpO1xuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcm90ZWN0ZWQgX2F3c0FwaUdhdGV3YXlSZXN0QXBpPzogUmVzdEFwaTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBwdWJsaWMgcmVhZG9ubHkgaWQ6IHN0cmluZywgcHJvcHM6IEFwaVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBpZiAocHJvcHMuYXBpQWNjZXNzTG9nR3JvdXApIHtcbiAgICAgIHRoaXMuYXBpQWNjZXNzTG9nR3JvdXAgPSBwcm9wcy5hcGlBY2Nlc3NMb2dHcm91cDtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5hcGlBY2Nlc3NMb2dHcm91cCA9IG5ldyBMb2dHcm91cCh0aGlzLCBgJHtpZH1BY2Nlc3NMb2dHcm91cGAsIHsgcmV0ZW50aW9uOiB0aGlzLmFjY2Vzc0xvZ1JldGVudGlvbiB9KTtcbiAgICAgIHRoaXMuYXBpQWNjZXNzTG9nR3JvdXAuZ3JhbnRXcml0ZShuZXcgU2VydmljZVByaW5jaXBhbCgnYXBpZ2F0ZXdheS5hbWF6b25hd3MuY29tJykpO1xuICAgIH1cbiAgICB0aGlzLmNvbmZpZ3VyZUF3c0FwaUdhdGV3YXlIVFRQQXBpTG9nZ2luZygpO1xuICB9XG5cbiAgLyoqXG4gICAqIExhemlseSBjcmVhdGUgdGhlIEhUVFAgQVBJIHdoZW4gaXQgaXMgZmlyc3QgYWNjZXNzZWQuXG4gICAqL1xuICBwdWJsaWMgZ2V0IGF3c0FwaUdhdGV3YXlIVFRQQXBpKCkge1xuICAgIGlmICh0aGlzLl9hd3NBcGlHYXRld2F5SHR0cEFwaSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLl9hd3NBcGlHYXRld2F5SHR0cEFwaSA9IG5ldyBIdHRwQXBpKHRoaXMsIGAke3RoaXMuaWR9SHR0cEFwaWAsIHsgY3JlYXRlRGVmYXVsdFN0YWdlOiB0cnVlIH0pO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5fYXdzQXBpR2F0ZXdheUh0dHBBcGk7XG4gIH1cblxuICAvKipcbiAgICogTGF6aWx5IGNyZWF0ZSB0aGUgUmVzdCBBUEkgd2hlbiBpdCBpcyBmaXJzdCBhY2Nlc3NlZC5cbiAgICovXG4gIHB1YmxpYyBnZXQgYXdzQXBpR2F0ZXdheVJlc3RBcGkoKSB7XG4gICAgaWYgKHRoaXMuX2F3c0FwaUdhdGV3YXlSZXN0QXBpID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuX2F3c0FwaUdhdGV3YXlSZXN0QXBpID0gbmV3IFJlc3RBcGkodGhpcywgYCR7dGhpcy5pZH1SZXN0QXBpYCk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLl9hd3NBcGlHYXRld2F5UmVzdEFwaTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjb25maWd1cmVBd3NBcGlHYXRld2F5SFRUUEFwaUxvZ2dpbmcoKSB7XG4gICAgY29uc3QgY2ZuRGVmYXVsdFN0YWdlID0gdGhpcy5hd3NBcGlHYXRld2F5SFRUUEFwaS5kZWZhdWx0U3RhZ2UhLm5vZGUuZGVmYXVsdENoaWxkIGFzIENmblN0YWdlO1xuICAgIGNmbkRlZmF1bHRTdGFnZS5hZGRQcm9wZXJ0eU92ZXJyaWRlKCdBY2Nlc3NMb2dTZXR0aW5ncycsIHtcbiAgICAgIERlc3RpbmF0aW9uQXJuOiB0aGlzLmFwaUFjY2Vzc0xvZ0dyb3VwLmxvZ0dyb3VwQXJuLFxuICAgICAgRm9ybWF0OiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgIHJlcXVlc3RJZDogJyRjb250ZXh0LnJlcXVlc3RJZCcsXG4gICAgICAgIGlwOiAnJGNvbnRleHQuaWRlbnRpdHkuc291cmNlSXAnLFxuICAgICAgICByZXF1ZXN0VGltZTogJyRjb250ZXh0LnJlcXVlc3RUaW1lJyxcbiAgICAgICAgaHR0cE1ldGhvZDogJyRjb250ZXh0Lmh0dHBNZXRob2QnLFxuICAgICAgICByb3V0ZUtleTogJyRjb250ZXh0LnJvdXRlS2V5JyxcbiAgICAgICAgc3RhdHVzOiAnJGNvbnRleHQuc3RhdHVzJyxcbiAgICAgICAgcHJvdG9jb2w6ICckY29udGV4dC5wcm90b2NvbCcsXG4gICAgICAgIHJlc3BvbnNlTGVuZ3RoOiAnJGNvbnRleHQucmVzcG9uc2VMZW5ndGgnLFxuICAgICAgICBpbnRlZ3JhdGlvbkVycm9yTWVzc2FnZTogJyRjb250ZXh0LmludGVncmF0aW9uRXJyb3JNZXNzYWdlJyxcbiAgICAgIH0pLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIHNldCBldmFsRW5naW5lKGV2YWxFbmdpbmU6IEJhc2VFdmFsRW5naW5lIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZXZhbEVuZ2luZSA9IGV2YWxFbmdpbmU7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGV2YWxFbmdpbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2V2YWxFbmdpbmU7XG4gIH1cblxuICBwdWJsaWMgYWRkSW5wdXRIYW5kbGVyKGlucHV0SGFuZGxlcjogQmFzZUlucHV0SGFuZGxlcikge1xuICAgIGlmICh0aGlzLmV2YWxFbmdpbmUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdZb3UgbXVzdCBhZGQgYW4gZXZhbCBlbmdpbmUgYmVmb3JlIHRyeWluZyB0byBhZGQgaW5wdXQgaGFuZGxlcnMnKTtcbiAgICB9XG4gICAgaW5wdXRIYW5kbGVyLmJpbmRUb0FwaSh0aGlzKTtcbiAgICB0aGlzLmV2YWxFbmdpbmUuYXV0aG9yaXplUHJpbmNpcGFsQXJuKGlucHV0SGFuZGxlci5ldmFsRW5naW5lQ2FsbGVyUHJpbmNpcGFsQXJuKTtcbiAgICB0aGlzLmlucHV0SGFuZGxlcnMucHVzaChpbnB1dEhhbmRsZXIpO1xuICAgIGlmIChpbnB1dEhhbmRsZXIudXJsID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcIklucHV0IGhhbmRsZXIncyBVUkwgd2FzIHVuZGVmaW5lZCBldmVuIGFmdGVyIGJpbmRpbmcgdG8gdGhlIEFQSVwiKTtcbiAgICB9XG4gICAgbmV3IENmbk91dHB1dCh0aGlzLCBgJHtpbnB1dEhhbmRsZXIudXJsU2FmZU5hbWV9SGFuZGxlclVSTGAsIHsgdmFsdWU6IGlucHV0SGFuZGxlci51cmwgfSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0VXJsRm9ySW5wdXRIYW5kbGVyKGlucHV0SGFuZGxlcjogQmFzZUlucHV0SGFuZGxlcikge1xuICAgIGNvbnN0IGN1cnJlbnRJbnB1dEhhbmRsZXIgPSB0aGlzLmlucHV0SGFuZGxlcnMuZmluZCgoaWgpID0+IGloID09PSBpbnB1dEhhbmRsZXIpO1xuICAgIHJldHVybiBjdXJyZW50SW5wdXRIYW5kbGVyPy51cmw7XG4gIH1cbn1cbiJdfQ==