import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { BaseEvalEngine } from '.';
import { Api } from './api';
import { BaseInputHandler } from './input-handlers';
export interface ControlBrokerProps {
    readonly api: Api;
    readonly inputBucket: Bucket;
    readonly resultsBucket: Bucket;
    readonly evalEngine: BaseEvalEngine;
    readonly inputHandlers: BaseInputHandler[];
}
/**
 * Parameters that components of Control Broker may need.
 */
export interface ControlBrokerParams {
    readonly inputBucket: Bucket;
    readonly resultsBucket: Bucket;
}
export declare class ControlBroker extends Construct {
    readonly api: Api;
    protected readonly params: ControlBrokerParams;
    constructor(scope: Construct, id: string, props: ControlBrokerProps);
    addInputHandler(inputHandler: BaseInputHandler): string | undefined;
    getUrlForInputHandler(inputHandler: BaseInputHandler): string | undefined;
    set evalEngine(evalEngine: BaseEvalEngine | undefined);
}
