"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlBroker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class ControlBroker extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.api = props.api;
        this.params = {
            inputBucket: props.inputBucket,
            resultsBucket: props.resultsBucket,
        };
        this.evalEngine = props.evalEngine;
        props.inputHandlers.forEach((ih) => this.addInputHandler(ih));
        new aws_cdk_lib_1.CfnOutput(this, 'InputBucketName', { value: props.inputBucket.bucketName });
        new aws_cdk_lib_1.CfnOutput(this, 'ResultsBucketName', { value: props.resultsBucket.bucketName });
    }
    addInputHandler(inputHandler) {
        this.api.addInputHandler(inputHandler);
        this.params.inputBucket.grantRead(new aws_iam_1.ArnPrincipal(inputHandler.evalEngineCallerPrincipalArn));
        this.params.resultsBucket.grantWrite(new aws_iam_1.ArnPrincipal(inputHandler.evalEngineCallerPrincipalArn));
        inputHandler.controlBrokerParams = this.params;
        return this.getUrlForInputHandler(inputHandler);
    }
    getUrlForInputHandler(inputHandler) {
        return this.api.getUrlForInputHandler(inputHandler);
    }
    set evalEngine(evalEngine) {
        this.api.evalEngine = evalEngine;
    }
}
exports.ControlBroker = ControlBroker;
_a = JSII_RTTI_SYMBOL_1;
ControlBroker[_a] = { fqn: "control-broker.ControlBroker", version: "0.12.1" };
//# sourceMappingURL=data:application/json;base64,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