import { Construct } from 'constructs';
import { Api } from '../api';
import { BaseApiBinding } from '../api-bindings';
import { ControlBrokerParams } from '../control-broker';
import { IIntegrationTarget, IntegrationTargetType } from '../interfaces';
export interface BaseInputHandlerProps {
    readonly binding: BaseApiBinding<any>;
}
export declare abstract class BaseInputHandler extends Construct implements IIntegrationTarget {
    abstract readonly integrationTargetType: IntegrationTargetType;
    readonly binding: BaseApiBinding<any>;
    constructor(scope: Construct, id: string, props: BaseInputHandlerProps);
    /**
     * Return a name for this input handler that is safe for use in the
     * path of a URL.
     */
    abstract get urlSafeName(): string;
    /**
     * ARN of the principal that will call the EvalEngine endpoint.
     */
    abstract get evalEngineCallerPrincipalArn(): string;
    abstract bindToApi(api: Api): void;
    get url(): string | undefined;
    abstract set controlBrokerParams(params: ControlBrokerParams);
}
