import { Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { BaseInputHandler, BaseInputHandlerProps } from '.';
import { Api } from '../api';
import { ControlBrokerParams } from '../control-broker';
import { ILambdaIntegrationTarget, IntegrationTargetType } from '../interfaces';
export declare class CloudFormationInputHandler extends BaseInputHandler implements ILambdaIntegrationTarget {
    readonly integrationTargetType: IntegrationTargetType;
    readonly handler: Function;
    constructor(scope: Construct, id: string, props: BaseInputHandlerProps);
    get evalEngineCallerPrincipalArn(): string;
    get urlSafeName(): string;
    bindToApi(api: Api): void;
    set controlBrokerParams(params: ControlBrokerParams);
}
