"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationInputHandler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const _1 = require(".");
const interfaces_1 = require("../interfaces");
class CloudFormationInputHandler extends _1.BaseInputHandler {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.integrationTargetType = interfaces_1.IntegrationTargetType.LAMBDA;
        this.handler = new aws_lambda_python_alpha_1.PythonFunction(this, `${id}CloudFormationInputHandler`, {
            entry: path_1.join(__dirname, 'lambda-function-code/cloudformation-input-handler'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            index: 'lambda_function.py',
            handler: 'lambda_handler',
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            environment: {},
        });
        new aws_cdk_lib_1.CfnOutput(this, `${this.urlSafeName}InputHandlerLogGroup`, {
            value: this.handler.logGroup.logGroupName,
        });
    }
    get evalEngineCallerPrincipalArn() {
        if (this.handler.role === undefined) {
            throw new Error('No role configured for input handler... handler');
        }
        return this.handler.role.roleArn;
    }
    get urlSafeName() {
        return 'CloudFormation';
    }
    bindToApi(api) {
        this.binding.bindTargetToApi(api, this);
    }
    set controlBrokerParams(params) {
        this.handler.addEnvironment('CloudFormationRawInputsBucket', params.inputBucket.bucketName);
        this.handler.addEnvironment('RawPaCResultsBucket', params.resultsBucket.bucketName);
    }
}
exports.CloudFormationInputHandler = CloudFormationInputHandler;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationInputHandler[_a] = { fqn: "control-broker.CloudFormationInputHandler", version: "0.12.1" };
//# sourceMappingURL=data:application/json;base64,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