# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorityIamMemberArgs', 'AuthorityIamMember']

@pulumi.input_type
class AuthorityIamMemberArgs:
    def __init__(__self__, *,
                 certificate_authority: pulumi.Input[str],
                 member: pulumi.Input[str],
                 role: pulumi.Input[str],
                 condition: Optional[pulumi.Input['AuthorityIamMemberConditionArgs']] = None):
        """
        The set of arguments for constructing a AuthorityIamMember resource.
        :param pulumi.Input[str] role: The role that should be applied. Only one
               `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "role", role)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Input[str]:
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter
    def member(self) -> pulumi.Input[str]:
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: pulumi.Input[str]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The role that should be applied. Only one
        `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AuthorityIamMemberConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AuthorityIamMemberConditionArgs']]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class _AuthorityIamMemberState:
    def __init__(__self__, *,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input['AuthorityIamMemberConditionArgs']] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 member: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthorityIamMember resources.
        :param pulumi.Input[str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[str] role: The role that should be applied. Only one
               `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if member is not None:
            pulumi.set(__self__, "member", member)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AuthorityIamMemberConditionArgs']]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AuthorityIamMemberConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def member(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "member")

    @member.setter
    def member(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role that should be applied. Only one
        `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


class AuthorityIamMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['AuthorityIamMemberConditionArgs']]] = None,
                 member: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Three different resources help you manage your IAM policy for Certificate Authority Service CertificateAuthority. Each of these resources serves a different use case:

        * `certificateauthority.AuthorityIamPolicy`: Authoritative. Sets the IAM policy for the certificateauthority and replaces any existing policy already attached.
        * `certificateauthority.AuthorityIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the certificateauthority are preserved.
        * `certificateauthority.AuthorityIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the certificateauthority are preserved.

        > **Note:** `certificateauthority.AuthorityIamPolicy` **cannot** be used in conjunction with `certificateauthority.AuthorityIamBinding` and `certificateauthority.AuthorityIamMember` or they will fight over what your policy should be.

        > **Note:** `certificateauthority.AuthorityIamBinding` resources **can be** used in conjunction with `certificateauthority.AuthorityIamMember` resources **only if** they do not grant privilege to the same role.
        ## google\_privateca\_certificate\_authority\_iam\_policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/privateca.certificateManager",
            members=["user:jane@example.com"],
        )])
        policy = gcp.certificateauthority.AuthorityIamPolicy("policy",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            policy_data=admin.policy_data)
        ```

        ## google\_privateca\_certificate\_authority\_iam\_binding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.certificateauthority.AuthorityIamBinding("binding",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            role="roles/privateca.certificateManager",
            members=["user:jane@example.com"])
        ```

        ## google\_privateca\_certificate\_authority\_iam\_member

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.certificateauthority.AuthorityIamMember("member",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            role="roles/privateca.certificateManager",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms* projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} * {{project}}/{{location}}/{{certificate_authority_id}} * {{location}}/{{certificate_authority_id}} Any variables not passed in the import command will be taken from the provider configuration. Certificate Authority Service certificateauthority IAM resources can be imported using the resource identifiers, role, and member. IAM member imports use space-delimited identifiersthe resource in question, the role, and the member identity, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor "projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} roles/privateca.certificateManager user:jane@example.com"
        ```

         IAM binding imports use space-delimited identifiersthe resource in question and the role, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor "projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} roles/privateca.certificateManager"
        ```

         IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}}
        ```

         -> **Custom Roles**If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: The role that should be applied. Only one
               `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorityIamMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage your IAM policy for Certificate Authority Service CertificateAuthority. Each of these resources serves a different use case:

        * `certificateauthority.AuthorityIamPolicy`: Authoritative. Sets the IAM policy for the certificateauthority and replaces any existing policy already attached.
        * `certificateauthority.AuthorityIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the certificateauthority are preserved.
        * `certificateauthority.AuthorityIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role for the certificateauthority are preserved.

        > **Note:** `certificateauthority.AuthorityIamPolicy` **cannot** be used in conjunction with `certificateauthority.AuthorityIamBinding` and `certificateauthority.AuthorityIamMember` or they will fight over what your policy should be.

        > **Note:** `certificateauthority.AuthorityIamBinding` resources **can be** used in conjunction with `certificateauthority.AuthorityIamMember` resources **only if** they do not grant privilege to the same role.
        ## google\_privateca\_certificate\_authority\_iam\_policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/privateca.certificateManager",
            members=["user:jane@example.com"],
        )])
        policy = gcp.certificateauthority.AuthorityIamPolicy("policy",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            policy_data=admin.policy_data)
        ```

        ## google\_privateca\_certificate\_authority\_iam\_binding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        binding = gcp.certificateauthority.AuthorityIamBinding("binding",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            role="roles/privateca.certificateManager",
            members=["user:jane@example.com"])
        ```

        ## google\_privateca\_certificate\_authority\_iam\_member

        ```python
        import pulumi
        import pulumi_gcp as gcp

        member = gcp.certificateauthority.AuthorityIamMember("member",
            certificate_authority=google_privateca_certificate_authority["default"]["id"],
            role="roles/privateca.certificateManager",
            member="user:jane@example.com")
        ```

        ## Import

        For all import syntaxes, the "resource in question" can take any of the following forms* projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} * {{project}}/{{location}}/{{certificate_authority_id}} * {{location}}/{{certificate_authority_id}} Any variables not passed in the import command will be taken from the provider configuration. Certificate Authority Service certificateauthority IAM resources can be imported using the resource identifiers, role, and member. IAM member imports use space-delimited identifiersthe resource in question, the role, and the member identity, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor "projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} roles/privateca.certificateManager user:jane@example.com"
        ```

         IAM binding imports use space-delimited identifiersthe resource in question and the role, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor "projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}} roles/privateca.certificateManager"
        ```

         IAM policy imports use the identifier of the resource in question, e.g.

        ```sh
         $ pulumi import gcp:certificateauthority/authorityIamMember:AuthorityIamMember editor projects/{{project}}/locations/{{location}}/certificateAuthorities/{{certificate_authority_id}}
        ```

         -> **Custom Roles**If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `[projects/my-project|organizations/my-org]/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param AuthorityIamMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorityIamMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['AuthorityIamMemberConditionArgs']]] = None,
                 member: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorityIamMemberArgs.__new__(AuthorityIamMemberArgs)

            if certificate_authority is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority'")
            __props__.__dict__["certificate_authority"] = certificate_authority
            __props__.__dict__["condition"] = condition
            if member is None and not opts.urn:
                raise TypeError("Missing required property 'member'")
            __props__.__dict__["member"] = member
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["etag"] = None
        super(AuthorityIamMember, __self__).__init__(
            'gcp:certificateauthority/authorityIamMember:AuthorityIamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority: Optional[pulumi.Input[str]] = None,
            condition: Optional[pulumi.Input[pulumi.InputType['AuthorityIamMemberConditionArgs']]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            member: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None) -> 'AuthorityIamMember':
        """
        Get an existing AuthorityIamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] etag: (Computed) The etag of the IAM policy.
        :param pulumi.Input[str] role: The role that should be applied. Only one
               `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
               `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorityIamMemberState.__new__(_AuthorityIamMemberState)

        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["condition"] = condition
        __props__.__dict__["etag"] = etag
        __props__.__dict__["member"] = member
        __props__.__dict__["role"] = role
        return AuthorityIamMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[str]:
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.AuthorityIamMemberCondition']]:
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[str]:
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role that should be applied. Only one
        `certificateauthority.AuthorityIamBinding` can be used per role. Note that custom roles must be of the format
        `[projects|organizations]/{parent-name}/roles/{role-name}`.
        """
        return pulumi.get(self, "role")

