# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AuthorityAccessUrl',
    'AuthorityConfig',
    'AuthorityConfigReusableConfig',
    'AuthorityConfigSubjectConfig',
    'AuthorityConfigSubjectConfigSubject',
    'AuthorityConfigSubjectConfigSubjectAltName',
    'AuthorityIamBindingCondition',
    'AuthorityIamMemberCondition',
    'AuthorityIssuingOptions',
    'AuthorityKeySpec',
    'CertificateCertificateDescription',
    'CertificateCertificateDescriptionAuthorityKeyId',
    'CertificateCertificateDescriptionCertFingerprint',
    'CertificateCertificateDescriptionConfigValues',
    'CertificateCertificateDescriptionConfigValuesKeyUsage',
    'CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage',
    'CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions',
    'CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage',
    'CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage',
    'CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId',
    'CertificateCertificateDescriptionPublicKey',
    'CertificateCertificateDescriptionSubjectDescription',
    'CertificateCertificateDescriptionSubjectDescriptionSubject',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltName',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId',
    'CertificateCertificateDescriptionSubjectKeyId',
    'CertificateConfig',
    'CertificateConfigPublicKey',
    'CertificateConfigReusableConfig',
    'CertificateConfigSubjectConfig',
    'CertificateConfigSubjectConfigSubject',
    'CertificateConfigSubjectConfigSubjectAltName',
    'CertificateRevocationDetail',
]

@pulumi.output_type
class AuthorityAccessUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificateAccessUrl":
            suggest = "ca_certificate_access_url"
        elif key == "crlAccessUrl":
            suggest = "crl_access_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityAccessUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityAccessUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityAccessUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate_access_url: Optional[str] = None,
                 crl_access_url: Optional[str] = None):
        if ca_certificate_access_url is not None:
            pulumi.set(__self__, "ca_certificate_access_url", ca_certificate_access_url)
        if crl_access_url is not None:
            pulumi.set(__self__, "crl_access_url", crl_access_url)

    @property
    @pulumi.getter(name="caCertificateAccessUrl")
    def ca_certificate_access_url(self) -> Optional[str]:
        return pulumi.get(self, "ca_certificate_access_url")

    @property
    @pulumi.getter(name="crlAccessUrl")
    def crl_access_url(self) -> Optional[str]:
        return pulumi.get(self, "crl_access_url")


@pulumi.output_type
class AuthorityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reusableConfig":
            suggest = "reusable_config"
        elif key == "subjectConfig":
            suggest = "subject_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reusable_config: 'outputs.AuthorityConfigReusableConfig',
                 subject_config: 'outputs.AuthorityConfigSubjectConfig'):
        """
        :param 'AuthorityConfigReusableConfigArgs' reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
               . Alternatively, one of the short names
               found by running `gcloud beta privateca reusable-configs list`.
        :param 'AuthorityConfigSubjectConfigArgs' subject_config: Specifies some of the values in a certificate that are related to the subject.
               Structure is documented below.
        """
        pulumi.set(__self__, "reusable_config", reusable_config)
        pulumi.set(__self__, "subject_config", subject_config)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> 'outputs.AuthorityConfigReusableConfig':
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        . Alternatively, one of the short names
        found by running `gcloud beta privateca reusable-configs list`.
        """
        return pulumi.get(self, "reusable_config")

    @property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.AuthorityConfigSubjectConfig':
        """
        Specifies some of the values in a certificate that are related to the subject.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_config")


@pulumi.output_type
class AuthorityConfigReusableConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reusableConfig":
            suggest = "reusable_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigReusableConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigReusableConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigReusableConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reusable_config: str):
        """
        :param str reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
               . Alternatively, one of the short names
               found by running `gcloud beta privateca reusable-configs list`.
        """
        pulumi.set(__self__, "reusable_config", reusable_config)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> str:
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        . Alternatively, one of the short names
        found by running `gcloud beta privateca reusable-configs list`.
        """
        return pulumi.get(self, "reusable_config")


@pulumi.output_type
class AuthorityConfigSubjectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: str,
                 subject: 'outputs.AuthorityConfigSubjectConfigSubject',
                 subject_alt_name: Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName'] = None):
        """
        :param str common_name: The common name of the distinguished name.
        :param 'AuthorityConfigSubjectConfigSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'AuthorityConfigSubjectConfigSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def subject(self) -> 'outputs.AuthorityConfigSubjectConfigSubject':
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class AuthorityConfigSubjectConfigSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfigSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfigSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfigSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization: str,
                 country_code: Optional[str] = None,
                 locality: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 postal_code: Optional[str] = None,
                 province: Optional[str] = None,
                 street_address: Optional[str] = None):
        """
        :param str organization: The organization of the subject.
        :param str country_code: The country code of the subject.
        :param str locality: The locality or city of the subject.
        :param str organizational_unit: The organizational unit of the subject.
        :param str postal_code: The postal code of the subject.
        :param str province: The province, territory, or regional state of the subject.
        :param str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "organization", organization)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class AuthorityConfigSubjectConfigSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfigSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[str]] = None,
                 email_addresses: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 uris: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[str] uris: Contains only valid RFC 3986 URIs.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class AuthorityIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AuthorityIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AuthorityIssuingOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeCaCertUrl":
            suggest = "include_ca_cert_url"
        elif key == "includeCrlAccessUrl":
            suggest = "include_crl_access_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityIssuingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityIssuingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityIssuingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_ca_cert_url: Optional[bool] = None,
                 include_crl_access_url: Optional[bool] = None):
        """
        :param bool include_ca_cert_url: When true, includes a URL to the issuing CA certificate in the "authority
               information access" X.509 extension.
        :param bool include_crl_access_url: When true, includes a URL to the CRL corresponding to certificates issued from a
               CertificateAuthority. CRLs will expire 7 days from their creation. However, we will
               rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        if include_ca_cert_url is not None:
            pulumi.set(__self__, "include_ca_cert_url", include_ca_cert_url)
        if include_crl_access_url is not None:
            pulumi.set(__self__, "include_crl_access_url", include_crl_access_url)

    @property
    @pulumi.getter(name="includeCaCertUrl")
    def include_ca_cert_url(self) -> Optional[bool]:
        """
        When true, includes a URL to the issuing CA certificate in the "authority
        information access" X.509 extension.
        """
        return pulumi.get(self, "include_ca_cert_url")

    @property
    @pulumi.getter(name="includeCrlAccessUrl")
    def include_crl_access_url(self) -> Optional[bool]:
        """
        When true, includes a URL to the CRL corresponding to certificates issued from a
        CertificateAuthority. CRLs will expire 7 days from their creation. However, we will
        rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        return pulumi.get(self, "include_crl_access_url")


@pulumi.output_type
class AuthorityKeySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudKmsKeyVersion":
            suggest = "cloud_kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityKeySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityKeySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityKeySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[str] = None,
                 cloud_kms_key_version: Optional[str] = None):
        """
        :param str algorithm: The algorithm to use for creating a managed Cloud KMS key for a for a simplified
               experience. All managed keys will be have their ProtectionLevel as HSM.
               Possible values are `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, and `EC_P384_SHA384`.
        :param str cloud_kms_key_version: The resource name for an existing Cloud KMS CryptoKeyVersion in the format
               `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if cloud_kms_key_version is not None:
            pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[str]:
        """
        The algorithm to use for creating a managed Cloud KMS key for a for a simplified
        experience. All managed keys will be have their ProtectionLevel as HSM.
        Possible values are `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, and `EC_P384_SHA384`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> Optional[str]:
        """
        The resource name for an existing Cloud KMS CryptoKeyVersion in the format
        `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        return pulumi.get(self, "cloud_kms_key_version")


@pulumi.output_type
class CertificateCertificateDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"
        elif key == "aiaIssuingCertificateUrls":
            suggest = "aia_issuing_certificate_urls"
        elif key == "authorityKeyId":
            suggest = "authority_key_id"
        elif key == "certFingerprint":
            suggest = "cert_fingerprint"
        elif key == "configValues":
            suggest = "config_values"
        elif key == "crlDistributionPoints":
            suggest = "crl_distribution_points"
        elif key == "subjectDescription":
            suggest = "subject_description"
        elif key == "subjectKeyId":
            suggest = "subject_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: 'outputs.CertificateCertificateDescriptionPublicKey',
                 aia_issuing_certificate_urls: Optional[Sequence[str]] = None,
                 authority_key_id: Optional['outputs.CertificateCertificateDescriptionAuthorityKeyId'] = None,
                 cert_fingerprint: Optional['outputs.CertificateCertificateDescriptionCertFingerprint'] = None,
                 config_values: Optional['outputs.CertificateCertificateDescriptionConfigValues'] = None,
                 crl_distribution_points: Optional[Sequence[str]] = None,
                 subject_description: Optional['outputs.CertificateCertificateDescriptionSubjectDescription'] = None,
                 subject_key_id: Optional['outputs.CertificateCertificateDescriptionSubjectKeyId'] = None):
        """
        :param 'CertificateCertificateDescriptionPublicKeyArgs' public_key: A PublicKey describes a public key.
               Structure is documented below.
        """
        pulumi.set(__self__, "public_key", public_key)
        if aia_issuing_certificate_urls is not None:
            pulumi.set(__self__, "aia_issuing_certificate_urls", aia_issuing_certificate_urls)
        if authority_key_id is not None:
            pulumi.set(__self__, "authority_key_id", authority_key_id)
        if cert_fingerprint is not None:
            pulumi.set(__self__, "cert_fingerprint", cert_fingerprint)
        if config_values is not None:
            pulumi.set(__self__, "config_values", config_values)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if subject_description is not None:
            pulumi.set(__self__, "subject_description", subject_description)
        if subject_key_id is not None:
            pulumi.set(__self__, "subject_key_id", subject_key_id)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.CertificateCertificateDescriptionPublicKey':
        """
        A PublicKey describes a public key.
        Structure is documented below.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="aiaIssuingCertificateUrls")
    def aia_issuing_certificate_urls(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "aia_issuing_certificate_urls")

    @property
    @pulumi.getter(name="authorityKeyId")
    def authority_key_id(self) -> Optional['outputs.CertificateCertificateDescriptionAuthorityKeyId']:
        return pulumi.get(self, "authority_key_id")

    @property
    @pulumi.getter(name="certFingerprint")
    def cert_fingerprint(self) -> Optional['outputs.CertificateCertificateDescriptionCertFingerprint']:
        return pulumi.get(self, "cert_fingerprint")

    @property
    @pulumi.getter(name="configValues")
    def config_values(self) -> Optional['outputs.CertificateCertificateDescriptionConfigValues']:
        return pulumi.get(self, "config_values")

    @property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "crl_distribution_points")

    @property
    @pulumi.getter(name="subjectDescription")
    def subject_description(self) -> Optional['outputs.CertificateCertificateDescriptionSubjectDescription']:
        return pulumi.get(self, "subject_description")

    @property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> Optional['outputs.CertificateCertificateDescriptionSubjectKeyId']:
        return pulumi.get(self, "subject_key_id")


@pulumi.output_type
class CertificateCertificateDescriptionAuthorityKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionAuthorityKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionAuthorityKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionAuthorityKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[str] = None):
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        return pulumi.get(self, "key_id")


@pulumi.output_type
class CertificateCertificateDescriptionCertFingerprint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Hash":
            suggest = "sha256_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionCertFingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionCertFingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionCertFingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_hash: Optional[str] = None):
        if sha256_hash is not None:
            pulumi.set(__self__, "sha256_hash", sha256_hash)

    @property
    @pulumi.getter(name="sha256Hash")
    def sha256_hash(self) -> Optional[str]:
        return pulumi.get(self, "sha256_hash")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsage":
            suggest = "key_usage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usage: Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsage'] = None):
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsage']:
        return pulumi.get(self, "key_usage")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"
        elif key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unknown_extended_key_usages: Sequence['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage'],
                 base_key_usage: Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage'] = None,
                 extended_key_usage: Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage'] = None):
        pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)
        if base_key_usage is not None:
            pulumi.set(__self__, "base_key_usage", base_key_usage)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)

    @property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Sequence['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage']:
        return pulumi.get(self, "unknown_extended_key_usages")

    @property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage']:
        return pulumi.get(self, "base_key_usage")

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage']:
        return pulumi.get(self, "extended_key_usage")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsageOptions":
            suggest = "key_usage_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usage_options: Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions'] = None):
        if key_usage_options is not None:
            pulumi.set(__self__, "key_usage_options", key_usage_options)

    @property
    @pulumi.getter(name="keyUsageOptions")
    def key_usage_options(self) -> Optional['outputs.CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions']:
        return pulumi.get(self, "key_usage_options")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[bool] = None,
                 content_commitment: Optional[bool] = None,
                 crl_sign: Optional[bool] = None,
                 data_encipherment: Optional[bool] = None,
                 decipher_only: Optional[bool] = None,
                 digital_signature: Optional[bool] = None,
                 encipher_only: Optional[bool] = None,
                 key_agreement: Optional[bool] = None,
                 key_encipherment: Optional[bool] = None):
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[bool]:
        return pulumi.get(self, "cert_sign")

    @property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[bool]:
        return pulumi.get(self, "content_commitment")

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[bool]:
        return pulumi.get(self, "crl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[bool]:
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[bool]:
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[bool] = None,
                 code_signing: Optional[bool] = None,
                 email_protection: Optional[bool] = None,
                 ocsp_signing: Optional[bool] = None,
                 server_auth: Optional[bool] = None,
                 time_stamping: Optional[bool] = None):
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[bool]:
        return pulumi.get(self, "client_auth")

    @property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[bool]:
        return pulumi.get(self, "code_signing")

    @property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[bool]:
        return pulumi.get(self, "email_protection")

    @property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[bool]:
        return pulumi.get(self, "ocsp_signing")

    @property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[bool]:
        return pulumi.get(self, "server_auth")

    @property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[bool]:
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obectId":
            suggest = "obect_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 obect_id: 'outputs.CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId'):
        pulumi.set(__self__, "obect_id", obect_id)

    @property
    @pulumi.getter(name="obectId")
    def obect_id(self) -> 'outputs.CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId':
        return pulumi.get(self, "obect_id")


@pulumi.output_type
class CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsageObectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[int]):
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[int]:
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateCertificateDescriptionPublicKey(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None):
        """
        :param str type: Types of public keys that are supported. At a minimum, we support RSA and ECDSA, for the key sizes or curves listed: https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
               Possible values are `KEY_TYPE_UNSPECIFIED`, `PEM_RSA_KEY`, and `PEM_EC_KEY`.
        :param str key: Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Types of public keys that are supported. At a minimum, we support RSA and ECDSA, for the key sizes or curves listed: https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
        Possible values are `KEY_TYPE_UNSPECIFIED`, `PEM_RSA_KEY`, and `PEM_EC_KEY`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "hexSerialNumber":
            suggest = "hex_serial_number"
        elif key == "notAfterTime":
            suggest = "not_after_time"
        elif key == "notBeforeTime":
            suggest = "not_before_time"
        elif key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 hex_serial_number: Optional[str] = None,
                 lifetime: Optional[str] = None,
                 not_after_time: Optional[str] = None,
                 not_before_time: Optional[str] = None,
                 subject: Optional['outputs.CertificateCertificateDescriptionSubjectDescriptionSubject'] = None,
                 subject_alt_name: Optional['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltName'] = None):
        """
        :param str common_name: The common name of the distinguished name.
        :param str lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param 'CertificateCertificateDescriptionSubjectDescriptionSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if hex_serial_number is not None:
            pulumi.set(__self__, "hex_serial_number", hex_serial_number)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if not_after_time is not None:
            pulumi.set(__self__, "not_after_time", not_after_time)
        if not_before_time is not None:
            pulumi.set(__self__, "not_before_time", not_before_time)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="hexSerialNumber")
    def hex_serial_number(self) -> Optional[str]:
        return pulumi.get(self, "hex_serial_number")

    @property
    @pulumi.getter
    def lifetime(self) -> Optional[str]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter(name="notAfterTime")
    def not_after_time(self) -> Optional[str]:
        return pulumi.get(self, "not_after_time")

    @property
    @pulumi.getter(name="notBeforeTime")
    def not_before_time(self) -> Optional[str]:
        return pulumi.get(self, "not_before_time")

    @property
    @pulumi.getter
    def subject(self) -> Optional['outputs.CertificateCertificateDescriptionSubjectDescriptionSubject']:
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_code: Optional[str] = None,
                 locality: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 postal_code: Optional[str] = None,
                 province: Optional[str] = None,
                 street_address: Optional[str] = None):
        """
        :param str country_code: The country code of the subject.
        :param str locality: The locality or city of the subject.
        :param str organization: The organization of the subject.
        :param str organizational_unit: The organizational unit of the subject.
        :param str postal_code: The postal code of the subject.
        :param str province: The province, territory, or regional state of the subject.
        :param str street_address: The street address of the subject.
        """
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customSans":
            suggest = "custom_sans"
        elif key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_sans: Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan'],
                 dns_names: Optional[Sequence[str]] = None,
                 email_addresses: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 uris: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[str] uris: Contains only valid RFC 3986 URIs.
        """
        pulumi.set(__self__, "custom_sans", custom_sans)
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan']:
        return pulumi.get(self, "custom_sans")

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obectId":
            suggest = "obect_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: bool,
                 obect_id: 'outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId',
                 value: Optional[str] = None):
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "obect_id", obect_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def critical(self) -> bool:
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter(name="obectId")
    def obect_id(self) -> 'outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId':
        return pulumi.get(self, "obect_id")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[int]):
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[int]:
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[str] = None):
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        return pulumi.get(self, "key_id")


@pulumi.output_type
class CertificateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"
        elif key == "reusableConfig":
            suggest = "reusable_config"
        elif key == "subjectConfig":
            suggest = "subject_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: 'outputs.CertificateConfigPublicKey',
                 reusable_config: 'outputs.CertificateConfigReusableConfig',
                 subject_config: 'outputs.CertificateConfigSubjectConfig'):
        """
        :param 'CertificateConfigPublicKeyArgs' public_key: A PublicKey describes a public key.
               Structure is documented below.
        :param 'CertificateConfigReusableConfigArgs' reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
        :param 'CertificateConfigSubjectConfigArgs' subject_config: Specifies some of the values in a certificate that are related to the subject.
               Structure is documented below.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "reusable_config", reusable_config)
        pulumi.set(__self__, "subject_config", subject_config)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.CertificateConfigPublicKey':
        """
        A PublicKey describes a public key.
        Structure is documented below.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> 'outputs.CertificateConfigReusableConfig':
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        """
        return pulumi.get(self, "reusable_config")

    @property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.CertificateConfigSubjectConfig':
        """
        Specifies some of the values in a certificate that are related to the subject.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_config")


@pulumi.output_type
class CertificateConfigPublicKey(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None):
        """
        :param str type: Types of public keys that are supported. At a minimum, we support RSA and ECDSA, for the key sizes or curves listed: https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
               Possible values are `KEY_TYPE_UNSPECIFIED`, `PEM_RSA_KEY`, and `PEM_EC_KEY`.
        :param str key: Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Types of public keys that are supported. At a minimum, we support RSA and ECDSA, for the key sizes or curves listed: https://cloud.google.com/kms/docs/algorithms#asymmetric_signing_algorithms
        Possible values are `KEY_TYPE_UNSPECIFIED`, `PEM_RSA_KEY`, and `PEM_EC_KEY`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificateConfigReusableConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reusableConfig":
            suggest = "reusable_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigReusableConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigReusableConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigReusableConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reusable_config: str):
        """
        :param str reusable_config: A resource path to a ReusableConfig in the format
               `projects/*/locations/*/reusableConfigs/*`.
        """
        pulumi.set(__self__, "reusable_config", reusable_config)

    @property
    @pulumi.getter(name="reusableConfig")
    def reusable_config(self) -> str:
        """
        A resource path to a ReusableConfig in the format
        `projects/*/locations/*/reusableConfigs/*`.
        """
        return pulumi.get(self, "reusable_config")


@pulumi.output_type
class CertificateConfigSubjectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: str,
                 subject: 'outputs.CertificateConfigSubjectConfigSubject',
                 subject_alt_name: Optional['outputs.CertificateConfigSubjectConfigSubjectAltName'] = None):
        """
        :param str common_name: The common name of the distinguished name.
        :param 'CertificateConfigSubjectConfigSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'CertificateConfigSubjectConfigSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def subject(self) -> 'outputs.CertificateConfigSubjectConfigSubject':
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.CertificateConfigSubjectConfigSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class CertificateConfigSubjectConfigSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfigSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfigSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfigSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization: str,
                 country_code: Optional[str] = None,
                 locality: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 postal_code: Optional[str] = None,
                 province: Optional[str] = None,
                 street_address: Optional[str] = None):
        """
        :param str organization: The organization of the subject.
        :param str country_code: The country code of the subject.
        :param str locality: The locality or city of the subject.
        :param str organizational_unit: The organizational unit of the subject.
        :param str postal_code: The postal code of the subject.
        :param str province: The province, territory, or regional state of the subject.
        :param str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "organization", organization)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class CertificateConfigSubjectConfigSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfigSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[str]] = None,
                 email_addresses: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 uris: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[str] uris: Contains only valid RFC 3986 URIs.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class CertificateRevocationDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revocationState":
            suggest = "revocation_state"
        elif key == "revocationTime":
            suggest = "revocation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateRevocationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateRevocationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateRevocationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revocation_state: Optional[str] = None,
                 revocation_time: Optional[str] = None):
        if revocation_state is not None:
            pulumi.set(__self__, "revocation_state", revocation_state)
        if revocation_time is not None:
            pulumi.set(__self__, "revocation_time", revocation_time)

    @property
    @pulumi.getter(name="revocationState")
    def revocation_state(self) -> Optional[str]:
        return pulumi.get(self, "revocation_state")

    @property
    @pulumi.getter(name="revocationTime")
    def revocation_time(self) -> Optional[str]:
        return pulumi.get(self, "revocation_time")


