import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cleanrooms extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to view details for schemas
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetSchema.html
     */
    toBatchGetSchema(): this;
    /**
     * Grants permission to create a new collaboration, a shared data collaboration environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html
     */
    toCreateCollaboration(): this;
    /**
     * Grants permission to create a new configured table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:BatchGetPartition
     * - glue:GetDatabase
     * - glue:GetDatabases
     * - glue:GetPartition
     * - glue:GetPartitions
     * - glue:GetSchemaVersion
     * - glue:GetTable
     * - glue:GetTables
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTable.html
     */
    toCreateConfiguredTable(): this;
    /**
     * Grants permission to create a analysis rule for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAnalysisRule.html
     */
    toCreateConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to link a configured table with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAssociation.html
     */
    toCreateConfiguredTableAssociation(): this;
    /**
     * Grants permission to join collaborations by creating a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateMembership.html
     */
    toCreateMembership(): this;
    /**
     * Grants permission to delete an existing collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteCollaboration.html
     */
    toDeleteCollaboration(): this;
    /**
     * Grants permission to delete a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTable.html
     */
    toDeleteConfiguredTable(): this;
    /**
     * Grants permission to delete an existing analysis rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAnalysisRule.html
     */
    toDeleteConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to remove a configured table association from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAssociation.html
     */
    toDeleteConfiguredTableAssociation(): this;
    /**
     * Grants permission to delete members from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMember.html
     */
    toDeleteMember(): this;
    /**
     * Grants permission to leave collaborations by deleting a membership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMembership.html
     */
    toDeleteMembership(): this;
    /**
     * Grants permission to view details for a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaboration.html
     */
    toGetCollaboration(): this;
    /**
     * Grants permission to view details for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTable.html
     */
    toGetConfiguredTable(): this;
    /**
     * Grants permission to view analysis rules for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAnalysisRule.html
     */
    toGetConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to view details for a configured table association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAssociation.html
     */
    toGetConfiguredTableAssociation(): this;
    /**
     * Grants permission to view details about a membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetMembership.html
     */
    toGetMembership(): this;
    /**
     * Grants permission to view a protected query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetProtectedQuery.html
     */
    toGetProtectedQuery(): this;
    /**
     * Grants permission to view details for a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchema.html
     */
    toGetSchema(): this;
    /**
     * Grants permission to view analysis rules associated with a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchemaAnalysisRule.html
     */
    toGetSchemaAnalysisRule(): this;
    /**
     * Grants permission to list available collaborations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborations.html
     */
    toListCollaborations(): this;
    /**
     * Grants permission to list available configured table associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTableAssociations.html
     */
    toListConfiguredTableAssociations(): this;
    /**
     * Grants permission to list available configured tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTables.html
     */
    toListConfiguredTables(): this;
    /**
     * Grants permission to list the members of a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMembers.html
     */
    toListMembers(): this;
    /**
     * Grants permission to list available memberships
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMemberships.html
     */
    toListMemberships(): this;
    /**
     * Grants permission to list protected queries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListProtectedQueries.html
     */
    toListProtectedQueries(): this;
    /**
     * Grants permission to view available schemas for a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListSchemas.html
     */
    toListSchemas(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start protected queries
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     * - s3:GetBucketLocation
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_StartProtectedQuery.html
     */
    toStartProtectedQuery(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update details of the collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateCollaboration.html
     */
    toUpdateCollaboration(): this;
    /**
     * Grants permission to update an existing configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTable.html
     */
    toUpdateConfiguredTable(): this;
    /**
     * Grants permission to update analysis rules for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAnalysisRule.html
     */
    toUpdateConfiguredTableAnalysisRule(): this;
    /**
     * Grants permission to update a configured table association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAssociation.html
     */
    toUpdateConfiguredTableAssociation(): this;
    /**
     * Grants permission to update details of a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateMembership.html
     */
    toUpdateMembership(): this;
    /**
     * Grants permission to update protected queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateProtectedQuery.html
     */
    toUpdateProtectedQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Collaboration to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param collaborationId - Identifier for the collaborationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCollaboration(collaborationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfiguredTable to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param configuredTableId - Identifier for the configuredTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredTable(configuredTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfiguredTableAssociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param configuredTableAssociationId - Identifier for the configuredTableAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredTableAssociation(membershipId: string, configuredTableAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Membership to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMembership(membershipId: string, account?: string, region?: string, partition?: string): this;
}
