import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Datazone extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to retrieve information about an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProject(): this;
    /**
     * Grants permission to retrieve configuration information for an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProjectConfiguration(): this;
    /**
     * Grants permission to retrieve credentials for an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProjectCredentials(): this;
    /**
     * Grants permission to retrieve all Amazon DataZone projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListProjects(): this;
    /**
     * Grants permission to retrieve all Amazon DataZone projects for a user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListUserProjects(): this;
    protected accessLevelList: AccessLevelList;
}
