"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Datazone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Datazone extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'datazone';
        this.accessLevelList = {
            Read: [
                'GetProject',
                'GetProjectConfiguration',
                'GetProjectCredentials'
            ],
            List: [
                'ListProjects',
                'ListUserProjects'
            ]
        };
    }
    /**
     * Grants permission to retrieve information about an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to retrieve configuration information for an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProjectConfiguration() {
        return this.to('GetProjectConfiguration');
    }
    /**
     * Grants permission to retrieve credentials for an Amazon DataZone project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetProjectCredentials() {
        return this.to('GetProjectCredentials');
    }
    /**
     * Grants permission to retrieve all Amazon DataZone projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to retrieve all Amazon DataZone projects for a user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListUserProjects() {
        return this.to('ListUserProjects');
    }
}
exports.Datazone = Datazone;
_a = JSII_RTTI_SYMBOL_1;
Datazone[_a] = { fqn: "iam-floyd.Datazone", version: "0.501.0" };
//# sourceMappingURL=data:application/json;base64,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