import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [pipes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgepipes.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Pipes extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [pipes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoneventbridgepipes.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a pipe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_CreatePipe.html
     */
    toCreatePipe(): this;
    /**
     * Grants permission to delete a pipe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_DeletePipe.html
     */
    toDeletePipe(): this;
    /**
     * Grants permission to describe a pipe
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_DescribePipe.html
     */
    toDescribePipe(): this;
    /**
     * Grants permission to list all pipes in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_ListPipes.html
     */
    toListPipes(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start a pipe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_StartPipe.html
     */
    toStartPipe(): this;
    /**
     * Grants permission to stop a pipe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_StopPipe.html
     */
    toStopPipe(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a pipe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_UpdatePipe.html
     */
    toUpdatePipe(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type pipe to the statement
     *
     * https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPipe(name: string, account?: string, region?: string, partition?: string): this;
}
