"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Globalaccelerator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [globalaccelerator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglobalaccelerator.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Globalaccelerator extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [globalaccelerator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglobalaccelerator.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'globalaccelerator';
        this.accessLevelList = {
            Write: [
                'AddCustomRoutingEndpoints',
                'AddEndpoints',
                'AdvertiseByoipCidr',
                'AllowCustomRoutingTraffic',
                'CreateAccelerator',
                'CreateCustomRoutingAccelerator',
                'CreateCustomRoutingEndpointGroup',
                'CreateCustomRoutingListener',
                'CreateEndpointGroup',
                'CreateListener',
                'DeleteAccelerator',
                'DeleteCustomRoutingAccelerator',
                'DeleteCustomRoutingEndpointGroup',
                'DeleteCustomRoutingListener',
                'DeleteEndpointGroup',
                'DeleteListener',
                'DenyCustomRoutingTraffic',
                'DeprovisionByoipCidr',
                'ProvisionByoipCidr',
                'RemoveCustomRoutingEndpoints',
                'RemoveEndpoints',
                'UpdateAccelerator',
                'UpdateAcceleratorAttributes',
                'UpdateCustomRoutingAccelerator',
                'UpdateCustomRoutingAcceleratorAttributes',
                'UpdateCustomRoutingListener',
                'UpdateEndpointGroup',
                'UpdateListener',
                'WithdrawByoipCidr'
            ],
            Read: [
                'DescribeAccelerator',
                'DescribeAcceleratorAttributes',
                'DescribeCustomRoutingAccelerator',
                'DescribeCustomRoutingAcceleratorAttributes',
                'DescribeCustomRoutingEndpointGroup',
                'DescribeCustomRoutingListener',
                'DescribeEndpointGroup',
                'DescribeListener',
                'ListTagsForResource'
            ],
            List: [
                'ListAccelerators',
                'ListByoipCidrs',
                'ListCustomRoutingAccelerators',
                'ListCustomRoutingEndpointGroups',
                'ListCustomRoutingListeners',
                'ListCustomRoutingPortMappings',
                'ListCustomRoutingPortMappingsByDestination',
                'ListEndpointGroups',
                'ListListeners'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add a virtual private cloud (VPC) subnet endpoint to a custom routing accelerator endpoint group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AddCustomRoutingEndpoints.html
     */
    toAddCustomRoutingEndpoints() {
        return this.to('AddCustomRoutingEndpoints');
    }
    /**
     * Grants permission to add an endpoint to a standard accelerator endpoint group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AddEndpoints.html
     */
    toAddEndpoints() {
        return this.to('AddEndpoints');
    }
    /**
     * Grants permission to advertises an IPv4 address range that is provisioned for use with your accelerator through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AdvertiseByoipCidr.html
     */
    toAdvertiseByoipCidr() {
        return this.to('AdvertiseByoipCidr');
    }
    /**
     * Grants permission to allows custom routing of user traffic to a private destination IP:PORT in a specific VPC subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html
     */
    toAllowCustomRoutingTraffic() {
        return this.to('AllowCustomRoutingTraffic');
    }
    /**
     * Grants permission to create a standard accelerator
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateAccelerator.html
     */
    toCreateAccelerator() {
        return this.to('CreateAccelerator');
    }
    /**
     * Grants permission to create a Custom Routing accelerator
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingAccelerator.html
     */
    toCreateCustomRoutingAccelerator() {
        return this.to('CreateCustomRoutingAccelerator');
    }
    /**
     * Grants permission to create an endpoint group for the specified listener for a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingEndpointGroup.html
     */
    toCreateCustomRoutingEndpointGroup() {
        return this.to('CreateCustomRoutingEndpointGroup');
    }
    /**
     * Grants permission to create a listener to process inbound connections from clients to a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateCustomRoutingListener.html
     */
    toCreateCustomRoutingListener() {
        return this.to('CreateCustomRoutingListener');
    }
    /**
     * Grants permission to add an endpoint group to a standard accelerator listener
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html
     */
    toCreateEndpointGroup() {
        return this.to('CreateEndpointGroup');
    }
    /**
     * Grants permission to add a listener to a standard accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateListener.html
     */
    toCreateListener() {
        return this.to('CreateListener');
    }
    /**
     * Grants permission to delete a standard accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteAccelerator.html
     */
    toDeleteAccelerator() {
        return this.to('DeleteAccelerator');
    }
    /**
     * Grants permission to delete a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingAccelerator.html
     */
    toDeleteCustomRoutingAccelerator() {
        return this.to('DeleteCustomRoutingAccelerator');
    }
    /**
     * Grants permission to delete an endpoint group from a listener for a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingEndpointGroup.html
     */
    toDeleteCustomRoutingEndpointGroup() {
        return this.to('DeleteCustomRoutingEndpointGroup');
    }
    /**
     * Grants permission to delete a listener for a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteCustomRoutingListener.html
     */
    toDeleteCustomRoutingListener() {
        return this.to('DeleteCustomRoutingListener');
    }
    /**
     * Grants permission to delete an endpoint group associated with a standard accelerator listener
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteEndpointGroup.html
     */
    toDeleteEndpointGroup() {
        return this.to('DeleteEndpointGroup');
    }
    /**
     * Grants permission to delete a listener from a standard accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeleteListener.html
     */
    toDeleteListener() {
        return this.to('DeleteListener');
    }
    /**
     * Grants permission to disallows custom routing of user traffic to a private destination IP:PORT in a specific VPC subnet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DenyCustomRoutingTraffic.html
     */
    toDenyCustomRoutingTraffic() {
        return this.to('DenyCustomRoutingTraffic');
    }
    /**
     * Grants permission to releases the specified address range that you provisioned for use with your accelerator through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DeprovisionByoipCidr.html
     */
    toDeprovisionByoipCidr() {
        return this.to('DeprovisionByoipCidr');
    }
    /**
     * Grants permissions to describe a standard accelerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html
     */
    toDescribeAccelerator() {
        return this.to('DescribeAccelerator');
    }
    /**
     * Grants permission to describe a standard accelerator attributes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAcceleratorAttributes.html
     */
    toDescribeAcceleratorAttributes() {
        return this.to('DescribeAcceleratorAttributes');
    }
    /**
     * Grants permission to describe a custom routing accelerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingAccelerator.html
     */
    toDescribeCustomRoutingAccelerator() {
        return this.to('DescribeCustomRoutingAccelerator');
    }
    /**
     * Grants permission to describe the attributes of a custom routing accelerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingAcceleratorAttributes.html
     */
    toDescribeCustomRoutingAcceleratorAttributes() {
        return this.to('DescribeCustomRoutingAcceleratorAttributes');
    }
    /**
     * Grants permission to describe an endpoint group for a custom routing accelerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingEndpointGroup.html
     */
    toDescribeCustomRoutingEndpointGroup() {
        return this.to('DescribeCustomRoutingEndpointGroup');
    }
    /**
     * Grants permission to describe a listener for a custom routing accelerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeCustomRoutingListener.html
     */
    toDescribeCustomRoutingListener() {
        return this.to('DescribeCustomRoutingListener');
    }
    /**
     * Grants permission to describe a standard accelerator endpoint group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeEndpointGroup.html
     */
    toDescribeEndpointGroup() {
        return this.to('DescribeEndpointGroup');
    }
    /**
     * Grants permission to describe a standard accelerator listener
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeListener.html
     */
    toDescribeListener() {
        return this.to('DescribeListener');
    }
    /**
     * Grants permission to list all standard accelerators
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListAccelerators.html
     */
    toListAccelerators() {
        return this.to('ListAccelerators');
    }
    /**
     * Grants permission to list the BYOIP cidrs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListByoipCidrs.html
     */
    toListByoipCidrs() {
        return this.to('ListByoipCidrs');
    }
    /**
     * Grants permission to list the custom routing accelerators for an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingAccelerators.html
     */
    toListCustomRoutingAccelerators() {
        return this.to('ListCustomRoutingAccelerators');
    }
    /**
     * Grants permission to list the endpoint groups that are associated with a listener for a custom routing accelerator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingEndpointGroups.html
     */
    toListCustomRoutingEndpointGroups() {
        return this.to('ListCustomRoutingEndpointGroups');
    }
    /**
     * Grants permission to list the listeners for a custom routing accelerator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingListeners.html
     */
    toListCustomRoutingListeners() {
        return this.to('ListCustomRoutingListeners');
    }
    /**
     * Grants permission to list the port mappings for a custom routing accelerator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingPortMappings.html
     */
    toListCustomRoutingPortMappings() {
        return this.to('ListCustomRoutingPortMappings');
    }
    /**
     * Grants permission to list the port mappings for a specific endpoint IP address (a destination address) in a subnet
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListCustomRoutingPortMappingsByDestination.html
     */
    toListCustomRoutingPortMappingsByDestination() {
        return this.to('ListCustomRoutingPortMappingsByDestination');
    }
    /**
     * Grants permission to list all endpoint groups associated with a standard accelerator listener
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListEndpointGroups.html
     */
    toListEndpointGroups() {
        return this.to('ListEndpointGroups');
    }
    /**
     * Grants permission to list all listeners associated with a standard accelerator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListListeners.html
     */
    toListListeners() {
        return this.to('ListListeners');
    }
    /**
     * Grants permission to list tags for a globalaccelerator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to provisions an address range for use with your accelerator through bring your own IP addresses (BYOIP)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_ProvisionByoipCidr.html
     */
    toProvisionByoipCidr() {
        return this.to('ProvisionByoipCidr');
    }
    /**
     * Grants permission to remove virtual private cloud (VPC) subnet endpoints from a custom routing accelerator endpoint group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_RemoveCustomRoutingEndpoints.html
     */
    toRemoveCustomRoutingEndpoints() {
        return this.to('RemoveCustomRoutingEndpoints');
    }
    /**
     * Grants permission to remove an endpoint from a standard accelerator endpoint group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_RemoveEndpoints.html
     */
    toRemoveEndpoints() {
        return this.to('RemoveEndpoints');
    }
    /**
     * Grants permission to add tags to a globalaccelerator resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a globalaccelerator resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a standard accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateAccelerator.html
     */
    toUpdateAccelerator() {
        return this.to('UpdateAccelerator');
    }
    /**
     * Grants permission to update a standard accelerator attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateAcceleratorAttributes.html
     */
    toUpdateAcceleratorAttributes() {
        return this.to('UpdateAcceleratorAttributes');
    }
    /**
     * Grants permission to update a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingAccelerator.html
     */
    toUpdateCustomRoutingAccelerator() {
        return this.to('UpdateCustomRoutingAccelerator');
    }
    /**
     * Grants permission to update the attributes for a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingAcceleratorAttributes.html
     */
    toUpdateCustomRoutingAcceleratorAttributes() {
        return this.to('UpdateCustomRoutingAcceleratorAttributes');
    }
    /**
     * Grants permission to update a listener for a custom routing accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateCustomRoutingListener.html
     */
    toUpdateCustomRoutingListener() {
        return this.to('UpdateCustomRoutingListener');
    }
    /**
     * Grants permission to update an endpoint group on a standard accelerator listener
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html
     */
    toUpdateEndpointGroup() {
        return this.to('UpdateEndpointGroup');
    }
    /**
     * Grants permission to update a listener on a standard accelerator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateListener.html
     */
    toUpdateListener() {
        return this.to('UpdateListener');
    }
    /**
     * Grants permission to stops advertising a BYOIP IPv4 address
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_WithdrawByoipCidr.html
     */
    toWithdrawByoipCidr() {
        return this.to('WithdrawByoipCidr');
    }
    /**
     * Adds a resource of type accelerator to the statement
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_Accelerator.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAccelerator(acceleratorId, account, partition) {
        return this.on(`arn:${partition || Globalaccelerator.defaultPartition}:globalaccelerator::${account || '*'}:accelerator/${acceleratorId}`);
    }
    /**
     * Adds a resource of type listener to the statement
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_Listener.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onListener(acceleratorId, listenerId, account, partition) {
        return this.on(`arn:${partition || Globalaccelerator.defaultPartition}:globalaccelerator::${account || '*'}:accelerator/${acceleratorId}/listener/${listenerId}`);
    }
    /**
     * Adds a resource of type endpointgroup to the statement
     *
     * https://docs.aws.amazon.com/global-accelerator/latest/api/API_EndpointGroup.html
     *
     * @param acceleratorId - Identifier for the acceleratorId.
     * @param listenerId - Identifier for the listenerId.
     * @param endpointGroupId - Identifier for the endpointGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEndpointgroup(acceleratorId, listenerId, endpointGroupId, account, partition) {
        return this.on(`arn:${partition || Globalaccelerator.defaultPartition}:globalaccelerator::${account || '*'}:accelerator/${acceleratorId}/listener/${listenerId}/endpoint-group/${endpointGroupId}`);
    }
}
exports.Globalaccelerator = Globalaccelerator;
_a = JSII_RTTI_SYMBOL_1;
Globalaccelerator[_a] = { fqn: "iam-floyd.Globalaccelerator", version: "0.501.0" };
//# sourceMappingURL=data:application/json;base64,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