"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplace extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'AcceptAgreementApprovalRequest',
                'AcceptAgreementRequest',
                'CancelAgreement',
                'CancelAgreementRequest',
                'CreateAgreementRequest',
                'RejectAgreementApprovalRequest',
                'Subscribe',
                'Unsubscribe',
                'UpdateAgreementApprovalRequest'
            ],
            Read: [
                'DescribeAgreement',
                'GetAgreementApprovalRequest',
                'GetAgreementRequest',
                'ListEntitlementDetails'
            ],
            List: [
                'GetAgreementTerms',
                'ListAgreementApprovalRequests',
                'ListAgreementRequests',
                'SearchAgreements',
                'ViewSubscriptions'
            ]
        };
    }
    /**
     * Grants permission to users to approve an incoming subscription request (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toAcceptAgreementApprovalRequest() {
        return this.to('AcceptAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to accept their agreement requests. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toAcceptAgreementRequest() {
        return this.to('AcceptAgreementRequest');
    }
    /**
     * Grants permission to users to cancel their agreements. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCancelAgreement() {
        return this.to('CancelAgreement');
    }
    /**
     * Grants permission to users to cancel pending subscription requests for products that require subscription verification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCancelAgreementRequest() {
        return this.to('CancelAgreementRequest');
    }
    /**
     * Grants permission to users to create an agreement request. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toCreateAgreementRequest() {
        return this.to('CreateAgreementRequest');
    }
    /**
     * Grants permission to users to describe the metadata about the agreement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toDescribeAgreement() {
        return this.to('DescribeAgreement');
    }
    /**
     * Grants permission to users to view the details of their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementApprovalRequest() {
        return this.to('GetAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to view the details of their subscription requests for data products that require subscription verification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementRequest() {
        return this.to('GetAgreementRequest');
    }
    /**
     * Grants permission to users to get a list of terms for an agreement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toGetAgreementTerms() {
        return this.to('GetAgreementTerms');
    }
    /**
     * Grants permission to users to list their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListAgreementApprovalRequests() {
        return this.to('ListAgreementApprovalRequests');
    }
    /**
     * Grants permission to users to list their subscription requests for products that require subscription verification
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListAgreementRequests() {
        return this.to('ListAgreementRequests');
    }
    /**
     * Grants permission to users to view details of the entitlements associated with an agreement. Note that this action is not applicable to Marketplace purchases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toListEntitlementDetails() {
        return this.to('ListEntitlementDetails');
    }
    /**
     * Grants permission to users to decline an incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toRejectAgreementApprovalRequest() {
        return this.to('RejectAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to search their agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toSearchAgreements() {
        return this.to('SearchAgreements');
    }
    /**
     * Grants permission to users to subscribe to AWS Marketplace products. Includes the ability to send a subscription request for products that require subscription verification. Includes the ability to enable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toSubscribe() {
        return this.to('Subscribe');
    }
    /**
     * Grants permission to users to remove subscriptions to AWS Marketplace products. Includes the ability to disable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toUnsubscribe() {
        return this.to('Unsubscribe');
    }
    /**
     * Grants permission to users to make changes to an incoming subscription request, including the ability to delete the prospective subscriber's information (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toUpdateAgreementApprovalRequest() {
        return this.to('UpdateAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to see their account's subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     */
    toViewSubscriptions() {
        return this.to('ViewSubscriptions');
    }
    /**
     * Filters access by the type of the agreement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAgreementType(value, operator) {
        return this.if(`AgreementType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the party type of the agreement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPartyType(value, operator) {
        return this.if(`PartyType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by product id for AWS Marketplace RedHat OpenShift products in the RedHat console. Note: This condition key only applies to the RedHat console, and using it will not restrict access to products in AWS Marketplace
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProductId(value, operator) {
        return this.if(`ProductId`, value, operator || 'StringLike');
    }
}
exports.AwsMarketplace = AwsMarketplace;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplace[_a] = { fqn: "iam-floyd.AwsMarketplace", version: "0.501.0" };
//# sourceMappingURL=data:application/json;base64,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