"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeptuneDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class NeptuneDb extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'neptune-db';
        this.accessLevelList = {
            Write: [
                'CancelLoaderJob',
                'CancelMLDataProcessingJob',
                'CancelMLModelTrainingJob',
                'CancelMLModelTransformJob',
                'CancelQuery',
                'CreateMLEndpoint',
                'DeleteDataViaQuery',
                'DeleteMLEndpoint',
                'DeleteStatistics',
                'ManageStatistics',
                'ResetDatabase',
                'StartLoaderJob',
                'StartMLDataProcessingJob',
                'StartMLModelTrainingJob',
                'StartMLModelTransformJob',
                'WriteDataViaQuery',
                'connect'
            ],
            Read: [
                'GetEngineStatus',
                'GetGraphSummary',
                'GetLoaderJobStatus',
                'GetMLDataProcessingJobStatus',
                'GetMLEndpointStatus',
                'GetMLModelTrainingJobStatus',
                'GetMLModelTransformJobStatus',
                'GetQueryStatus',
                'GetStatisticsStatus',
                'GetStreamRecords',
                'ReadDataViaQuery'
            ],
            List: [
                'ListLoaderJobs',
                'ListMLDataProcessingJobs',
                'ListMLEndpoints',
                'ListMLModelTrainingJobs',
                'ListMLModelTransformJobs'
            ]
        };
    }
    /**
     * Grants permission to cancel a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob
     */
    toCancelLoaderJob() {
        return this.to('CancelLoaderJob');
    }
    /**
     * Grants permission to cancel an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob
     */
    toCancelMLDataProcessingJob() {
        return this.to('CancelMLDataProcessingJob');
    }
    /**
     * Grants permission to cancel an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob
     */
    toCancelMLModelTrainingJob() {
        return this.to('CancelMLModelTrainingJob');
    }
    /**
     * Grants permission to cancel an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob
     */
    toCancelMLModelTransformJob() {
        return this.to('CancelMLModelTransformJob');
    }
    /**
     * Grants permission to cancel a query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery
     */
    toCancelQuery() {
        return this.to('CancelQuery');
    }
    /**
     * Grants permission to create an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint
     */
    toCreateMLEndpoint() {
        return this.to('CreateMLEndpoint');
    }
    /**
     * Grants permission to run delete data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery
     */
    toDeleteDataViaQuery() {
        return this.to('DeleteDataViaQuery');
    }
    /**
     * Grants permission to delete an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint
     */
    toDeleteMLEndpoint() {
        return this.to('DeleteMLEndpoint');
    }
    /**
     * Grants permission to delete all the statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics
     */
    toDeleteStatistics() {
        return this.to('DeleteStatistics');
    }
    /**
     * Grants permission to check the status of the Neptune engine
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus
     */
    toGetEngineStatus() {
        return this.to('GetEngineStatus');
    }
    /**
     * Grants permission to get the graph summary from the database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary
     */
    toGetGraphSummary() {
        return this.to('GetGraphSummary');
    }
    /**
     * Grants permission to check the status of a loader job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus
     */
    toGetLoaderJobStatus() {
        return this.to('GetLoaderJobStatus');
    }
    /**
     * Grants permission to check the status of an ML data processing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus
     */
    toGetMLDataProcessingJobStatus() {
        return this.to('GetMLDataProcessingJobStatus');
    }
    /**
     * Grants permission to check the status of an ML endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus
     */
    toGetMLEndpointStatus() {
        return this.to('GetMLEndpointStatus');
    }
    /**
     * Grants permission to check the status of an ML model training job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus
     */
    toGetMLModelTrainingJobStatus() {
        return this.to('GetMLModelTrainingJobStatus');
    }
    /**
     * Grants permission to check the status of an ML model transform job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus
     */
    toGetMLModelTransformJobStatus() {
        return this.to('GetMLModelTransformJobStatus');
    }
    /**
     * Grants permission to check the status of all active queries
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus
     */
    toGetQueryStatus() {
        return this.to('GetQueryStatus');
    }
    /**
     * Grants permission to check the status of statistics of the database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus
     */
    toGetStatisticsStatus() {
        return this.to('GetStatisticsStatus');
    }
    /**
     * Grants permission to fetch stream records from Neptune
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords
     */
    toGetStreamRecords() {
        return this.to('GetStreamRecords');
    }
    /**
     * Grants permission to list all the loader jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs
     */
    toListLoaderJobs() {
        return this.to('ListLoaderJobs');
    }
    /**
     * Grants permission to list all the ML data processing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs
     */
    toListMLDataProcessingJobs() {
        return this.to('ListMLDataProcessingJobs');
    }
    /**
     * Grants permission to list all the ML endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints
     */
    toListMLEndpoints() {
        return this.to('ListMLEndpoints');
    }
    /**
     * Grants permission to list all the ML model training jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltrainingjobs
     */
    toListMLModelTrainingJobs() {
        return this.to('ListMLModelTrainingJobs');
    }
    /**
     * Grants permission to list all the ML model transform jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs
     */
    toListMLModelTransformJobs() {
        return this.to('ListMLModelTransformJobs');
    }
    /**
     * Grants permission to manage statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics
     */
    toManageStatistics() {
        return this.to('ManageStatistics');
    }
    /**
     * Grants permission to run read data via query APIs on database
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery
     */
    toReadDataViaQuery() {
        return this.to('ReadDataViaQuery');
    }
    /**
     * Grants permission to get the token needed for reset and resets the Neptune database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase
     */
    toResetDatabase() {
        return this.to('ResetDatabase');
    }
    /**
     * Grants permission to start a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob
     */
    toStartLoaderJob() {
        return this.to('StartLoaderJob');
    }
    /**
     * Grants permission to start an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmldataprocessingjob
     */
    toStartMLDataProcessingJob() {
        return this.to('StartMLDataProcessingJob');
    }
    /**
     * Grants permission to start an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob
     */
    toStartMLModelTrainingJob() {
        return this.to('StartMLModelTrainingJob');
    }
    /**
     * Grants permission to start an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob
     */
    toStartMLModelTransformJob() {
        return this.to('StartMLModelTransformJob');
    }
    /**
     * Grants permission to run write data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery
     */
    toWriteDataViaQuery() {
        return this.to('WriteDataViaQuery');
    }
    /**
     * Grants permission to all data-access actions in engine versions prior to 1.2.0.0
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html
     */
    toConnect() {
        return this.to('connect');
    }
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-resources.html
     *
     * @param cluster - Identifier for the cluster.
     * @param database - Identifier for the database.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(cluster, database, account, region, partition) {
        return this.on(`arn:${partition || NeptuneDb.defaultPartition}:neptune-db:${region || '*'}:${account || '*'}:${cluster}/${database}`);
    }
    /**
     * Filters access by graph model
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-context-keys.html#querylanguage
     *
     * Applies to actions:
     * - .toDeleteDataViaQuery()
     * - .toGetQueryStatus()
     * - .toGetStreamRecords()
     * - .toReadDataViaQuery()
     * - .toWriteDataViaQuery()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifQueryLanguage(value, operator) {
        return this.if(`QueryLanguage`, value, operator || 'StringLike');
    }
}
exports.NeptuneDb = NeptuneDb;
_a = JSII_RTTI_SYMBOL_1;
NeptuneDb[_a] = { fqn: "iam-floyd.NeptuneDb", version: "0.501.0" };
//# sourceMappingURL=data:application/json;base64,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