"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerGroundtruthSynthetic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SagemakerGroundtruthSynthetic extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sagemaker-groundtruth-synthetic';
        this.accessLevelList = {
            Write: [
                'CreateProject',
                'DeleteProject',
                'StartBatchDataTransfer',
                'StartProjectDataTransfer',
                'UpdateBatch'
            ],
            Read: [
                'GetAccountDetails',
                'GetBatch',
                'GetProject'
            ],
            List: [
                'ListBatchDataTransfers',
                'ListBatchSummaries',
                'ListProjectDataTransfers',
                'ListProjectSummaries'
            ]
        };
    }
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to get account details
     *
     * Access Level: Read
     */
    toGetAccountDetails() {
        return this.to('GetAccountDetails');
    }
    /**
     * Grants permission to get a batch
     *
     * Access Level: Read
     */
    toGetBatch() {
        return this.to('GetBatch');
    }
    /**
     * Grants permission to get a project
     *
     * Access Level: Read
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to list batch data transfers
     *
     * Access Level: List
     */
    toListBatchDataTransfers() {
        return this.to('ListBatchDataTransfers');
    }
    /**
     * Grants permission to list batch summaries
     *
     * Access Level: List
     */
    toListBatchSummaries() {
        return this.to('ListBatchSummaries');
    }
    /**
     * Grants permission to list project data transfers
     *
     * Access Level: List
     */
    toListProjectDataTransfers() {
        return this.to('ListProjectDataTransfers');
    }
    /**
     * Grants permission to list project summaries
     *
     * Access Level: List
     */
    toListProjectSummaries() {
        return this.to('ListProjectSummaries');
    }
    /**
     * Grants permission to start a batch data transfer
     *
     * Access Level: Write
     */
    toStartBatchDataTransfer() {
        return this.to('StartBatchDataTransfer');
    }
    /**
     * Grants permission to start a project data transfer
     *
     * Access Level: Write
     */
    toStartProjectDataTransfer() {
        return this.to('StartProjectDataTransfer');
    }
    /**
     * Grants permission to update a batch
     *
     * Access Level: Write
     */
    toUpdateBatch() {
        return this.to('UpdateBatch');
    }
}
exports.SagemakerGroundtruthSynthetic = SagemakerGroundtruthSynthetic;
_a = JSII_RTTI_SYMBOL_1;
SagemakerGroundtruthSynthetic[_a] = { fqn: "iam-floyd.SagemakerGroundtruthSynthetic", version: "0.501.0" };
//# sourceMappingURL=data:application/json;base64,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