import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Transcribe extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [transcribe](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranscribe.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an analytics category. Amazon Transcribe applies the conditions specified by your analytics categories to your call analytics jobs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateCallAnalyticsCategory.html
     */
    toCreateCallAnalyticsCategory(): this;
    /**
     * Grants permission to create a new custom language model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateLanguageModel.html
     */
    toCreateLanguageModel(): this;
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe Medical handles transcription of an audio file
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     */
    toCreateMedicalVocabulary(): this;
    /**
     * Grants permission to create a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     */
    toCreateVocabulary(): this;
    /**
     * Grants permission to create a new vocabulary filter that you can use to filter out words from the transcription of an audio file generated by Amazon Transcribe
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     */
    toCreateVocabularyFilter(): this;
    /**
     * Grants permission to delete a call analytics category using its name from Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteCallAnalyticsCategory.html
     */
    toDeleteCallAnalyticsCategory(): this;
    /**
     * Grants permission to delete a previously submitted call analytics job along with any other generated results such as the transcription, models, and so on
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteCallAnalyticsJob.html
     */
    toDeleteCallAnalyticsJob(): this;
    /**
     * Grants permission to delete a previously created custom language model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteLanguageModel.html
     */
    toDeleteLanguageModel(): this;
    /**
     * Grants permission to delete a previously submitted medical transcription job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalTranscriptionJob.html
     */
    toDeleteMedicalTranscriptionJob(): this;
    /**
     * Grants permission to delete a medical vocabulary from Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteMedicalVocabulary.html
     */
    toDeleteMedicalVocabulary(): this;
    /**
     * Grants permission to delete a previously submitted transcription job along with any other generated results such as the transcription, models, and so on
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteTranscriptionJob.html
     */
    toDeleteTranscriptionJob(): this;
    /**
     * Grants permission to delete a vocabulary from Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabulary.html
     */
    toDeleteVocabulary(): this;
    /**
     * Grants permission to delete a vocabulary filter from Amazon Transcribe
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DeleteVocabularyFilter.html
     */
    toDeleteVocabularyFilter(): this;
    /**
     * Grants permission to return information about a custom language model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_DescribeLanguageModel.html
     */
    toDescribeLanguageModel(): this;
    /**
     * Grants permission to retrieve information about a call analytics category
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetCallAnalyticsCategory.html
     */
    toGetCallAnalyticsCategory(): this;
    /**
     * Grants permission to return information about a call analytics job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetCallAnalyticsJob.html
     */
    toGetCallAnalyticsJob(): this;
    /**
     * Grants permission to return information about a medical transcription job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalTranscriptionJob.html
     */
    toGetMedicalTranscriptionJob(): this;
    /**
     * Grants permission to get information about a medical vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetMedicalVocabulary.html
     */
    toGetMedicalVocabulary(): this;
    /**
     * Grants permission to return information about a transcription job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetTranscriptionJob.html
     */
    toGetTranscriptionJob(): this;
    /**
     * Grants permission to to get information about a vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabulary.html
     */
    toGetVocabulary(): this;
    /**
     * Grants permission to get information about a vocabulary filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_GetVocabularyFilter.html
     */
    toGetVocabularyFilter(): this;
    /**
     * Grants permission to list call analytics categories that has been created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListCallAnalyticsCategories.html
     */
    toListCallAnalyticsCategories(): this;
    /**
     * Grants permission to list call analytics jobs with the specified status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListCallAnalyticsJobs.html
     */
    toListCallAnalyticsJobs(): this;
    /**
     * Grants permission to list custom language models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListLanguageModels.html
     */
    toListLanguageModels(): this;
    /**
     * Grants permission to list medical transcription jobs with the specified status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalTranscriptionJobs.html
     */
    toListMedicalTranscriptionJobs(): this;
    /**
     * Grants permission to return a list of medical vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListMedicalVocabularies.html
     */
    toListMedicalVocabularies(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list transcription jobs with the specified status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListTranscriptionJobs.html
     */
    toListTranscriptionJobs(): this;
    /**
     * Grants permission to return a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularies.html
     */
    toListVocabularies(): this;
    /**
     * Grants permission to return a list of vocabulary filters that match the specified criteria. If no criteria are specified, returns the at most 5 vocabulary filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_ListVocabularyFilters.html
     */
    toListVocabularyFilters(): this;
    /**
     * Grants permission to start an asynchronous analytics job that not only transcribes the audio recording of a caller and agent, but also returns additional insights
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifOutputEncryptionKMSKeyId()
     * - .ifOutputLocation()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartCallAnalyticsJob.html
     */
    toStartCallAnalyticsJob(): this;
    /**
     * Grants permission to start a protocol where audio is streamed to Transcribe Call Analytics and the transcription results are streamed to your application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartCallAnalyticsStreamTranscription.html
     */
    toStartCallAnalyticsStreamTranscription(): this;
    /**
     * Grants permission to start a WebSocket where audio is streamed to Transcribe Call Analytics and the transcription results are streamed to your application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartCallAnalyticsStreamTranscriptionWebSocket.html
     */
    toStartCallAnalyticsStreamTranscriptionWebSocket(): this;
    /**
     * Grants permission to start a protocol where audio is streamed to Transcribe Medical and the transcription results are streamed to your application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscription.html
     */
    toStartMedicalStreamTranscription(): this;
    /**
     * Grants permission to start a WebSocket where audio is streamed to Transcribe Medical and the transcription results are streamed to your application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartMedicalStreamTranscriptionWebSocket.html
     */
    toStartMedicalStreamTranscriptionWebSocket(): this;
    /**
     * Grants permission to start an asynchronous job to transcribe medical speech to text
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifOutputBucketName()
     * - .ifOutputEncryptionKMSKeyId()
     * - .ifOutputKey()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartMedicalTranscriptionJob.html
     */
    toStartMedicalTranscriptionJob(): this;
    /**
     * Grants permission to start a bidirectional HTTP2 stream to transcribe speech to text in real time
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscription.html
     */
    toStartStreamTranscription(): this;
    /**
     * Grants permission to start a websocket stream to transcribe speech to text in real time
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_streaming_StartStreamTranscriptionWebSocket.html
     */
    toStartStreamTranscriptionWebSocket(): this;
    /**
     * Grants permission to start an asynchronous job to transcribe speech to text
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifOutputBucketName()
     * - .ifOutputEncryptionKMSKeyId()
     * - .ifOutputKey()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_StartTranscriptionJob.html
     */
    toStartTranscriptionJob(): this;
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource with given key
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the call analytics category with new values. The UpdateCallAnalyticsCategory operation overwrites all of the existing information with the values that you provide in the request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateCallAnalyticsCategory.html
     */
    toUpdateCallAnalyticsCategory(): this;
    /**
     * Grants permission to update an existing medical vocabulary with new values. The UpdateMedicalVocabulary operation overwrites all of the existing information with the values that you provide in the request
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateMedicalVocabulary.html
     */
    toUpdateMedicalVocabulary(): this;
    /**
     * Grants permission to update an existing vocabulary with new values. The UpdateVocabulary operation overwrites all of the existing information with the values that you provide in the request
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabulary.html
     */
    toUpdateVocabulary(): this;
    /**
     * Grants permission to update an existing vocabulary filter with new values. The UpdateVocabularyFilter operation overwrites all of the existing information with the values that you provide in the request
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_UpdateVocabularyFilter.html
     */
    toUpdateVocabularyFilter(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type transcriptionjob to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_TranscriptionJob.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTranscriptionjob(jobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vocabulary to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabulary.html
     *
     * @param vocabularyName - Identifier for the vocabularyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVocabulary(vocabularyName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vocabularyfilter to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateVocabularyFilter.html
     *
     * @param vocabularyFilterName - Identifier for the vocabularyFilterName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVocabularyfilter(vocabularyFilterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type languagemodel to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_LanguageModel.html
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLanguagemodel(modelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type medicaltranscriptionjob to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_MedicalTranscriptionJob.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMedicaltranscriptionjob(jobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type medicalvocabulary to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateMedicalVocabulary.html
     *
     * @param vocabularyName - Identifier for the vocabularyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMedicalvocabulary(vocabularyName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type callanalyticsjob to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CallAnalyticsJob.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCallanalyticsjob(jobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type callanalyticscategory to the statement
     *
     * https://docs.aws.amazon.com/transcribe/latest/dg/API_CreateCallAnalyticsCategory.html
     *
     * @param categoryName - Identifier for the categoryName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCallanalyticscategory(categoryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the output bucket name included in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartMedicalTranscriptionJob()
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOutputBucketName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the KMS key id included in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartCallAnalyticsJob()
     * - .toStartMedicalTranscriptionJob()
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOutputEncryptionKMSKeyId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the output key included in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartMedicalTranscriptionJob()
     * - .toStartTranscriptionJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOutputKey(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the output location included in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazontranscribe.html#amazontranscribe-policy-keys
     *
     * Applies to actions:
     * - .toStartCallAnalyticsJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOutputLocation(value: string | string[], operator?: Operator | string): this;
}
