# mypy-boto3-es

[![PyPI - mypy-boto3-es](https://img.shields.io/pypi/v/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticsearchService 1.16.5](https://boto3.amazonaws.com/v1/documentation/api/1.16.5/reference/services/es.html#ElasticsearchService) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-es](#mypy-boto3-es)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ElasticsearchService` service.

```bash
python -m pip install boto3-stubs[es]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[es]` in your environment: `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[es]` in your environment: `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[es]` in your environment: `python -m pip install 'boto3-stubs[es]'`
- Run `mypy` as usual

Type checking should work for `ElasticsearchService` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[es]` in your environment: `python -m pip install 'boto3-stubs[es]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticsearchService` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ElasticsearchServiceClient` provides annotations for `boto3.client("es")`.

```python
import boto3

from mypy_boto3_es import ElasticsearchServiceClient

client: ElasticsearchServiceClient = boto3.client("es")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticsearchServiceClient = session.client("es")
```

### Paginators annotations

`mypy_boto3_es.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_es import ElasticsearchServiceClient
from mypy_boto3_es.paginator import (
    DescribeReservedElasticsearchInstanceOfferingsPaginator,
    DescribeReservedElasticsearchInstancesPaginator,
    GetUpgradeHistoryPaginator,
    ListElasticsearchInstanceTypesPaginator,
    ListElasticsearchVersionsPaginator,
)

client: ElasticsearchServiceClient = boto3.client("es")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_reserved_elasticsearch_instance_offerings_paginator: DescribeReservedElasticsearchInstanceOfferingsPaginator = client.get_paginator("describe_reserved_elasticsearch_instance_offerings")
describe_reserved_elasticsearch_instances_paginator: DescribeReservedElasticsearchInstancesPaginator = client.get_paginator("describe_reserved_elasticsearch_instances")
get_upgrade_history_paginator: GetUpgradeHistoryPaginator = client.get_paginator("get_upgrade_history")
list_elasticsearch_instance_types_paginator: ListElasticsearchInstanceTypesPaginator = client.get_paginator("list_elasticsearch_instance_types")
list_elasticsearch_versions_paginator: ListElasticsearchVersionsPaginator = client.get_paginator("list_elasticsearch_versions")
```







### Typed dictionations

`mypy_boto3_es.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_es.type_defs import (
    AcceptInboundCrossClusterSearchConnectionResponseTypeDef,
    AccessPoliciesStatusTypeDef,
    AdditionalLimitTypeDef,
    AdvancedOptionsStatusTypeDef,
    AdvancedSecurityOptionsInputTypeDef,
    AdvancedSecurityOptionsStatusTypeDef,
    AdvancedSecurityOptionsTypeDef,
    AssociatePackageResponseTypeDef,
    CancelElasticsearchServiceSoftwareUpdateResponseTypeDef,
    CognitoOptionsStatusTypeDef,
    CognitoOptionsTypeDef,
    CompatibleVersionsMapTypeDef,
    CreateElasticsearchDomainResponseTypeDef,
    CreateOutboundCrossClusterSearchConnectionResponseTypeDef,
    CreatePackageResponseTypeDef,
    DeleteElasticsearchDomainResponseTypeDef,
    DeleteInboundCrossClusterSearchConnectionResponseTypeDef,
    DeleteOutboundCrossClusterSearchConnectionResponseTypeDef,
    DeletePackageResponseTypeDef,
    DescribeElasticsearchDomainConfigResponseTypeDef,
    DescribeElasticsearchDomainResponseTypeDef,
    DescribeElasticsearchDomainsResponseTypeDef,
    DescribeElasticsearchInstanceTypeLimitsResponseTypeDef,
    DescribeInboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribeOutboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribePackagesFilterTypeDef,
    DescribePackagesResponseTypeDef,
    DescribeReservedElasticsearchInstanceOfferingsResponseTypeDef,
    DescribeReservedElasticsearchInstancesResponseTypeDef,
    DissociatePackageResponseTypeDef,
    DomainEndpointOptionsStatusTypeDef,
    DomainEndpointOptionsTypeDef,
    DomainInformationTypeDef,
    DomainInfoTypeDef,
    DomainPackageDetailsTypeDef,
    EBSOptionsStatusTypeDef,
    EBSOptionsTypeDef,
    ElasticsearchClusterConfigStatusTypeDef,
    ElasticsearchClusterConfigTypeDef,
    ElasticsearchDomainConfigTypeDef,
    ElasticsearchDomainStatusTypeDef,
    ElasticsearchVersionStatusTypeDef,
    EncryptionAtRestOptionsStatusTypeDef,
    EncryptionAtRestOptionsTypeDef,
    ErrorDetailsTypeDef,
    FilterTypeDef,
    GetCompatibleElasticsearchVersionsResponseTypeDef,
    GetUpgradeHistoryResponseTypeDef,
    GetUpgradeStatusResponseTypeDef,
    InboundCrossClusterSearchConnectionStatusTypeDef,
    InboundCrossClusterSearchConnectionTypeDef,
    InstanceCountLimitsTypeDef,
    InstanceLimitsTypeDef,
    LimitsTypeDef,
    ListDomainNamesResponseTypeDef,
    ListDomainsForPackageResponseTypeDef,
    ListElasticsearchInstanceTypesResponseTypeDef,
    ListElasticsearchVersionsResponseTypeDef,
    ListPackagesForDomainResponseTypeDef,
    ListTagsResponseTypeDef,
    LogPublishingOptionsStatusTypeDef,
    LogPublishingOptionTypeDef,
    MasterUserOptionsTypeDef,
    NodeToNodeEncryptionOptionsStatusTypeDef,
    NodeToNodeEncryptionOptionsTypeDef,
    OptionStatusTypeDef,
    OutboundCrossClusterSearchConnectionStatusTypeDef,
    OutboundCrossClusterSearchConnectionTypeDef,
    PackageDetailsTypeDef,
    PackageSourceTypeDef,
    PaginatorConfigTypeDef,
    PurchaseReservedElasticsearchInstanceOfferingResponseTypeDef,
    RecurringChargeTypeDef,
    RejectInboundCrossClusterSearchConnectionResponseTypeDef,
    ReservedElasticsearchInstanceOfferingTypeDef,
    ReservedElasticsearchInstanceTypeDef,
    ServiceSoftwareOptionsTypeDef,
    SnapshotOptionsStatusTypeDef,
    SnapshotOptionsTypeDef,
    StartElasticsearchServiceSoftwareUpdateResponseTypeDef,
    StorageTypeLimitTypeDef,
    StorageTypeTypeDef,
    TagTypeDef,
    UpdateElasticsearchDomainConfigResponseTypeDef,
    UpgradeElasticsearchDomainResponseTypeDef,
    UpgradeHistoryTypeDef,
    UpgradeStepItemTypeDef,
    VPCDerivedInfoStatusTypeDef,
    VPCDerivedInfoTypeDef,
    VPCOptionsTypeDef,
    ZoneAwarenessConfigTypeDef,
)

def get_structure() -> AccessPoliciesStatusTypeDef:
    return {
      ...
    }
```
