"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
 *
 * @experimental
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'inspector';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddAttributesToFindings",
                "CreateAssessmentTarget",
                "CreateAssessmentTemplate",
                "CreateResourceGroup",
                "DeleteAssessmentRun",
                "DeleteAssessmentTarget",
                "DeleteAssessmentTemplate",
                "RegisterCrossAccountAccessRole",
                "RemoveAttributesFromFindings",
                "StartAssessmentRun",
                "StopAssessmentRun",
                "SubscribeToEvent",
                "UnsubscribeFromEvent",
                "UpdateAssessmentTarget"
            ],
            "Read": [
                "DescribeAssessmentRuns",
                "DescribeAssessmentTargets",
                "DescribeAssessmentTemplates",
                "DescribeCrossAccountAccessRole",
                "DescribeFindings",
                "DescribeResourceGroups",
                "DescribeRulesPackages",
                "GetTelemetryMetadata",
                "PreviewAgents"
            ],
            "List": [
                "ListAssessmentRunAgents",
                "ListAssessmentRuns",
                "ListAssessmentTargets",
                "ListAssessmentTemplates",
                "ListEventSubscriptions",
                "ListFindings",
                "ListRulesPackages",
                "ListTagsForResource"
            ],
            "Tagging": [
                "SetTagsForResource"
            ]
        };
    }
    /**
     * (experimental) Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     *
     * @experimental
     */
    toAddAttributesToFindings() {
        return this.to('AddAttributesToFindings');
    }
    /**
     * (experimental) Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     *
     * @experimental
     */
    toCreateAssessmentTarget() {
        return this.to('CreateAssessmentTarget');
    }
    /**
     * (experimental) Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     *
     * @experimental
     */
    toCreateAssessmentTemplate() {
        return this.to('CreateAssessmentTemplate');
    }
    /**
     * (experimental) Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     *
     * @experimental
     */
    toCreateResourceGroup() {
        return this.to('CreateResourceGroup');
    }
    /**
     * (experimental) Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     *
     * @experimental
     */
    toDeleteAssessmentRun() {
        return this.to('DeleteAssessmentRun');
    }
    /**
     * (experimental) Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     *
     * @experimental
     */
    toDeleteAssessmentTarget() {
        return this.to('DeleteAssessmentTarget');
    }
    /**
     * (experimental) Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     *
     * @experimental
     */
    toDeleteAssessmentTemplate() {
        return this.to('DeleteAssessmentTemplate');
    }
    /**
     * (experimental) Describes the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     *
     * @experimental
     */
    toDescribeAssessmentRuns() {
        return this.to('DescribeAssessmentRuns');
    }
    /**
     * (experimental) Describes the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     *
     * @experimental
     */
    toDescribeAssessmentTargets() {
        return this.to('DescribeAssessmentTargets');
    }
    /**
     * (experimental) Describes the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     *
     * @experimental
     */
    toDescribeAssessmentTemplates() {
        return this.to('DescribeAssessmentTemplates');
    }
    /**
     * (experimental) Describes the IAM role that enables Amazon Inspector to access your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     *
     * @experimental
     */
    toDescribeCrossAccountAccessRole() {
        return this.to('DescribeCrossAccountAccessRole');
    }
    /**
     * (experimental) Describes the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     *
     * @experimental
     */
    toDescribeFindings() {
        return this.to('DescribeFindings');
    }
    /**
     * (experimental) Describes the resource groups that are specified by the ARNs of the resource groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     *
     * @experimental
     */
    toDescribeResourceGroups() {
        return this.to('DescribeResourceGroups');
    }
    /**
     * (experimental) Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     *
     * @experimental
     */
    toDescribeRulesPackages() {
        return this.to('DescribeRulesPackages');
    }
    /**
     * (experimental) Information about the data that is collected for the specified assessment run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     *
     * @experimental
     */
    toGetTelemetryMetadata() {
        return this.to('GetTelemetryMetadata');
    }
    /**
     * (experimental) Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     *
     * @experimental
     */
    toListAssessmentRunAgents() {
        return this.to('ListAssessmentRunAgents');
    }
    /**
     * (experimental) Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     *
     * @experimental
     */
    toListAssessmentRuns() {
        return this.to('ListAssessmentRuns');
    }
    /**
     * (experimental) Lists the ARNs of the assessment targets within this AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     *
     * @experimental
     */
    toListAssessmentTargets() {
        return this.to('ListAssessmentTargets');
    }
    /**
     * (experimental) Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     *
     * @experimental
     */
    toListAssessmentTemplates() {
        return this.to('ListAssessmentTemplates');
    }
    /**
     * (experimental) Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     *
     * @experimental
     */
    toListEventSubscriptions() {
        return this.to('ListEventSubscriptions');
    }
    /**
     * (experimental) Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     *
     * @experimental
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * (experimental) Lists all available Amazon Inspector rules packages.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     *
     * @experimental
     */
    toListRulesPackages() {
        return this.to('ListRulesPackages');
    }
    /**
     * (experimental) Lists all tags associated with an assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     *
     * @experimental
     */
    toPreviewAgents() {
        return this.to('PreviewAgents');
    }
    /**
     * (experimental) Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     *
     * @experimental
     */
    toRegisterCrossAccountAccessRole() {
        return this.to('RegisterCrossAccountAccessRole');
    }
    /**
     * (experimental) Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     *
     * @experimental
     */
    toRemoveAttributesFromFindings() {
        return this.to('RemoveAttributesFromFindings');
    }
    /**
     * (experimental) Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     *
     * @experimental
     */
    toSetTagsForResource() {
        return this.to('SetTagsForResource');
    }
    /**
     * (experimental) Starts the assessment run specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     *
     * @experimental
     */
    toStartAssessmentRun() {
        return this.to('StartAssessmentRun');
    }
    /**
     * (experimental) Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     *
     * @experimental
     */
    toStopAssessmentRun() {
        return this.to('StopAssessmentRun');
    }
    /**
     * (experimental) Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     *
     * @experimental
     */
    toSubscribeToEvent() {
        return this.to('SubscribeToEvent');
    }
    /**
     * (experimental) Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     *
     * @experimental
     */
    toUnsubscribeFromEvent() {
        return this.to('UnsubscribeFromEvent');
    }
    /**
     * (experimental) Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     *
     * @experimental
     */
    toUpdateAssessmentTarget() {
        return this.to('UpdateAssessmentTarget');
    }
}
exports.Inspector = Inspector;
_a = JSII_RTTI_SYMBOL_1;
Inspector[_a] = { fqn: "iam-floyd.Inspector", version: "0.125.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zcGVjdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW5zcGVjdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDOzs7Ozs7QUFPNUMsTUFBYSxTQUFVLFNBQVEsd0JBQWU7Ozs7Ozs7SUFRNUMsWUFBYSxHQUFZO1FBQ3ZCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQzs7Ozs7O1FBUk4sa0JBQWEsR0FBRyxXQUFXLENBQUM7Ozs7UUEyV3pCLG9CQUFlLEdBQW9CO1lBQzNDLE9BQU8sRUFBRTtnQkFDUCx5QkFBeUI7Z0JBQ3pCLHdCQUF3QjtnQkFDeEIsMEJBQTBCO2dCQUMxQixxQkFBcUI7Z0JBQ3JCLHFCQUFxQjtnQkFDckIsd0JBQXdCO2dCQUN4QiwwQkFBMEI7Z0JBQzFCLGdDQUFnQztnQkFDaEMsOEJBQThCO2dCQUM5QixvQkFBb0I7Z0JBQ3BCLG1CQUFtQjtnQkFDbkIsa0JBQWtCO2dCQUNsQixzQkFBc0I7Z0JBQ3RCLHdCQUF3QjthQUN6QjtZQUNELE1BQU0sRUFBRTtnQkFDTix3QkFBd0I7Z0JBQ3hCLDJCQUEyQjtnQkFDM0IsNkJBQTZCO2dCQUM3QixnQ0FBZ0M7Z0JBQ2hDLGtCQUFrQjtnQkFDbEIsd0JBQXdCO2dCQUN4Qix1QkFBdUI7Z0JBQ3ZCLHNCQUFzQjtnQkFDdEIsZUFBZTthQUNoQjtZQUNELE1BQU0sRUFBRTtnQkFDTix5QkFBeUI7Z0JBQ3pCLG9CQUFvQjtnQkFDcEIsdUJBQXVCO2dCQUN2Qix5QkFBeUI7Z0JBQ3pCLHdCQUF3QjtnQkFDeEIsY0FBYztnQkFDZCxtQkFBbUI7Z0JBQ25CLHFCQUFxQjthQUN0QjtZQUNELFNBQVMsRUFBRTtnQkFDVCxvQkFBb0I7YUFDckI7U0FDRixDQUFDO0lBM1lGLENBQUM7Ozs7Ozs7Ozs7SUFTTSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7Ozs7Ozs7OztJQVNNLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7Ozs7Ozs7O0lBU00sMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7Ozs7Ozs7Ozs7SUFTTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQzs7Ozs7Ozs7OztJQVNNLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7Ozs7O0lBU00sd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7Ozs7Ozs7SUFTTSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQzs7Ozs7Ozs7OztJQVNNLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7Ozs7Ozs7O0lBU00sMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7Ozs7Ozs7SUFTTSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQzs7Ozs7Ozs7OztJQVNNLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7Ozs7O0lBU00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFTTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7Ozs7OztJQVNNLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7O0lBU00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7SUFTTSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7Ozs7Ozs7OztJQVNNLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7Ozs7O0lBU00sdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7Ozs7Ozs7Ozs7SUFTTSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7Ozs7Ozs7OztJQVNNLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDOzs7Ozs7Ozs7O0lBU00sY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQzs7Ozs7Ozs7OztJQVNNLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBU00scUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Ozs7Ozs7Ozs7SUFTTSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDOzs7Ozs7Ozs7O0lBU00sZ0NBQWdDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25ELENBQUM7Ozs7Ozs7Ozs7SUFTTSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQzs7Ozs7Ozs7OztJQVNNLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7Ozs7O0lBU00sb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7Ozs7SUFTTSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7Ozs7OztJQVNNLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDOzs7Ozs7Ozs7O0lBU00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7Ozs7Ozs7SUFTTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7QUExV0gsOEJBc1pDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSBcIi4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWxcIjtcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gXCIuLi9zaGFyZWRcIjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBJbnNwZWN0b3IgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdpbnNwZWN0b3InO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3IgKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0FkZEF0dHJpYnV0ZXNUb0ZpbmRpbmdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBZGRBdHRyaWJ1dGVzVG9GaW5kaW5ncycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlQXNzZXNzbWVudFRhcmdldCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlQXNzZXNzbWVudFRhcmdldCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZUFzc2Vzc21lbnRUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlQXNzZXNzbWVudFRlbXBsYXRlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVJlc291cmNlR3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVJlc291cmNlR3JvdXAnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVsZXRlQXNzZXNzbWVudFJ1bigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQXNzZXNzbWVudFJ1bicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVBc3Nlc3NtZW50VGFyZ2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVBc3Nlc3NtZW50VGFyZ2V0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZUFzc2Vzc21lbnRUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQXNzZXNzbWVudFRlbXBsYXRlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVBc3Nlc3NtZW50UnVucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVBc3Nlc3NtZW50UnVucycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQXNzZXNzbWVudFRhcmdldHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQXNzZXNzbWVudFRhcmdldHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZUFzc2Vzc21lbnRUZW1wbGF0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQXNzZXNzbWVudFRlbXBsYXRlcycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZUNyb3NzQWNjb3VudEFjY2Vzc1JvbGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQ3Jvc3NBY2NvdW50QWNjZXNzUm9sZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZXNjcmliZUZpbmRpbmdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUZpbmRpbmdzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvRGVzY3JpYmVSZXNvdXJjZUdyb3VwcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSZXNvdXJjZUdyb3VwcycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUnVsZXNQYWNrYWdlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSdWxlc1BhY2thZ2VzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldFRlbGVtZXRyeU1ldGFkYXRhKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRUZWxlbWV0cnlNZXRhZGF0YScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEFzc2Vzc21lbnRSdW5BZ2VudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3Nlc3NtZW50UnVuQWdlbnRzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0QXNzZXNzbWVudFJ1bnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3Nlc3NtZW50UnVucycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0QXNzZXNzbWVudFRhcmdldHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3Nlc3NtZW50VGFyZ2V0cycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEFzc2Vzc21lbnRUZW1wbGF0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3Nlc3NtZW50VGVtcGxhdGVzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RFdmVudFN1YnNjcmlwdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RFdmVudFN1YnNjcmlwdGlvbnMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0xpc3RGaW5kaW5ncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEZpbmRpbmdzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0UnVsZXNQYWNrYWdlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFJ1bGVzUGFja2FnZXMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1ByZXZpZXdBZ2VudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1ByZXZpZXdBZ2VudHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvUmVnaXN0ZXJDcm9zc0FjY291bnRBY2Nlc3NSb2xlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZWdpc3RlckNyb3NzQWNjb3VudEFjY2Vzc1JvbGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvUmVtb3ZlQXR0cmlidXRlc0Zyb21GaW5kaW5ncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnUmVtb3ZlQXR0cmlidXRlc0Zyb21GaW5kaW5ncycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1NldFRhZ3NGb3JSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU2V0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9TdGFydEFzc2Vzc21lbnRSdW4oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0QXNzZXNzbWVudFJ1bicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1N0b3BBc3Nlc3NtZW50UnVuKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdG9wQXNzZXNzbWVudFJ1bicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9TdWJzY3JpYmVUb0V2ZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdWJzY3JpYmVUb0V2ZW50Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVW5zdWJzY3JpYmVGcm9tRXZlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1Vuc3Vic2NyaWJlRnJvbUV2ZW50Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1VwZGF0ZUFzc2Vzc21lbnRUYXJnZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFzc2Vzc21lbnRUYXJnZXQnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBcIldyaXRlXCI6IFtcbiAgICAgIFwiQWRkQXR0cmlidXRlc1RvRmluZGluZ3NcIixcbiAgICAgIFwiQ3JlYXRlQXNzZXNzbWVudFRhcmdldFwiLFxuICAgICAgXCJDcmVhdGVBc3Nlc3NtZW50VGVtcGxhdGVcIixcbiAgICAgIFwiQ3JlYXRlUmVzb3VyY2VHcm91cFwiLFxuICAgICAgXCJEZWxldGVBc3Nlc3NtZW50UnVuXCIsXG4gICAgICBcIkRlbGV0ZUFzc2Vzc21lbnRUYXJnZXRcIixcbiAgICAgIFwiRGVsZXRlQXNzZXNzbWVudFRlbXBsYXRlXCIsXG4gICAgICBcIlJlZ2lzdGVyQ3Jvc3NBY2NvdW50QWNjZXNzUm9sZVwiLFxuICAgICAgXCJSZW1vdmVBdHRyaWJ1dGVzRnJvbUZpbmRpbmdzXCIsXG4gICAgICBcIlN0YXJ0QXNzZXNzbWVudFJ1blwiLFxuICAgICAgXCJTdG9wQXNzZXNzbWVudFJ1blwiLFxuICAgICAgXCJTdWJzY3JpYmVUb0V2ZW50XCIsXG4gICAgICBcIlVuc3Vic2NyaWJlRnJvbUV2ZW50XCIsXG4gICAgICBcIlVwZGF0ZUFzc2Vzc21lbnRUYXJnZXRcIlxuICAgIF0sXG4gICAgXCJSZWFkXCI6IFtcbiAgICAgIFwiRGVzY3JpYmVBc3Nlc3NtZW50UnVuc1wiLFxuICAgICAgXCJEZXNjcmliZUFzc2Vzc21lbnRUYXJnZXRzXCIsXG4gICAgICBcIkRlc2NyaWJlQXNzZXNzbWVudFRlbXBsYXRlc1wiLFxuICAgICAgXCJEZXNjcmliZUNyb3NzQWNjb3VudEFjY2Vzc1JvbGVcIixcbiAgICAgIFwiRGVzY3JpYmVGaW5kaW5nc1wiLFxuICAgICAgXCJEZXNjcmliZVJlc291cmNlR3JvdXBzXCIsXG4gICAgICBcIkRlc2NyaWJlUnVsZXNQYWNrYWdlc1wiLFxuICAgICAgXCJHZXRUZWxlbWV0cnlNZXRhZGF0YVwiLFxuICAgICAgXCJQcmV2aWV3QWdlbnRzXCJcbiAgICBdLFxuICAgIFwiTGlzdFwiOiBbXG4gICAgICBcIkxpc3RBc3Nlc3NtZW50UnVuQWdlbnRzXCIsXG4gICAgICBcIkxpc3RBc3Nlc3NtZW50UnVuc1wiLFxuICAgICAgXCJMaXN0QXNzZXNzbWVudFRhcmdldHNcIixcbiAgICAgIFwiTGlzdEFzc2Vzc21lbnRUZW1wbGF0ZXNcIixcbiAgICAgIFwiTGlzdEV2ZW50U3Vic2NyaXB0aW9uc1wiLFxuICAgICAgXCJMaXN0RmluZGluZ3NcIixcbiAgICAgIFwiTGlzdFJ1bGVzUGFja2FnZXNcIixcbiAgICAgIFwiTGlzdFRhZ3NGb3JSZXNvdXJjZVwiXG4gICAgXSxcbiAgICBcIlRhZ2dpbmdcIjogW1xuICAgICAgXCJTZXRUYWdzRm9yUmVzb3VyY2VcIlxuICAgIF1cbiAgfTtcbn1cbiJdfQ==