import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
 *
 * @experimental
 */
export declare class Ssmmessages extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Registers a control channel for an instance to send control messages to Systems Manager service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateControlChannel(): this;
    /**
     * (experimental) Registers a data channel for an instance to send data messages to Systems Manager service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateDataChannel(): this;
    /**
     * (experimental) Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toOpenControlChannel(): this;
    /**
     * (experimental) Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toOpenDataChannel(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
