import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [sso-directory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsssodirectory.html).
 *
 * @experimental
 */
export declare class SsoDirectory extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [sso-directory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsssodirectory.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add a member to a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toAddMemberToGroup(): this;
    /**
     * (experimental) Grants permission to complete the creation process of a virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCompleteVirtualMfaDeviceRegistration(): this;
    /**
     * (experimental) Grants permission to complete the registration process of a WebAuthn device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCompleteWebAuthnDeviceRegistration(): this;
    /**
     * (experimental) Grants permission to create an alias for the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateAlias(): this;
    /**
     * (experimental) Grants permission to create a bearer token for a given provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateBearerToken(): this;
    /**
     * (experimental) Grants permission to create an External Identity Provider configuration for the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateExternalIdPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to create a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Grants permission to create a provisioning tenant for a given directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateProvisioningTenant(): this;
    /**
     * (experimental) Grants permission to create a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to delete a bearer token.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteBearerToken(): this;
    /**
     * (experimental) Grants permission to delete the given external IdP certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteExternalIdPCertificate(): this;
    /**
     * (experimental) Grants permission to delete an External Identity Provider configuration associated with the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteExternalIdPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to delete a group from the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Grants permission to delete a MFA device by device name for a given user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteMfaDeviceForUser(): this;
    /**
     * (experimental) Grants permission to delete the provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteProvisioningTenant(): this;
    /**
     * (experimental) Grants permission to delete a user from the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Grants permission to retrieve information about the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeDirectory(): this;
    /**
     * (experimental) Grants permission to retrieve information about a group from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeGroups(): this;
    /**
     * (experimental) Grants permission to retrieve information about a user from the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeUser(): this;
    /**
     * (experimental) Grants permission to retrieve information about user from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDescribeUsers(): this;
    /**
     * (experimental) Grants permission to disable authentication of end users with an External Identity Provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisableExternalIdPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to deactivate a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toDisableUser(): this;
    /**
     * (experimental) Grants permission to enable authentication of end users with an External Identity Provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toEnableExternalIdPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to activate user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toEnableUser(): this;
    /**
     * (experimental) Grants permission to retrieve the AWS SSO Service Provider configurations for the directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toGetAWSSPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to import the IdP certificate used for verifying external IdP responses.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toImportExternalIdPCertificate(): this;
    /**
     * (experimental) Grants permission to check if a member is a part of the group in the directory that AWS SSO provides by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toIsMemberInGroup(): this;
    /**
     * (experimental) Grants permission to list bearer tokens for a given provisioning tenant.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListBearerTokens(): this;
    /**
     * (experimental) Grants permission to list the external IdP certificates of a given directory and IdP.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListExternalIdPCertificates(): this;
    /**
     * (experimental) Grants permission to list all the External Identity Provider configurations created for the directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListExternalIdPConfigurationsForDirectory(): this;
    /**
     * (experimental) Grants permission to list groups for a user from the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListGroupsForUser(): this;
    /**
     * (experimental) Grants permission to retrieve all members that are part of a group in the directory that AWS SSO provides by default.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListMembersInGroup(): this;
    /**
     * (experimental) Grants permission to list all active MFA devices and their MFA device metadata for a user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListMfaDevicesForUser(): this;
    /**
     * (experimental) Grants permission to list provisioning tenants for a given directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toListProvisioningTenants(): this;
    /**
     * (experimental) Grants permission to remove a member that is part of a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toRemoveMemberFromGroup(): this;
    /**
     * (experimental) Grants permission to search for groups within the associated directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchGroups(): this;
    /**
     * (experimental) Grants permission to search for users within the associated directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toSearchUsers(): this;
    /**
     * (experimental) Grants permission to begin the creation process of virtual mfa device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toStartVirtualMfaDeviceRegistration(): this;
    /**
     * (experimental) Grants permission to begin the registration process of a WebAuthn device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toStartWebAuthnDeviceRegistration(): this;
    /**
     * (experimental) Grants permission to update an External Identity Provider configuration associated with the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateExternalIdPConfigurationForDirectory(): this;
    /**
     * (experimental) Grants permission to update information about a group in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateGroup(): this;
    /**
     * (experimental) Grants permission to update MFA device information.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateMfaDeviceForUser(): this;
    /**
     * (experimental) Grants permission to update a password by sending password reset link via email or generating one time password for a user in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdatePassword(): this;
    /**
     * (experimental) Grants permission to update user information in the directory that AWS SSO provides by default.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toUpdateUser(): this;
    /**
     * (experimental) Grants permission to verify an email address of an User.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     *
     * @experimental
     */
    toVerifyEmail(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
