"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Activate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
 *
 * @experimental
 */
class Activate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'activate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'CreateForm',
                'PutMemberInfo'
            ],
            Read: [
                'GetAccountContact',
                'GetContentInfo',
                'GetCosts',
                'GetCredits',
                'GetMemberInfo',
                'GetProgram'
            ]
        };
    }
    /**
     * (experimental) Grants permission to submit an Activate application form.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateForm() {
        return this.to('CreateForm');
    }
    /**
     * (experimental) Grants permission to get the AWS account contact information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetAccountContact() {
        return this.to('GetAccountContact');
    }
    /**
     * (experimental) Grants permission to get Activate tech posts and offer information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetContentInfo() {
        return this.to('GetContentInfo');
    }
    /**
     * (experimental) Grants permission to get the AWS cost information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCosts() {
        return this.to('GetCosts');
    }
    /**
     * (experimental) Grants permission to get the AWS credit information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCredits() {
        return this.to('GetCredits');
    }
    /**
     * (experimental) Grants permission to get the Activate member information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMemberInfo() {
        return this.to('GetMemberInfo');
    }
    /**
     * (experimental) Grants permission to get an Activate program.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetProgram() {
        return this.to('GetProgram');
    }
    /**
     * (experimental) Grants permission to create or update the Activate member information.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutMemberInfo() {
        return this.to('PutMemberInfo');
    }
}
exports.Activate = Activate;
_a = JSII_RTTI_SYMBOL_1;
Activate[_a] = { fqn: "iam-floyd.Activate", version: "0.316.0" };
//# sourceMappingURL=data:application/json;base64,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