"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCostProfiler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [application-cost-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationcostprofilerservice.html).
 *
 * @experimental
 */
class ApplicationCostProfiler extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [application-cost-profiler](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationcostprofilerservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'application-cost-profiler';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'DeleteReportDefinition',
                'ImportApplicationUsage',
                'PutReportDefinition',
                'UpdateReportDefinition'
            ],
            Read: [
                'GetReportDefinition',
                'ListReportDefinitions'
            ]
        };
    }
    /**
     * (experimental) Grants permission to delete the configuration with specific Application Cost Profiler Report thereby effectively disabling report generation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_DeleteReportDefinition.html
     *
     * @experimental
     */
    toDeleteReportDefinition() {
        return this.to('DeleteReportDefinition');
    }
    /**
     * (experimental) Grants permission to fetch the configuration with specific Application Cost Profiler Report request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_GetReportDefinition.html
     *
     * @experimental
     */
    toGetReportDefinition() {
        return this.to('GetReportDefinition');
    }
    /**
     * (experimental) Grants permission to import the application usage from S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_ImportApplicationUsage.html
     *
     * @experimental
     */
    toImportApplicationUsage() {
        return this.to('ImportApplicationUsage');
    }
    /**
     * (experimental) Grants permission to get a list of the different Application Cost Profiler Report configurations they have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_ListReportDefinitions.html
     *
     * @experimental
     */
    toListReportDefinitions() {
        return this.to('ListReportDefinitions');
    }
    /**
     * (experimental) Grants permission to create Application Cost Profiler Report configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_PutReportDefinition.html
     *
     * @experimental
     */
    toPutReportDefinition() {
        return this.to('PutReportDefinition');
    }
    /**
     * (experimental) Grants permission to update an existing Application Cost Profiler Report configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-cost-profiler/latest/APIReference/API_UpdateReportDefinition.html
     *
     * @experimental
     */
    toUpdateReportDefinition() {
        return this.to('UpdateReportDefinition');
    }
}
exports.ApplicationCostProfiler = ApplicationCostProfiler;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCostProfiler[_a] = { fqn: "iam-floyd.ApplicationCostProfiler", version: "0.316.0" };
//# sourceMappingURL=data:application/json;base64,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