import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
 *
 * @experimental
 */
export declare class Auditmanager extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [auditmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsauditmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate an evidence folder with an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_AssociateAssessmentReportEvidenceFolder.html
     *
     * @experimental
     */
    toAssociateAssessmentReportEvidenceFolder(): this;
    /**
     * (experimental) Grants permission to associate a list of evidence to an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html
     *
     * @experimental
     */
    toBatchAssociateAssessmentReportEvidence(): this;
    /**
     * (experimental) Grants permission to create delegations for an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchCreateDelegationByAssessment.html
     *
     * @experimental
     */
    toBatchCreateDelegationByAssessment(): this;
    /**
     * (experimental) Grants permission to delete delegations for an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDeleteDelegationByAssessment.html
     *
     * @experimental
     */
    toBatchDeleteDelegationByAssessment(): this;
    /**
     * (experimental) Grants permission to disassociate a list of evidence from an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchDisassociateAssessmentReportEvidence.html
     *
     * @experimental
     */
    toBatchDisassociateAssessmentReportEvidence(): this;
    /**
     * (experimental) Grants permission to import a list of evidence to an assessment control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchImportEvidenceToAssessmentControl.html
     *
     * @experimental
     */
    toBatchImportEvidenceToAssessmentControl(): this;
    /**
     * (experimental) Grants permission to create an assessment to be used with AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html
     *
     * @experimental
     */
    toCreateAssessment(): this;
    /**
     * (experimental) Grants permission to create a framework for use in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentFramework.html
     *
     * @experimental
     */
    toCreateAssessmentFramework(): this;
    /**
     * (experimental) Grants permission to create an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessmentReport.html
     *
     * @experimental
     */
    toCreateAssessmentReport(): this;
    /**
     * (experimental) Grants permission to create a control to be used in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateControl.html
     *
     * @experimental
     */
    toCreateControl(): this;
    /**
     * (experimental) Grants permission to delete an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html
     *
     * @experimental
     */
    toDeleteAssessment(): this;
    /**
     * (experimental) Grants permission to delete an assessment framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html
     *
     * @experimental
     */
    toDeleteAssessmentFramework(): this;
    /**
     * (experimental) Grants permission to delete a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toDeleteAssessmentFrameworkShare(): this;
    /**
     * (experimental) Grants permission to delete an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html
     *
     * @experimental
     */
    toDeleteAssessmentReport(): this;
    /**
     * (experimental) Grants permission to delete a control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html
     *
     * @experimental
     */
    toDeleteControl(): this;
    /**
     * (experimental) Grants permission to deregister an account in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ DeregisterAccount.html
     *
     * @experimental
     */
    toDeregisterAccount(): this;
    /**
     * (experimental) Grants permission to deregister the delegated administrator account for AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterOrganizationAdminAccount.html
     *
     * @experimental
     */
    toDeregisterOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to disassociate an evidence folder from an assessment report in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DisassociateAssessmentReportEvidenceFolder.html
     *
     * @experimental
     */
    toDisassociateAssessmentReportEvidenceFolder(): this;
    /**
     * (experimental) Grants permission to get the status of an account in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAccountStatus.html
     *
     * @experimental
     */
    toGetAccountStatus(): this;
    /**
     * (experimental) Grants permission to get an assessment created in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessment.html
     *
     * @experimental
     */
    toGetAssessment(): this;
    /**
     * (experimental) Grants permission to get an assessment framework in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentFramework.html
     *
     * @experimental
     */
    toGetAssessmentFramework(): this;
    /**
     * (experimental) Grants permission to get the URL for an assessment report in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetAssessmentReportUrl.html
     *
     * @experimental
     */
    toGetAssessmentReportUrl(): this;
    /**
     * (experimental) Grants permission to get changelogs for an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetChangeLogs.html
     *
     * @experimental
     */
    toGetChangeLogs(): this;
    /**
     * (experimental) Grants permission to get a control in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetControl.html
     *
     * @experimental
     */
    toGetControl(): this;
    /**
     * (experimental) Grants permission to get all delegations in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetDelegations.html
     *
     * @experimental
     */
    toGetDelegations(): this;
    /**
     * (experimental) Grants permission to get evidence from AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidence.html
     *
     * @experimental
     */
    toGetEvidence(): this;
    /**
     * (experimental) Grants permission to get all the evidence from an evidence folder in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceByEvidenceFolder.html
     *
     * @experimental
     */
    toGetEvidenceByEvidenceFolder(): this;
    /**
     * (experimental) Grants permission to get the evidence folder from AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFolder.html
     *
     * @experimental
     */
    toGetEvidenceFolder(): this;
    /**
     * (experimental) Grants permission to get the evidence folders from an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessment.html
     *
     * @experimental
     */
    toGetEvidenceFoldersByAssessment(): this;
    /**
     * (experimental) Grants permission to get the evidence folders from an assessment control in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetEvidenceFoldersByAssessmentControl.html
     *
     * @experimental
     */
    toGetEvidenceFoldersByAssessmentControl(): this;
    /**
     * (experimental) Grants permission to get analytics data for all active assessments.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsights.html
     *
     * @experimental
     */
    toGetInsights(): this;
    /**
     * (experimental) Grants permission to get analytics data for a specific active assessment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetInsightsByAssessment.html
     *
     * @experimental
     */
    toGetInsightsByAssessment(): this;
    /**
     * (experimental) Grants permission to get the delegated administrator account in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetOrganizationAdminAccount.html
     *
     * @experimental
     */
    toGetOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to get the services in scope for an assessment in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetServicesInScope.html
     *
     * @experimental
     */
    toGetServicesInScope(): this;
    /**
     * (experimental) Grants permission to get all settings configured in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_GetSettings.html
     *
     * @experimental
     */
    toGetSettings(): this;
    /**
     * (experimental) Grants permission to list analytics data for controls in a specific control domain and active assessment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentControlInsightsByControlDomain.html
     *
     * @experimental
     */
    toListAssessmentControlInsightsByControlDomain(): this;
    /**
     * (experimental) Grants permission to list all sent or received share requests for custom frameworks in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworkShareRequests.html
     *
     * @experimental
     */
    toListAssessmentFrameworkShareRequests(): this;
    /**
     * (experimental) Grants permission to list all assessment frameworks in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentFrameworks.html
     *
     * @experimental
     */
    toListAssessmentFrameworks(): this;
    /**
     * (experimental) Grants permission to list all assessment reports in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessmentReports.html
     *
     * @experimental
     */
    toListAssessmentReports(): this;
    /**
     * (experimental) Grants permission to list all assessments in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListAssessments.html
     *
     * @experimental
     */
    toListAssessments(): this;
    /**
     * (experimental) Grants permission to list analytics data for control domains across all active assessments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsights.html
     *
     * @experimental
     */
    toListControlDomainInsights(): this;
    /**
     * (experimental) Grants permission to list analytics data for control domains in a specific active assessment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlDomainInsightsByAssessment.html
     *
     * @experimental
     */
    toListControlDomainInsightsByAssessment(): this;
    /**
     * (experimental) Grants permission to list analytics data for controls in a specific control domain across all active assessments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControlInsightsByControlDomain.html
     *
     * @experimental
     */
    toListControlInsightsByControlDomain(): this;
    /**
     * (experimental) Grants permission to list all controls in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListControls.html
     *
     * @experimental
     */
    toListControls(): this;
    /**
     * (experimental) Grants permission to list all the data source keywords in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListKeywordsForDataSource.html
     *
     * @experimental
     */
    toListKeywordsForDataSource(): this;
    /**
     * (experimental) Grants permission to list all notifications in AWS Audit Manager.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListNotifications.html
     *
     * @experimental
     */
    toListNotifications(): this;
    /**
     * (experimental) Grants permission to list tags for an AWS Audit Manager resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to register an account in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html
     *
     * @experimental
     */
    toRegisterAccount(): this;
    /**
     * (experimental) Grants permission to register an account within the organization as the delegated administrator for AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterOrganizationAdminAccount.html
     *
     * @experimental
     */
    toRegisterOrganizationAdminAccount(): this;
    /**
     * (experimental) Grants permission to create a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_StartAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toStartAssessmentFrameworkShare(): this;
    /**
     * (experimental) Grants permission to tag an AWS Audit Manager resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag an AWS Audit Manager resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessment.html
     *
     * @experimental
     */
    toUpdateAssessment(): this;
    /**
     * (experimental) Grants permission to update an assessment control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControl.html
     *
     * @experimental
     */
    toUpdateAssessmentControl(): this;
    /**
     * (experimental) Grants permission to update the status of an assessment control set in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentControlSetStatus.html
     *
     * @experimental
     */
    toUpdateAssessmentControlSetStatus(): this;
    /**
     * (experimental) Grants permission to update an assessment framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFramework.html
     *
     * @experimental
     */
    toUpdateAssessmentFramework(): this;
    /**
     * (experimental) Grants permission to update a share request for a custom framework in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentFrameworkShare.html
     *
     * @experimental
     */
    toUpdateAssessmentFrameworkShare(): this;
    /**
     * (experimental) Grants permission to update the status of an assessment in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateAssessmentStatus.html
     *
     * @experimental
     */
    toUpdateAssessmentStatus(): this;
    /**
     * (experimental) Grants permission to update a control in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateControl.html
     *
     * @experimental
     */
    toUpdateControl(): this;
    /**
     * (experimental) Grants permission to update settings in AWS Audit Manager.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_UpdateSettings.html
     *
     * @experimental
     */
    toUpdateSettings(): this;
    /**
     * (experimental) Grants permission to validate the integrity of an assessment report in AWS Audit Manager.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_ValidateAssessmentReportIntegrity.html
     *
     * @experimental
     */
    toValidateAssessmentReportIntegrity(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type assessment to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Assessment.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessment(assessmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type assessmentFramework to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentFramework.html
     *
     * @param assessmentFrameworkId - Identifier for the assessmentFrameworkId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessmentFramework(assessmentFrameworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type assessmentControlSet to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_AssessmentControlSet.html
     *
     * @param assessmentId - Identifier for the assessmentId.
     * @param controlSetId - Identifier for the controlSetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssessmentControlSet(assessmentId: string, controlSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type control to the statement.
     *
     * https://docs.aws.amazon.com/audit-manager/latest/userguide/API_Control.html
     *
     * @param controlId - Identifier for the controlId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onControl(controlId: string, account?: string, region?: string, partition?: string): this;
}
