import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [rum](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudwatchrum.html).
 *
 * @experimental
 */
export declare class Rum extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [rum](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudwatchrum.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create appMonitor metadata.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:GetRole
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_CreateAppMonitor.html
     *
     * @experimental
     */
    toCreateAppMonitor(): this;
    /**
     * (experimental) Grants permission to delete appMonitor metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_DeleteAppMonitor.html
     *
     * @experimental
     */
    toDeleteAppMonitor(): this;
    /**
     * (experimental) Grants permission to get appMonitor metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_GetAppMonitor.html
     *
     * @experimental
     */
    toGetAppMonitor(): this;
    /**
     * (experimental) Grants permission to get appMonitor data.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_GetAppMonitorData.html
     *
     * @experimental
     */
    toGetAppMonitorData(): this;
    /**
     * (experimental) Grants permission to list appMonitors metadata.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_ListAppMonitors.html
     *
     * @experimental
     */
    toListAppMonitors(): this;
    /**
     * (experimental) Grants permission to list tags for resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to put RUM events for appmonitor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_PutRumEvents.html
     *
     * @experimental
     */
    toPutRumEvents(): this;
    /**
     * (experimental) Grants permission to tag resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update appmonitor metadata.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:GetRole
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_UpdateAppMonitor.html
     *
     * @experimental
     */
    toUpdateAppMonitor(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type AppMonitorResource to the statement.
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_AppMonitor.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAppMonitorResource(name: string, account?: string, region?: string, partition?: string): this;
}
