import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
 *
 * @experimental
 */
export declare class CodedeployCommandsSecure extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to get deployment specification.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toGetDeploymentSpecification(): this;
    /**
     * (experimental) Grants permission to request host agent commands.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPollHostCommand(): this;
    /**
     * (experimental) Grants permission to mark host agent commands acknowledged.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPutHostCommandAcknowledgement(): this;
    /**
     * (experimental) Grants permission to mark host agent commands completed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPutHostCommandComplete(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
