"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
 *
 * @experimental
 */
class Comprehend extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'comprehend';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Read: [
                'BatchDetectDominantLanguage',
                'BatchDetectEntities',
                'BatchDetectKeyPhrases',
                'BatchDetectSentiment',
                'BatchDetectSyntax',
                'ClassifyDocument',
                'ContainsPiiEntities',
                'DescribeDocumentClassificationJob',
                'DescribeDocumentClassifier',
                'DescribeDominantLanguageDetectionJob',
                'DescribeEndpoint',
                'DescribeEntitiesDetectionJob',
                'DescribeEntityRecognizer',
                'DescribeEventsDetectionJob',
                'DescribeKeyPhrasesDetectionJob',
                'DescribePiiEntitiesDetectionJob',
                'DescribeResourcePolicy',
                'DescribeSentimentDetectionJob',
                'DescribeTopicsDetectionJob',
                'DetectDominantLanguage',
                'DetectEntities',
                'DetectKeyPhrases',
                'DetectPiiEntities',
                'DetectSentiment',
                'DetectSyntax',
                'ListDocumentClassificationJobs',
                'ListDocumentClassifierSummaries',
                'ListDocumentClassifiers',
                'ListDominantLanguageDetectionJobs',
                'ListEndpoints',
                'ListEntitiesDetectionJobs',
                'ListEntityRecognizerSummaries',
                'ListEntityRecognizers',
                'ListEventsDetectionJobs',
                'ListKeyPhrasesDetectionJobs',
                'ListPiiEntitiesDetectionJobs',
                'ListSentimentDetectionJobs',
                'ListTagsForResource',
                'ListTopicsDetectionJobs'
            ],
            Write: [
                'CreateDocumentClassifier',
                'CreateEndpoint',
                'CreateEntityRecognizer',
                'DeleteDocumentClassifier',
                'DeleteEndpoint',
                'DeleteEntityRecognizer',
                'DeleteResourcePolicy',
                'ImportModel',
                'PutResourcePolicy',
                'StartDocumentClassificationJob',
                'StartDominantLanguageDetectionJob',
                'StartEntitiesDetectionJob',
                'StartEventsDetectionJob',
                'StartKeyPhrasesDetectionJob',
                'StartPiiEntitiesDetectionJob',
                'StartSentimentDetectionJob',
                'StartTopicsDetectionJob',
                'StopDominantLanguageDetectionJob',
                'StopEntitiesDetectionJob',
                'StopEventsDetectionJob',
                'StopKeyPhrasesDetectionJob',
                'StopPiiEntitiesDetectionJob',
                'StopSentimentDetectionJob',
                'StopTrainingDocumentClassifier',
                'StopTrainingEntityRecognizer',
                'UpdateEndpoint'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * (experimental) Grants permission to detect the language or languages present in the list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectDominantLanguage.html
     *
     * @experimental
     */
    toBatchDetectDominantLanguage() {
        return this.to('BatchDetectDominantLanguage');
    }
    /**
     * (experimental) Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectEntities.html
     *
     * @experimental
     */
    toBatchDetectEntities() {
        return this.to('BatchDetectEntities');
    }
    /**
     * (experimental) Grants permission to detect the phrases in the list of text documents that are most indicative of the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectKeyPhrases.html
     *
     * @experimental
     */
    toBatchDetectKeyPhrases() {
        return this.to('BatchDetectKeyPhrases');
    }
    /**
     * (experimental) Grants permission to detect the sentiment of a text in the list of documents (Positive, Negative, Neutral, or Mixed).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSentiment.html
     *
     * @experimental
     */
    toBatchDetectSentiment() {
        return this.to('BatchDetectSentiment');
    }
    /**
     * (experimental) Grants permission to detect syntactic information (like Part of Speech, Tokens) in a list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSyntax.html
     *
     * @experimental
     */
    toBatchDetectSyntax() {
        return this.to('BatchDetectSyntax');
    }
    /**
     * (experimental) Grants permission to create a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ClassifyDocument.html
     *
     * @experimental
     */
    toClassifyDocument() {
        return this.to('ClassifyDocument');
    }
    /**
     * (experimental) Grants permission to classify the personally identifiable information within given documents at realtime.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ContainsPiiEntities.html
     *
     * @experimental
     */
    toContainsPiiEntities() {
        return this.to('ContainsPiiEntities');
    }
    /**
     * (experimental) Grants permission to create a new document classifier that you can use to categorize documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateDocumentClassifier.html
     *
     * @experimental
     */
    toCreateDocumentClassifier() {
        return this.to('CreateDocumentClassifier');
    }
    /**
     * (experimental) Grants permission to create a model-specific endpoint for synchronous inference for a previously trained custom model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEndpoint.html
     *
     * @experimental
     */
    toCreateEndpoint() {
        return this.to('CreateEndpoint');
    }
    /**
     * (experimental) Grants permission to create an entity recognizer using submitted files.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEntityRecognizer.html
     *
     * @experimental
     */
    toCreateEntityRecognizer() {
        return this.to('CreateEntityRecognizer');
    }
    /**
     * (experimental) Grants permission to delete a previously created document classifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteDocumentClassifier.html
     *
     * @experimental
     */
    toDeleteDocumentClassifier() {
        return this.to('DeleteDocumentClassifier');
    }
    /**
     * (experimental) Grants permission to delete a model-specific endpoint for a previously-trained custom model.
     *
     * All endpoints must be deleted in order for the model to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEndpoint.html
     *
     * @experimental
     */
    toDeleteEndpoint() {
        return this.to('DeleteEndpoint');
    }
    /**
     * (experimental) Grants permission to delete a submitted entity recognizer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEntityRecognizer.html
     *
     * @experimental
     */
    toDeleteEntityRecognizer() {
        return this.to('DeleteEntityRecognizer');
    }
    /**
     * (experimental) Grants permission to remove policy on resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteResourcePolicy.html
     *
     * @experimental
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a document classification job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassificationJob.html
     *
     * @experimental
     */
    toDescribeDocumentClassificationJob() {
        return this.to('DescribeDocumentClassificationJob');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a document classifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassifier.html
     *
     * @experimental
     */
    toDescribeDocumentClassifier() {
        return this.to('DescribeDocumentClassifier');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a dominant language detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toDescribeDominantLanguageDetectionJob() {
        return this.to('DescribeDominantLanguageDetectionJob');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a specific endpoint.
     *
     * Use this operation to get the status of an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEndpoint.html
     *
     * @experimental
     */
    toDescribeEndpoint() {
        return this.to('DescribeEndpoint');
    }
    /**
     * (experimental) Grants permission to get the properties associated with an entities detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntitiesDetectionJob.html
     *
     * @experimental
     */
    toDescribeEntitiesDetectionJob() {
        return this.to('DescribeEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to provide details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntityRecognizer.html
     *
     * @experimental
     */
    toDescribeEntityRecognizer() {
        return this.to('DescribeEntityRecognizer');
    }
    /**
     * (experimental) Grants permission to get the properties associated with an Events detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEventsDetectionJob.html
     *
     * @experimental
     */
    toDescribeEventsDetectionJob() {
        return this.to('DescribeEventsDetectionJob');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a key phrases detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toDescribeKeyPhrasesDetectionJob() {
        return this.to('DescribeKeyPhrasesDetectionJob');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a PII entities detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribePiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toDescribePiiEntitiesDetectionJob() {
        return this.to('DescribePiiEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to read attached policy on resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeResourcePolicy.html
     *
     * @experimental
     */
    toDescribeResourcePolicy() {
        return this.to('DescribeResourcePolicy');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a sentiment detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeSentimentDetectionJob.html
     *
     * @experimental
     */
    toDescribeSentimentDetectionJob() {
        return this.to('DescribeSentimentDetectionJob');
    }
    /**
     * (experimental) Grants permission to get the properties associated with a topic detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeTopicsDetectionJob.html
     *
     * @experimental
     */
    toDescribeTopicsDetectionJob() {
        return this.to('DescribeTopicsDetectionJob');
    }
    /**
     * (experimental) Grants permission to detect the language or languages present in the text.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html
     *
     * @experimental
     */
    toDetectDominantLanguage() {
        return this.to('DetectDominantLanguage');
    }
    /**
     * (experimental) Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectEntities.html
     *
     * @experimental
     */
    toDetectEntities() {
        return this.to('DetectEntities');
    }
    /**
     * (experimental) Grants permission to detect the phrases in the text that are most indicative of the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectKeyPhrases.html
     *
     * @experimental
     */
    toDetectKeyPhrases() {
        return this.to('DetectKeyPhrases');
    }
    /**
     * (experimental) Grants permission to detect the personally identifiable information entities ("Name", "SSN", "PIN", etc) within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectPiiEntities.html
     *
     * @experimental
     */
    toDetectPiiEntities() {
        return this.to('DetectPiiEntities');
    }
    /**
     * (experimental) Grants permission to detect the sentiment of a text in a document (Positive, Negative, Neutral, or Mixed).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSentiment.html
     *
     * @experimental
     */
    toDetectSentiment() {
        return this.to('DetectSentiment');
    }
    /**
     * (experimental) Grants permission to detect syntactic information (like Part of Speech, Tokens) in a text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSyntax.html
     *
     * @experimental
     */
    toDetectSyntax() {
        return this.to('DetectSyntax');
    }
    /**
     * (experimental) Grants permission to import a trained Comprehend model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifModelKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ImportModel.html
     *
     * @experimental
     */
    toImportModel() {
        return this.to('ImportModel');
    }
    /**
     * (experimental) Grants permission to get a list of the document classification jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassificationJobs.html
     *
     * @experimental
     */
    toListDocumentClassificationJobs() {
        return this.to('ListDocumentClassificationJobs');
    }
    /**
     * (experimental) Grants permission to get a list of summaries of the document classifiers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifierSummaries.html
     *
     * @experimental
     */
    toListDocumentClassifierSummaries() {
        return this.to('ListDocumentClassifierSummaries');
    }
    /**
     * (experimental) Grants permission to get a list of the document classifiers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifiers.html
     *
     * @experimental
     */
    toListDocumentClassifiers() {
        return this.to('ListDocumentClassifiers');
    }
    /**
     * (experimental) Grants permission to get a list of the dominant language detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDominantLanguageDetectionJobs.html
     *
     * @experimental
     */
    toListDominantLanguageDetectionJobs() {
        return this.to('ListDominantLanguageDetectionJobs');
    }
    /**
     * (experimental) Grants permission to get a list of all existing endpoints that you've created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEndpoints.html
     *
     * @experimental
     */
    toListEndpoints() {
        return this.to('ListEndpoints');
    }
    /**
     * (experimental) Grants permission to get a list of the entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntitiesDetectionJobs.html
     *
     * @experimental
     */
    toListEntitiesDetectionJobs() {
        return this.to('ListEntitiesDetectionJobs');
    }
    /**
     * (experimental) Grants permission to get a list of summaries for the entity recognizers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizerSummaries.html
     *
     * @experimental
     */
    toListEntityRecognizerSummaries() {
        return this.to('ListEntityRecognizerSummaries');
    }
    /**
     * (experimental) Grants permission to get a list of the properties of all entity recognizers that you created, including recognizers currently in training.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizers.html
     *
     * @experimental
     */
    toListEntityRecognizers() {
        return this.to('ListEntityRecognizers');
    }
    /**
     * (experimental) Grants permission to get a list of Events detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEventsDetectionJobs.html
     *
     * @experimental
     */
    toListEventsDetectionJobs() {
        return this.to('ListEventsDetectionJobs');
    }
    /**
     * (experimental) Grants permission to get a list of key phrase detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListKeyPhrasesDetectionJobs.html
     *
     * @experimental
     */
    toListKeyPhrasesDetectionJobs() {
        return this.to('ListKeyPhrasesDetectionJobs');
    }
    /**
     * (experimental) Grants permission to get a list of PII entities detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListPiiEntitiesDetectionJobs.html
     *
     * @experimental
     */
    toListPiiEntitiesDetectionJobs() {
        return this.to('ListPiiEntitiesDetectionJobs');
    }
    /**
     * (experimental) Grants permission to get a list of sentiment detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListSentimentDetectionJobs.html
     *
     * @experimental
     */
    toListSentimentDetectionJobs() {
        return this.to('ListSentimentDetectionJobs');
    }
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to get a list of the topic detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTopicsDetectionJobs.html
     *
     * @experimental
     */
    toListTopicsDetectionJobs() {
        return this.to('ListTopicsDetectionJobs');
    }
    /**
     * (experimental) Grants permission to attach policy to resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_PutResourcePolicy.html
     *
     * @experimental
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * (experimental) Grants permission to start an asynchronous document classification job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDocumentClassificationJob.html
     *
     * @experimental
     */
    toStartDocumentClassificationJob() {
        return this.to('StartDocumentClassificationJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous dominant language detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toStartDominantLanguageDetectionJob() {
        return this.to('StartDominantLanguageDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStartEntitiesDetectionJob() {
        return this.to('StartEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous Events detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEventsDetectionJob.html
     *
     * @experimental
     */
    toStartEventsDetectionJob() {
        return this.to('StartEventsDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous key phrase detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toStartKeyPhrasesDetectionJob() {
        return this.to('StartKeyPhrasesDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous PII entities detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartPiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStartPiiEntitiesDetectionJob() {
        return this.to('StartPiiEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous sentiment detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartSentimentDetectionJob.html
     *
     * @experimental
     */
    toStartSentimentDetectionJob() {
        return this.to('StartSentimentDetectionJob');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect the most common topics in the collection of documents and the phrases associated with each topic.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartTopicsDetectionJob.html
     *
     * @experimental
     */
    toStartTopicsDetectionJob() {
        return this.to('StartTopicsDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop a dominant language detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toStopDominantLanguageDetectionJob() {
        return this.to('StopDominantLanguageDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop an entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStopEntitiesDetectionJob() {
        return this.to('StopEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop an Events detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEventsDetectionJob.html
     *
     * @experimental
     */
    toStopEventsDetectionJob() {
        return this.to('StopEventsDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop a key phrase detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toStopKeyPhrasesDetectionJob() {
        return this.to('StopKeyPhrasesDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop a PII entities detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopPiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStopPiiEntitiesDetectionJob() {
        return this.to('StopPiiEntitiesDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop a sentiment detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopSentimentDetectionJob.html
     *
     * @experimental
     */
    toStopSentimentDetectionJob() {
        return this.to('StopSentimentDetectionJob');
    }
    /**
     * (experimental) Grants permission to stop a previously created document classifier training job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingDocumentClassifier.html
     *
     * @experimental
     */
    toStopTrainingDocumentClassifier() {
        return this.to('StopTrainingDocumentClassifier');
    }
    /**
     * (experimental) Grants permission to stop a previously created entity recognizer training job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingEntityRecognizer.html
     *
     * @experimental
     */
    toStopTrainingEntityRecognizer() {
        return this.to('StopTrainingEntityRecognizer');
    }
    /**
     * (experimental) Grants permission to tag a resource with given key value pairs.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to untag a resource with given key.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update information about the specified endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UpdateEndpoint.html
     *
     * @experimental
     */
    toUpdateEndpoint() {
        return this.to('UpdateEndpoint');
    }
    /**
     * (experimental) Adds a resource of type document-classifier to the statement.
     *
     * @param documentClassifierName - Identifier for the documentClassifierName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassifier(documentClassifierName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classifier/${documentClassifierName}`);
    }
    /**
     * (experimental) Adds a resource of type document-classifier-endpoint to the statement.
     *
     * @param documentClassifierEndpointName - Identifier for the documentClassifierEndpointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassifierEndpoint(documentClassifierEndpointName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classifier-endpoint/${documentClassifierEndpointName}`);
    }
    /**
     * (experimental) Adds a resource of type entity-recognizer to the statement.
     *
     * @param entityRecognizerName - Identifier for the entityRecognizerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntityRecognizer(entityRecognizerName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entity-recognizer/${entityRecognizerName}`);
    }
    /**
     * (experimental) Adds a resource of type entity-recognizer-endpoint to the statement.
     *
     * @param entityRecognizerEndpointName - Identifier for the entityRecognizerEndpointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntityRecognizerEndpoint(entityRecognizerEndpointName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entity-recognizer-endpoint/${entityRecognizerEndpointName}`);
    }
    /**
     * (experimental) Adds a resource of type dominant-language-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDominantLanguageDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:dominant-language-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type entities-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntitiesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:entities-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type pii-entities-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPiiEntitiesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:pii-entities-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type events-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEventsDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:events-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type key-phrases-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onKeyPhrasesDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:key-phrases-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type sentiment-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSentimentDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:sentiment-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type topics-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTopicsDetectionJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:topics-detection-job/${jobId}`);
    }
    /**
     * (experimental) Adds a resource of type document-classification-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassificationJob(jobId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:comprehend:${region || '*'}:${account || '*'}:document-classification-job/${jobId}`);
    }
    /**
     * (experimental) Filters access by the model KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toImportModel()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifModelKmsKey(value, operator) {
        return this.if(`ModelKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * (experimental) Filters access by the output KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartEventsDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartPiiEntitiesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifOutputKmsKey(value, operator) {
        return this.if(`OutputKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * (experimental) Filters access by the volume KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifVolumeKmsKey(value, operator) {
        return this.if(`VolumeKmsKey`, value, operator || 'ArnLike');
    }
    /**
     * (experimental) Filters access by the list of all VPC security group ids associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpcSecurityGroupIds(value, operator) {
        return this.if(`VpcSecurityGroupIds`, value, operator || 'StringLike');
    }
    /**
     * (experimental) Filters access by the list of all VPC subnets associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpcSubnets(value, operator) {
        return this.if(`VpcSubnets`, value, operator || 'StringLike');
    }
}
exports.Comprehend = Comprehend;
_a = JSII_RTTI_SYMBOL_1;
Comprehend[_a] = { fqn: "iam-floyd.Comprehend", version: "0.316.0" };
//# sourceMappingURL=data:application/json;base64,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